/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.support;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.LicenseUtils;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.security.authc.AuthenticationResult;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.support.DelegatedAuthorizationSettings;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.support.RealmUserLookup;

public class DelegatedAuthorizationSupport {
    private final RealmUserLookup lookup;
    private final Logger logger;
    private final XPackLicenseState licenseState;

    public DelegatedAuthorizationSupport(Iterable<? extends Realm> allRealms, RealmConfig config, XPackLicenseState licenseState) {
        this(allRealms, (List)DelegatedAuthorizationSettings.AUTHZ_REALMS.get(config.settings()), config.globalSettings(), config.threadContext(), licenseState);
    }

    protected DelegatedAuthorizationSupport(Iterable<? extends Realm> allRealms, List<String> lookupRealms, Settings settings, ThreadContext threadContext, XPackLicenseState licenseState) {
        List<Realm> resolvedLookupRealms = this.resolveRealms(allRealms, lookupRealms);
        this.checkForRealmChains(resolvedLookupRealms, settings);
        this.lookup = new RealmUserLookup(resolvedLookupRealms, threadContext);
        this.logger = Loggers.getLogger(this.getClass());
        this.licenseState = licenseState;
    }

    public boolean hasDelegation() {
        return this.lookup.hasRealms();
    }

    public void resolve(String username, ActionListener<AuthenticationResult> resultListener) {
        if (!this.licenseState.isAuthorizationRealmAllowed()) {
            resultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)(DelegatedAuthorizationSettings.AUTHZ_REALMS.getKey() + " are not permitted"), (Exception)((Object)LicenseUtils.newComplianceException((String)DelegatedAuthorizationSettings.AUTHZ_REALMS.getKey()))));
            return;
        }
        if (!this.hasDelegation()) {
            resultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)("No [" + DelegatedAuthorizationSettings.AUTHZ_REALMS.getKey() + "] have been configured"), null));
            return;
        }
        ActionListener userListener = ActionListener.wrap(tuple -> {
            if (tuple != null) {
                this.logger.trace("Found user " + tuple.v1() + " in realm " + tuple.v2());
                resultListener.onResponse((Object)AuthenticationResult.success((User)((User)tuple.v1())));
            } else {
                resultListener.onResponse((Object)AuthenticationResult.unsuccessful((String)("the principal [" + username + "] was authenticated, but no user could be found in realms [" + Strings.collectionToDelimitedString(this.lookup.getRealms(), (String)",") + "]"), null));
            }
        }, arg_0 -> resultListener.onFailure(arg_0));
        this.lookup.lookup(username, (ActionListener<Tuple<User, Realm>>)userListener);
    }

    private List<Realm> resolveRealms(Iterable<? extends Realm> allRealms, List<String> lookupRealms) {
        ArrayList<Realm> result = new ArrayList<Realm>(lookupRealms.size());
        for (String name : lookupRealms) {
            result.add(this.findRealm(name, allRealms));
        }
        assert (result.size() == lookupRealms.size());
        return result;
    }

    private void checkForRealmChains(Iterable<Realm> delegatedRealms, Settings globalSettings) {
        Map settingsByRealm = RealmSettings.getRealmSettings((Settings)globalSettings);
        for (Realm realm : delegatedRealms) {
            Settings realmSettings = (Settings)settingsByRealm.get(realm.name());
            if (realmSettings == null || !DelegatedAuthorizationSettings.AUTHZ_REALMS.exists(realmSettings)) continue;
            throw new IllegalArgumentException("cannot use realm [" + realm + "] as an authorization realm - it is already delegating authorization to [" + DelegatedAuthorizationSettings.AUTHZ_REALMS.get(realmSettings) + "]");
        }
    }

    private Realm findRealm(String name, Iterable<? extends Realm> allRealms) {
        for (Realm realm : allRealms) {
            if (!name.equals(realm.name())) continue;
            return realm;
        }
        throw new IllegalArgumentException("configured authorization realm [" + name + "] does not exist (or is not enabled)");
    }
}

