/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.user;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequestBuilder;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestHasPrivilegesAction
extends SecurityBaseRestHandler {
    private final SecurityContext securityContext;

    public RestHasPrivilegesAction(Settings settings, RestController controller, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/user/{username}/_has_privileges", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/{username}/_has_privileges", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.GET, "/_xpack/security/user/_has_privileges", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_xpack/security/user/_has_privileges", (RestHandler)this);
    }

    public String getName() {
        return "xpack_security_has_priviledges_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String username = this.getUsername(request);
        if (username == null) {
            return restChannel -> {
                throw new ElasticsearchSecurityException("there is no authenticated user", new Object[0]);
            };
        }
        Tuple content = request.contentOrSourceParam();
        HasPrivilegesRequestBuilder requestBuilder = new SecurityClient((ElasticsearchClient)client).prepareHasPrivileges(username, (BytesReference)content.v2(), (XContentType)content.v1());
        return channel -> requestBuilder.execute((ActionListener)new HasPrivilegesRestResponseBuilder(username, (RestChannel)channel));
    }

    private String getUsername(RestRequest request) {
        String username = request.param("username");
        if (username != null) {
            return username;
        }
        User user = this.securityContext.getUser();
        if (user == null) {
            return null;
        }
        return user.principal();
    }

    static class HasPrivilegesRestResponseBuilder
    extends RestBuilderListener<HasPrivilegesResponse> {
        private String username;

        HasPrivilegesRestResponseBuilder(String username, RestChannel channel) {
            super(channel);
            this.username = username;
        }

        public RestResponse buildResponse(HasPrivilegesResponse response, XContentBuilder builder) throws Exception {
            builder.startObject().field("username", this.username).field("has_all_requested", response.isCompleteMatch());
            builder.field("cluster");
            builder.map(response.getClusterPrivileges());
            this.appendResources(builder, "index", response.getIndexPrivileges());
            builder.startObject("application");
            Map appPrivileges = response.getApplicationPrivileges();
            for (String app : appPrivileges.keySet()) {
                this.appendResources(builder, app, (List)appPrivileges.get(app));
            }
            builder.endObject();
            builder.endObject();
            return new BytesRestResponse(RestStatus.OK, builder);
        }

        private void appendResources(XContentBuilder builder, String field, List<HasPrivilegesResponse.ResourcePrivileges> privileges) throws IOException {
            builder.startObject(field);
            for (HasPrivilegesResponse.ResourcePrivileges privilege : privileges) {
                builder.field(privilege.getResource());
                builder.map(privilege.getPrivileges());
            }
            builder.endObject();
        }
    }
}

