/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public abstract class Attribute
extends NamedExpression {
    private final String qualifier;
    private final boolean nullable;

    public Attribute(Location location, String name, String qualifier, ExpressionId id) {
        this(location, name, qualifier, true, id);
    }

    public Attribute(Location location, String name, String qualifier, boolean nullable, ExpressionId id) {
        this(location, name, qualifier, nullable, id, false);
    }

    public Attribute(Location location, String name, String qualifier, boolean nullable, ExpressionId id, boolean synthetic) {
        super(location, name, Collections.emptyList(), id, synthetic);
        this.qualifier = qualifier;
        this.nullable = nullable;
    }

    @Override
    public final Expression replaceChildren(List<Expression> newChildren) {
        throw new UnsupportedOperationException("this type of node doesn't have any children to replace");
    }

    @Override
    public ScriptTemplate asScript() {
        throw new SqlIllegalArgumentException("Encountered a bug - an attribute should never be scripted");
    }

    public String qualifier() {
        return this.qualifier;
    }

    public String qualifiedName() {
        return this.qualifier == null ? this.name() : this.qualifier + "." + this.name();
    }

    @Override
    public boolean nullable() {
        return this.nullable;
    }

    @Override
    public AttributeSet references() {
        return new AttributeSet(this);
    }

    public Attribute withLocation(Location location) {
        return Objects.equals(this.location(), location) ? this : this.clone(location, this.name(), this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withQualifier(String qualifier) {
        return Objects.equals(this.qualifier(), qualifier) ? this : this.clone(this.location(), this.name(), qualifier, this.nullable(), this.id(), this.synthetic());
    }

    public Attribute withNullability(boolean nullable) {
        return Objects.equals(this.nullable(), nullable) ? this : this.clone(this.location(), this.name(), this.qualifier(), nullable, this.id(), this.synthetic());
    }

    protected abstract Attribute clone(Location var1, String var2, String var3, boolean var4, ExpressionId var5, boolean var6);

    @Override
    public Attribute toAttribute() {
        return this;
    }

    @Override
    public int semanticHash() {
        return this.id().hashCode();
    }

    @Override
    protected NodeInfo<? extends Expression> info() {
        return null;
    }

    @Override
    public boolean semanticEquals(Expression other) {
        return other instanceof Attribute ? this.id().equals(((Attribute)other).id()) : false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.qualifier, this.nullable);
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            Attribute other = (Attribute)obj;
            return Objects.equals(this.qualifier, other.qualifier) && Objects.equals(this.nullable, other.nullable);
        }
        return false;
    }

    @Override
    public String toString() {
        return this.name() + "{" + this.label() + "}#" + this.id();
    }

    protected abstract String label();
}

