/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.Alias;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.AttributeMap;
import org.elasticsearch.xpack.sql.expression.AttributeSet;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypes;

public final class Expressions {
    private Expressions() {
    }

    public static NamedExpression wrapAsNamed(Expression exp) {
        return exp instanceof NamedExpression ? (NamedExpression)exp : new Alias(exp.location(), exp.nodeName(), exp);
    }

    public static List<Attribute> asAttributes(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Attribute> list = new ArrayList<Attribute>(named.size());
        for (NamedExpression namedExpression : named) {
            list.add(namedExpression.toAttribute());
        }
        return list;
    }

    public static AttributeMap<Expression> asAttributeMap(List<? extends NamedExpression> named) {
        if (named.isEmpty()) {
            return new AttributeMap<Expression>(Collections.emptyMap());
        }
        AttributeMap<Expression> map = new AttributeMap<Expression>();
        for (NamedExpression namedExpression : named) {
            map.add(namedExpression.toAttribute(), namedExpression);
        }
        return map;
    }

    public static boolean anyMatch(List<? extends Expression> exps, Predicate<? super Expression> predicate) {
        for (Expression expression : exps) {
            if (!expression.anyMatch(predicate)) continue;
            return true;
        }
        return false;
    }

    public static boolean nullable(List<? extends Expression> exps) {
        for (Expression expression : exps) {
            if (!expression.nullable()) continue;
            return true;
        }
        return false;
    }

    public static boolean foldable(List<? extends Expression> exps) {
        for (Expression expression : exps) {
            if (expression.foldable()) continue;
            return false;
        }
        return true;
    }

    public static AttributeSet references(List<? extends Expression> exps) {
        if (exps.isEmpty()) {
            return AttributeSet.EMPTY;
        }
        AttributeSet set = new AttributeSet();
        for (Expression expression : exps) {
            set.addAll(expression.references());
        }
        return set;
    }

    public static String name(Expression e) {
        return e instanceof NamedExpression ? ((NamedExpression)e).name() : e.nodeName();
    }

    public static List<String> names(Collection<? extends Expression> e) {
        ArrayList<String> names = new ArrayList<String>(e.size());
        for (Expression expression : e) {
            names.add(Expressions.name(expression));
        }
        return names;
    }

    public static Attribute attribute(Expression e) {
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).toAttribute();
        }
        if (e != null && e.foldable()) {
            return Literal.of(e).toAttribute();
        }
        return null;
    }

    public static boolean equalsAsAttribute(Expression left, Expression right) {
        if (!left.semanticEquals(right)) {
            Attribute l = Expressions.attribute(left);
            return l != null && l.semanticEquals(Expressions.attribute(right));
        }
        return true;
    }

    public static Pipe pipe(Expression e) {
        if (e instanceof NamedExpression) {
            return ((NamedExpression)e).asPipe();
        }
        throw new SqlIllegalArgumentException("Cannot create pipe for {}", e);
    }

    public static Expression.TypeResolution typeMustBeBoolean(Expression e, String operationName, ParamOrdinal paramOrd) {
        return Expressions.typeMustBe(e, dt -> dt == DataType.BOOLEAN, operationName, paramOrd, "boolean");
    }

    public static Expression.TypeResolution typeMustBeInteger(Expression e, String operationName, ParamOrdinal paramOrd) {
        return Expressions.typeMustBe(e, dt -> dt.isInteger, operationName, paramOrd, "integer");
    }

    public static Expression.TypeResolution typeMustBeNumeric(Expression e, String operationName, ParamOrdinal paramOrd) {
        return Expressions.typeMustBe(e, DataType::isNumeric, operationName, paramOrd, "numeric");
    }

    public static Expression.TypeResolution typeMustBeString(Expression e, String operationName, ParamOrdinal paramOrd) {
        return Expressions.typeMustBe(e, DataType::isString, operationName, paramOrd, "string");
    }

    public static Expression.TypeResolution typeMustBeDate(Expression e, String operationName, ParamOrdinal paramOrd) {
        return Expressions.typeMustBe(e, dt -> dt == DataType.DATE, operationName, paramOrd, "date");
    }

    public static Expression.TypeResolution typeMustBeNumericOrDate(Expression e, String operationName, ParamOrdinal paramOrd) {
        return Expressions.typeMustBe(e, dt -> dt.isNumeric() || dt == DataType.DATE, operationName, paramOrd, "numeric", "date");
    }

    private static Expression.TypeResolution typeMustBe(Expression e, Predicate<DataType> predicate, String operationName, ParamOrdinal pOrd, String ... acceptedTypes) {
        return predicate.test(e.dataType()) || DataTypes.isNull(e.dataType()) ? Expression.TypeResolution.TYPE_RESOLVED : new Expression.TypeResolution(Expressions.incorrectTypeErrorMessage(e, operationName, pOrd, acceptedTypes));
    }

    private static String incorrectTypeErrorMessage(Expression e, String operationName, ParamOrdinal paramOrd, String ... acceptedTypes) {
        return String.format(Locale.ROOT, "[%s]%s argument must be [%s], found value [%s] type [%s]", operationName, paramOrd == null || paramOrd == ParamOrdinal.DEFAULT ? "" : " " + paramOrd.name().toLowerCase(Locale.ROOT), Strings.arrayToDelimitedString((Object[])acceptedTypes, (String)" or "), Expressions.name(e), e.dataType().esType);
    }

    public static enum ParamOrdinal {
        DEFAULT,
        FIRST,
        SECOND,
        THIRD,
        FOURTH;

    }
}

