/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function;

import java.util.List;
import java.util.StringJoiner;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.ExpressionId;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.NamedExpression;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.util.StringUtils;

public abstract class Function
extends NamedExpression {
    private final String functionName = StringUtils.camelCaseToUnderscore(this.getClass().getSimpleName());
    private final String name = this.functionName() + this.functionArgs();

    protected Function(Location location, List<Expression> children) {
        this(location, children, null, false);
    }

    protected Function(Location location, List<Expression> children, ExpressionId id, boolean synthetic) {
        super(location, null, children, id, synthetic);
    }

    public final List<Expression> arguments() {
        return this.children();
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean nullable() {
        return Expressions.nullable(this.children());
    }

    @Override
    public String toString() {
        return this.name() + "#" + this.id();
    }

    public String functionName() {
        return this.functionName;
    }

    public String functionId() {
        return this.id().toString();
    }

    protected String functionArgs() {
        StringJoiner sj = new StringJoiner(",", "(", ")");
        for (Expression child : this.children()) {
            String val = child instanceof NamedExpression && child.resolved() ? Expressions.name(child) : child.toString();
            sj.add(val);
        }
        return sj.toString();
    }

    public boolean functionEquals(Function f) {
        return f != null && this.getClass() == f.getClass() && this.arguments().equals(f.arguments());
    }
}

