/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.io.IOException;
import java.util.TimeZone;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.SqlIllegalArgumentException;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.joda.time.ReadableInstant;

public abstract class BaseDateTimeProcessor
implements Processor {
    private final TimeZone timeZone;

    BaseDateTimeProcessor(TimeZone timeZone) {
        this.timeZone = timeZone;
    }

    BaseDateTimeProcessor(StreamInput in) throws IOException {
        this.timeZone = TimeZone.getTimeZone(in.readString());
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.timeZone.getID());
    }

    TimeZone timeZone() {
        return this.timeZone;
    }

    @Override
    public Object process(Object l) {
        long millis;
        if (l == null) {
            return null;
        }
        if (l instanceof String) {
            millis = Long.parseLong(l.toString());
        } else if (l instanceof ReadableInstant) {
            millis = ((ReadableInstant)l).getMillis();
        } else {
            throw new SqlIllegalArgumentException("A string or a date is required; received {}", l);
        }
        return this.doProcess(millis);
    }

    abstract Object doProcess(long var1);
}

