/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.function.scalar.datetime;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.util.TimeZone;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.FieldAttribute;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.BaseDateTimeFunction;
import org.elasticsearch.xpack.sql.expression.function.scalar.datetime.DateTimeProcessor;
import org.elasticsearch.xpack.sql.expression.gen.processor.Processor;
import org.elasticsearch.xpack.sql.expression.gen.script.ParamsBuilder;
import org.elasticsearch.xpack.sql.expression.gen.script.ScriptTemplate;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;

public abstract class DateTimeFunction
extends BaseDateTimeFunction {
    DateTimeFunction(Location location, Expression field, TimeZone timeZone) {
        super(location, field, timeZone);
    }

    @Override
    protected Object doFold(long millis, String tzId) {
        return DateTimeFunction.dateTimeChrono(millis, tzId, this.chronoField().name());
    }

    public static Integer dateTimeChrono(long millis, String tzId, String chronoName) {
        ZonedDateTime time = ZonedDateTime.ofInstant(Instant.ofEpochMilli(millis), ZoneId.of(tzId));
        return time.get(ChronoField.valueOf(chronoName));
    }

    public static Integer dateTimeChrono(ZonedDateTime millis, String tzId, String chronoName) {
        ZonedDateTime time = millis.withZoneSameInstant(ZoneId.of(tzId));
        return time.get(ChronoField.valueOf(chronoName));
    }

    @Override
    public ScriptTemplate scriptWithField(FieldAttribute field) {
        ParamsBuilder params = ParamsBuilder.paramsBuilder();
        String template = null;
        template = this.formatTemplate("{sql}.dateTimeChrono(doc[{}].value, {}, {})");
        params.variable(field.name()).variable(this.timeZone().getID()).variable(this.chronoField().name());
        return new ScriptTemplate(template, params.build(), this.dataType());
    }

    protected abstract ChronoField chronoField();

    protected abstract DateTimeProcessor.DateTimeExtractor extractor();

    @Override
    protected Processor makeProcessor() {
        return new DateTimeProcessor(this.extractor(), this.timeZone());
    }

    @Override
    public DataType dataType() {
        return DataType.INTEGER;
    }

    public abstract String dateTimeFormat();
}

