/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate;

import java.util.Objects;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.Literal;
import org.elasticsearch.xpack.sql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.sql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.sql.tree.Location;

public abstract class BinaryPredicate<T, U, R, F extends PredicateBiFunction<T, U, R>>
extends BinaryScalarFunction {
    private final String name;
    private final F function;

    protected BinaryPredicate(Location location, Expression left, Expression right, F function) {
        super(location, left, right);
        this.name = BinaryPredicate.name(left, right, function.symbol());
        this.function = function;
    }

    public R fold() {
        return this.function().apply((Object)this.left().fold(), (Object)this.right().fold());
    }

    @Override
    protected String scriptMethodName() {
        return this.function.scriptMethodName();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.function.symbol());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryPredicate other = (BinaryPredicate)obj;
        return Objects.equals(this.symbol(), other.symbol()) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    @Override
    public String name() {
        return this.name;
    }

    public String symbol() {
        return this.function.symbol();
    }

    public F function() {
        return this.function;
    }

    private static String name(Expression left, Expression right, String symbol) {
        StringBuilder sb = new StringBuilder();
        sb.append(Expressions.name(left));
        if (!(left instanceof Literal)) {
            sb.insert(0, "(");
            sb.append(")");
        }
        sb.append(" ");
        sb.append(symbol);
        sb.append(" ");
        int pos = sb.length();
        sb.append(Expressions.name(right));
        if (!(right instanceof Literal)) {
            sb.insert(pos, "(");
            sb.append(")");
        }
        return sb.toString();
    }
}

