/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic;

import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Expressions;
import org.elasticsearch.xpack.sql.expression.gen.pipeline.Pipe;
import org.elasticsearch.xpack.sql.expression.predicate.BinaryOperator;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticPipe;
import org.elasticsearch.xpack.sql.expression.predicate.operator.arithmetic.BinaryArithmeticProcessor;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataType;
import org.elasticsearch.xpack.sql.type.DataTypeConversion;

public abstract class ArithmeticOperation
extends BinaryOperator<Number, Number, Number, BinaryArithmeticProcessor.BinaryArithmeticOperation> {
    protected ArithmeticOperation(Location location, Expression left, Expression right, BinaryArithmeticProcessor.BinaryArithmeticOperation operation) {
        super(location, left, right, operation);
    }

    @Override
    protected Expression.TypeResolution resolveInputType(Expression e, Expressions.ParamOrdinal paramOrdinal) {
        return Expressions.typeMustBeNumeric(e, this.symbol(), paramOrdinal);
    }

    public ArithmeticOperation swapLeftAndRight() {
        return this;
    }

    @Override
    public DataType dataType() {
        return DataTypeConversion.commonType(this.left().dataType(), this.right().dataType());
    }

    @Override
    protected Pipe makePipe() {
        return new BinaryArithmeticPipe(this.location(), this, Expressions.pipe(this.left()), Expressions.pipe(this.right()), (BinaryArithmeticProcessor.BinaryArithmeticOperation)this.function());
    }
}

