/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.xpack.sql.capabilities.Unresolvable;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.plan.TableIdentifier;
import org.elasticsearch.xpack.sql.plan.logical.LeafPlan;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class UnresolvedRelation
extends LeafPlan
implements Unresolvable {
    private final TableIdentifier table;
    private final String alias;
    private final String unresolvedMsg;

    public UnresolvedRelation(Location location, TableIdentifier table, String alias) {
        this(location, table, alias, null);
    }

    public UnresolvedRelation(Location location, TableIdentifier table, String alias, String unresolvedMessage) {
        super(location);
        this.table = table;
        this.alias = alias;
        this.unresolvedMsg = unresolvedMessage == null ? "Unknown index [" + table.index() + "]" : unresolvedMessage;
    }

    @Override
    protected NodeInfo<UnresolvedRelation> info() {
        return NodeInfo.create(this, UnresolvedRelation::new, this.table, this.alias, this.unresolvedMsg);
    }

    public TableIdentifier table() {
        return this.table;
    }

    public String alias() {
        return this.alias;
    }

    @Override
    public boolean resolved() {
        return false;
    }

    @Override
    public boolean expressionsResolved() {
        return false;
    }

    @Override
    public List<Attribute> output() {
        return Collections.emptyList();
    }

    @Override
    public String unresolvedMessage() {
        return this.unresolvedMsg;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.location(), this.table, this.alias, this.unresolvedMsg);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        UnresolvedRelation other = (UnresolvedRelation)obj;
        return this.location().equals(other.location()) && this.table.equals(other.table) && Objects.equals(this.alias, other.alias) && this.unresolvedMsg.equals(other.unresolvedMsg);
    }
}

