/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plan.logical.command;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.xpack.sql.analysis.index.IndexResolver;
import org.elasticsearch.xpack.sql.expression.Attribute;
import org.elasticsearch.xpack.sql.expression.predicate.regex.LikePattern;
import org.elasticsearch.xpack.sql.plan.logical.command.Command;
import org.elasticsearch.xpack.sql.session.Rows;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.session.SqlSession;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.tree.NodeInfo;

public class ShowTables
extends Command {
    private final String index;
    private final LikePattern pattern;

    public ShowTables(Location location, String index, LikePattern pattern) {
        super(location);
        this.index = index;
        this.pattern = pattern;
    }

    @Override
    protected NodeInfo<ShowTables> info() {
        return NodeInfo.create(this, ShowTables::new, this.index, this.pattern);
    }

    public String index() {
        return this.index;
    }

    public LikePattern pattern() {
        return this.pattern;
    }

    @Override
    public List<Attribute> output() {
        return Arrays.asList(this.keyword("name"), this.keyword("type"));
    }

    @Override
    public final void execute(SqlSession session, ActionListener<SchemaRowSet> listener) {
        String idx = this.index != null ? this.index : (this.pattern != null ? this.pattern.asIndexNameWildcard() : "*");
        String regex = this.pattern != null ? this.pattern.asJavaRegex() : null;
        session.indexResolver().resolveNames(idx, regex, null, (ActionListener<Set<IndexResolver.IndexInfo>>)ActionListener.wrap(result -> listener.onResponse((Object)Rows.of(this.output(), result.stream().map(t -> Arrays.asList(t.name(), t.type().toSql())).collect(Collectors.toList()))), arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.index, this.pattern);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        ShowTables other = (ShowTables)obj;
        return Objects.equals(this.index, other.index) && Objects.equals(this.pattern, other.pattern);
    }
}

