/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import org.elasticsearch.common.Booleans;
import org.elasticsearch.index.query.MatchQueryBuilder;
import org.elasticsearch.index.query.Operator;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.sql.expression.predicate.fulltext.MatchQueryPredicate;
import org.elasticsearch.xpack.sql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.sql.tree.Location;

public class MatchQuery
extends LeafQuery {
    private static final Map<String, BiConsumer<MatchQueryBuilder, String>> BUILDER_APPLIERS;
    private final String name;
    private final Object text;
    private final MatchQueryPredicate predicate;
    private final Map<String, String> options;

    public MatchQuery(Location location, String name, Object text) {
        this(location, name, text, null);
    }

    public MatchQuery(Location location, String name, Object text, MatchQueryPredicate predicate) {
        super(location);
        this.name = name;
        this.text = text;
        this.predicate = predicate;
        this.options = predicate == null ? Collections.emptyMap() : predicate.optionMap();
    }

    @Override
    public QueryBuilder asBuilder() {
        MatchQueryBuilder queryBuilder = QueryBuilders.matchQuery((String)this.name, (Object)this.text);
        this.options.forEach((k, v) -> {
            if (!BUILDER_APPLIERS.containsKey(k)) {
                throw new IllegalArgumentException("illegal match option [" + k + "]");
            }
            BUILDER_APPLIERS.get(k).accept(queryBuilder, (String)v);
        });
        return queryBuilder;
    }

    public String name() {
        return this.name;
    }

    public Object text() {
        return this.text;
    }

    MatchQueryPredicate predicate() {
        return this.predicate;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.text, this.name, this.predicate);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        MatchQuery other = (MatchQuery)obj;
        return Objects.equals(this.text, other.text) && Objects.equals(this.name, other.name) && Objects.equals(this.predicate, other.predicate);
    }

    @Override
    protected String innerToString() {
        return this.name + ":" + this.text;
    }

    static {
        HashMap<String, BiConsumer<MatchQueryBuilder, String>> appliers = new HashMap<String, BiConsumer<MatchQueryBuilder, String>>(11);
        appliers.put("cutoff_frequency", (qb, s) -> qb.cutoffFrequency(Float.valueOf(s).floatValue()));
        appliers.put("lenient", (qb, s) -> qb.lenient(Booleans.parseBoolean((String)s)));
        appliers.put("fuzzy_transpositions", (qb, s) -> qb.fuzzyTranspositions(Booleans.parseBoolean((String)s)));
        appliers.put("fuzzy_rewrite", (qb, s) -> qb.fuzzyRewrite(s));
        appliers.put("minimum_should_match", (qb, s) -> qb.minimumShouldMatch(s));
        appliers.put("operator", (qb, s) -> qb.operator(Operator.fromString((String)s)));
        appliers.put("max_expansions", (qb, s) -> qb.maxExpansions(Integer.valueOf(s).intValue()));
        appliers.put("prefix_length", (qb, s) -> qb.prefixLength(Integer.valueOf(s).intValue()));
        appliers.put("analyzer", (qb, s) -> qb.analyzer(s));
        appliers.put("auto_generate_synonyms_phrase_query", (qb, s) -> qb.autoGenerateSynonymsPhraseQuery(Booleans.parseBoolean((String)s)));
        BUILDER_APPLIERS = Collections.unmodifiableMap(appliers);
    }
}

