/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.querydsl.query;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.xpack.sql.expression.Expression;
import org.elasticsearch.xpack.sql.expression.Foldables;
import org.elasticsearch.xpack.sql.querydsl.query.LeafQuery;
import org.elasticsearch.xpack.sql.tree.Location;
import org.elasticsearch.xpack.sql.type.DataTypes;

public class TermsQuery
extends LeafQuery {
    private final String term;
    private final Set<Object> values;

    public TermsQuery(Location location, String term, List<Expression> values) {
        super(location);
        this.term = term;
        values.removeIf(e -> DataTypes.isNull(e.dataType()));
        this.values = values.isEmpty() ? Collections.emptySet() : new LinkedHashSet(Foldables.valuesOf(values, values.get(0).dataType()));
    }

    @Override
    public QueryBuilder asBuilder() {
        return QueryBuilders.termsQuery((String)this.term, this.values);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.term, this.values);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TermsQuery other = (TermsQuery)obj;
        return Objects.equals(this.term, other.term) && Objects.equals(this.values, other.values);
    }

    @Override
    protected String innerToString() {
        return this.term + ":" + this.values;
    }
}

