/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.session;

import java.util.List;
import org.elasticsearch.xpack.sql.session.AbstractRowSet;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SchemaRowSet;
import org.elasticsearch.xpack.sql.type.Schema;

class ListRowSetCursor
extends AbstractRowSet
implements SchemaRowSet {
    private final Schema schema;
    private final List<List<?>> list;
    private int pos = 0;

    ListRowSetCursor(Schema schema, List<List<?>> list) {
        this.schema = schema;
        this.list = list;
    }

    @Override
    protected boolean doHasCurrent() {
        return this.pos < this.list.size();
    }

    @Override
    protected boolean doNext() {
        if (this.pos + 1 < this.list.size()) {
            ++this.pos;
            return true;
        }
        return false;
    }

    @Override
    protected Object getColumn(int index) {
        return this.list.get(this.pos).get(index);
    }

    @Override
    protected void doReset() {
        this.pos = 0;
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public Cursor nextPageCursor() {
        return Cursor.EMPTY;
    }

    @Override
    public Schema schema() {
        return this.schema;
    }
}

