/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.script;

import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.common.logging.DeprecationLogger;

public final class ParameterMap
implements Map<String, Object> {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(LogManager.getLogger(ParameterMap.class));
    private final Map<String, Object> params;
    private final Map<String, String> deprecations;

    public ParameterMap(Map<String, Object> params, Map<String, String> deprecations) {
        this.params = params;
        this.deprecations = deprecations;
    }

    @Override
    public int size() {
        return this.params.size();
    }

    @Override
    public boolean isEmpty() {
        return this.params.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.params.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.params.containsValue(value);
    }

    @Override
    public Object get(Object key) {
        String deprecationMessage = this.deprecations.get(key);
        if (deprecationMessage != null) {
            DEPRECATION_LOGGER.deprecated(deprecationMessage, new Object[0]);
        }
        return this.params.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.params.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.params.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> m) {
        this.params.putAll(m);
    }

    @Override
    public void clear() {
        this.params.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.params.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.params.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.params.entrySet();
    }
}

