/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeoutException;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.Counter;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.plugins.Platforms;
import org.elasticsearch.xpack.core.XPackClientActionPlugin;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.ml.MachineLearningFeatureSetUsage;
import org.elasticsearch.xpack.core.ml.MlMetadata;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsStatsAction;
import org.elasticsearch.xpack.core.ml.action.GetJobsStatsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedState;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.config.JobState;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSizeStats;
import org.elasticsearch.xpack.core.ml.stats.ForecastStats;
import org.elasticsearch.xpack.core.ml.stats.StatsAccumulator;
import org.elasticsearch.xpack.ml.job.process.NativeController;
import org.elasticsearch.xpack.ml.job.process.NativeControllerHolder;

public class MachineLearningFeatureSet
implements XPackFeatureSet {
    private static final List<String> mlPlatforms = Arrays.asList("darwin-x86_64", "linux-x86_64", "windows-x86_64");
    private final boolean enabled;
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;
    private final Client client;
    private final Map<String, Object> nativeCodeInfo;

    @Inject
    public MachineLearningFeatureSet(Environment environment, ClusterService clusterService, Client client, @Nullable XPackLicenseState licenseState) {
        this.enabled = (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(environment.settings());
        this.clusterService = Objects.requireNonNull(clusterService);
        this.client = Objects.requireNonNull(client);
        this.licenseState = licenseState;
        Map<String, Object> nativeCodeInfo = NativeController.UNKNOWN_NATIVE_CODE_INFO;
        if (this.enabled && !XPackPlugin.transportClientMode((Settings)environment.settings()) && !XPackClientActionPlugin.isTribeClientNode((Settings)environment.settings())) {
            try {
                NativeController nativeController;
                if (MachineLearningFeatureSet.isRunningOnMlPlatform(true) && (nativeController = NativeControllerHolder.getNativeController(environment)) != null) {
                    nativeCodeInfo = nativeController.getNativeCodeInfo();
                }
            }
            catch (IOException | TimeoutException e) {
                Loggers.getLogger(MachineLearningFeatureSet.class).error("Cannot get native code info for Machine Learning", (Throwable)e);
                throw new ElasticsearchException("Cannot communicate with Machine Learning native code", new Object[0]);
            }
        }
        this.nativeCodeInfo = nativeCodeInfo;
    }

    static boolean isRunningOnMlPlatform(boolean fatalIfNot) {
        return MachineLearningFeatureSet.isRunningOnMlPlatform(Constants.OS_NAME, Constants.OS_ARCH, fatalIfNot);
    }

    static boolean isRunningOnMlPlatform(String osName, String osArch, boolean fatalIfNot) {
        String platformName = Platforms.platformName((String)osName, (String)osArch);
        if (mlPlatforms.contains(platformName)) {
            return true;
        }
        if (fatalIfNot) {
            throw new ElasticsearchException("X-Pack is not supported and Machine Learning is not available for [" + platformName + "]; you can use the other X-Pack features (unsupported) by setting xpack.ml.enabled: false in elasticsearch.yml", new Object[0]);
        }
        return false;
    }

    public String name() {
        return "ml";
    }

    public String description() {
        return "Machine Learning for the Elastic Stack";
    }

    public boolean available() {
        return this.licenseState != null && this.licenseState.isMachineLearningAllowed();
    }

    public boolean enabled() {
        return this.enabled;
    }

    public Map<String, Object> nativeCodeInfo() {
        return this.nativeCodeInfo;
    }

    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        new Retriever(this.client, MlMetadata.getMlMetadata((ClusterState)state), this.available(), this.enabled(), this.mlNodeCount(state)).execute(listener);
    }

    private int mlNodeCount(ClusterState clusterState) {
        if (!this.enabled) {
            return 0;
        }
        int mlNodeCount = 0;
        for (DiscoveryNode node : clusterState.getNodes()) {
            String enabled = (String)node.getAttributes().get("ml.enabled");
            if (!Boolean.parseBoolean(enabled)) continue;
            ++mlNodeCount;
        }
        return mlNodeCount;
    }

    public static class Retriever {
        private final Client client;
        private final MlMetadata mlMetadata;
        private final boolean available;
        private final boolean enabled;
        private Map<String, Object> jobsUsage;
        private Map<String, Object> datafeedsUsage;
        private int nodeCount;

        public Retriever(Client client, MlMetadata mlMetadata, boolean available, boolean enabled, int nodeCount) {
            this.client = Objects.requireNonNull(client);
            this.mlMetadata = mlMetadata;
            this.available = available;
            this.enabled = enabled;
            this.jobsUsage = new LinkedHashMap<String, Object>();
            this.datafeedsUsage = new LinkedHashMap<String, Object>();
            this.nodeCount = nodeCount;
        }

        public void execute(ActionListener<XPackFeatureSet.Usage> listener) {
            if (!this.enabled) {
                listener.onResponse((Object)new MachineLearningFeatureSetUsage(this.available, this.enabled, Collections.emptyMap(), Collections.emptyMap(), 0));
                return;
            }
            ActionListener datafeedStatsListener = ActionListener.wrap(response -> {
                this.addDatafeedsUsage((GetDatafeedsStatsAction.Response)response);
                listener.onResponse((Object)new MachineLearningFeatureSetUsage(this.available, this.enabled, this.jobsUsage, this.datafeedsUsage, this.nodeCount));
            }, arg_0 -> listener.onFailure(arg_0));
            GetJobsStatsAction.Request jobStatsRequest = new GetJobsStatsAction.Request("_all");
            ActionListener jobStatsListener = ActionListener.wrap(response -> {
                this.addJobsUsage((GetJobsStatsAction.Response)response);
                GetDatafeedsStatsAction.Request datafeedStatsRequest = new GetDatafeedsStatsAction.Request("_all");
                this.client.execute((Action)GetDatafeedsStatsAction.INSTANCE, (ActionRequest)datafeedStatsRequest, datafeedStatsListener);
            }, arg_0 -> listener.onFailure(arg_0));
            this.client.execute((Action)GetJobsStatsAction.INSTANCE, (ActionRequest)jobStatsRequest, jobStatsListener);
        }

        private void addJobsUsage(GetJobsStatsAction.Response response) {
            StatsAccumulator allJobsDetectorsStats = new StatsAccumulator();
            StatsAccumulator allJobsModelSizeStats = new StatsAccumulator();
            ForecastStats allJobsForecastStats = new ForecastStats();
            HashMap<JobState, Counter> jobCountByState = new HashMap<JobState, Counter>();
            HashMap<JobState, StatsAccumulator> detectorStatsByState = new HashMap<JobState, StatsAccumulator>();
            HashMap<JobState, StatsAccumulator> modelSizeStatsByState = new HashMap<JobState, StatsAccumulator>();
            HashMap<JobState, ForecastStats> forecastStatsByState = new HashMap<JobState, ForecastStats>();
            Map jobs = this.mlMetadata.getJobs();
            List jobsStats = response.getResponse().results();
            for (GetJobsStatsAction.Response.JobStats jobStats : jobsStats) {
                ModelSizeStats modelSizeStats = jobStats.getModelSizeStats();
                int detectorsCount = ((Job)jobs.get(jobStats.getJobId())).getAnalysisConfig().getDetectors().size();
                double modelSize = modelSizeStats == null ? 0.0 : (double)jobStats.getModelSizeStats().getModelBytes();
                allJobsForecastStats.merge(jobStats.getForecastStats());
                allJobsDetectorsStats.add((double)detectorsCount);
                allJobsModelSizeStats.add(modelSize);
                JobState jobState = jobStats.getState();
                jobCountByState.computeIfAbsent(jobState, js -> Counter.newCounter()).addAndGet(1L);
                detectorStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add((double)detectorsCount);
                modelSizeStatsByState.computeIfAbsent(jobState, js -> new StatsAccumulator()).add(modelSize);
                forecastStatsByState.merge(jobState, jobStats.getForecastStats(), (f1, f2) -> f1.merge(f2));
            }
            this.jobsUsage.put("_all", this.createJobUsageEntry(jobs.size(), allJobsDetectorsStats, allJobsModelSizeStats, allJobsForecastStats));
            for (JobState jobState : jobCountByState.keySet()) {
                this.jobsUsage.put(jobState.name().toLowerCase(Locale.ROOT), this.createJobUsageEntry(((Counter)jobCountByState.get(jobState)).get(), (StatsAccumulator)detectorStatsByState.get(jobState), (StatsAccumulator)modelSizeStatsByState.get(jobState), (ForecastStats)forecastStatsByState.get(jobState)));
            }
        }

        private Map<String, Object> createJobUsageEntry(long count, StatsAccumulator detectorStats, StatsAccumulator modelSizeStats, ForecastStats forecastStats) {
            HashMap<String, Object> usage = new HashMap<String, Object>();
            usage.put("count", count);
            usage.put("detectors", detectorStats.asMap());
            usage.put("model_size", modelSizeStats.asMap());
            usage.put("forecasts", forecastStats.asMap());
            return usage;
        }

        private void addDatafeedsUsage(GetDatafeedsStatsAction.Response response) {
            HashMap<DatafeedState, Counter> datafeedCountByState = new HashMap<DatafeedState, Counter>();
            List datafeedsStats = response.getResponse().results();
            for (GetDatafeedsStatsAction.Response.DatafeedStats datafeedStats : datafeedsStats) {
                datafeedCountByState.computeIfAbsent(datafeedStats.getDatafeedState(), ds -> Counter.newCounter()).addAndGet(1L);
            }
            this.datafeedsUsage.put("_all", this.createDatafeedUsageEntry(response.getResponse().count()));
            for (DatafeedState datafeedState : datafeedCountByState.keySet()) {
                this.datafeedsUsage.put(datafeedState.name().toLowerCase(Locale.ROOT), this.createDatafeedUsageEntry(((Counter)datafeedCountByState.get(datafeedState)).get()));
            }
        }

        private Map<String, Object> createDatafeedUsageEntry(long count) {
            HashMap<String, Object> usage = new HashMap<String, Object>();
            usage.put("count", count);
            return usage;
        }
    }
}

