/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.action;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.action.DeleteForecastAction;
import org.elasticsearch.xpack.core.ml.job.messages.Messages;
import org.elasticsearch.xpack.core.ml.job.persistence.AnomalyDetectorsIndex;
import org.elasticsearch.xpack.core.ml.job.results.Forecast;
import org.elasticsearch.xpack.core.ml.job.results.ForecastRequestStats;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class TransportDeleteForecastAction
extends HandledTransportAction<DeleteForecastAction.Request, AcknowledgedResponse> {
    private final Client client;
    private static final int MAX_FORECAST_TO_SEARCH = 10000;
    private static final Set<ForecastRequestStats.ForecastRequestStatus> DELETABLE_STATUSES = EnumSet.of(ForecastRequestStats.ForecastRequestStatus.FINISHED, ForecastRequestStats.ForecastRequestStatus.FAILED);

    @Inject
    public TransportDeleteForecastAction(Settings settings, ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Client client) {
        super(settings, "cluster:admin/xpack/ml/job/forecast/delete", threadPool, transportService, actionFilters, indexNameExpressionResolver, DeleteForecastAction.Request::new);
        this.client = client;
    }

    protected void doExecute(DeleteForecastAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        String jobId = request.getJobId();
        String forecastsExpression = request.getForecastId();
        ActionListener forecastStatsHandler = ActionListener.wrap(searchResponse -> this.deleteForecasts((SearchResponse)searchResponse, request, listener), e -> listener.onFailure((Exception)new ElasticsearchException("An error occurred while searching forecasts to delete", (Throwable)e, new Object[0])));
        SearchSourceBuilder source = new SearchSourceBuilder();
        BoolQueryBuilder builder = QueryBuilders.boolQuery();
        BoolQueryBuilder innerBool = QueryBuilders.boolQuery().must((QueryBuilder)QueryBuilders.termQuery((String)Result.RESULT_TYPE.getPreferredName(), (String)"model_forecast_request_stats"));
        if (!"_all".equals(request.getForecastId())) {
            HashSet<String> forcastIds = new HashSet<String>(Arrays.asList(Strings.tokenizeToStringArray((String)forecastsExpression, (String)",")));
            innerBool.must((QueryBuilder)QueryBuilders.termsQuery((String)Forecast.FORECAST_ID.getPreferredName(), forcastIds));
        }
        source.query((QueryBuilder)builder.filter((QueryBuilder)innerBool));
        SearchRequest searchRequest = new SearchRequest(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId)});
        searchRequest.source(source);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)SearchAction.INSTANCE, (ActionRequest)searchRequest, (ActionListener)forecastStatsHandler);
    }

    private void deleteForecasts(SearchResponse searchResponse, DeleteForecastAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        Set<ForecastRequestStats> forecastsToDelete;
        String jobId = request.getJobId();
        try {
            forecastsToDelete = TransportDeleteForecastAction.parseForecastsFromSearch(searchResponse);
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
            return;
        }
        if (forecastsToDelete.isEmpty()) {
            if ("_all".equals(request.getForecastId()) && request.isAllowNoForecasts()) {
                listener.onResponse((Object)new AcknowledgedResponse(true));
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException(Messages.getMessage((String)"No forecast(s) [{0}] exists for job [{1}]", (Object[])new Object[]{request.getForecastId(), jobId}), new Object[0]));
            }
            return;
        }
        List badStatusForecasts = forecastsToDelete.stream().filter(f -> !DELETABLE_STATUSES.contains(f.getStatus())).map(ForecastRequestStats::getForecastId).collect(Collectors.toList());
        if (badStatusForecasts.size() > 0) {
            listener.onFailure((Exception)org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper.conflictStatusException((String)Messages.getMessage((String)"Forecast(s) [{0}] for job [{1}] needs to be either FAILED or FINISHED to be deleted", (Object[])new Object[]{badStatusForecasts, jobId}), (Object[])new Object[0]));
            return;
        }
        List<String> forecastIds = forecastsToDelete.stream().map(ForecastRequestStats::getForecastId).collect(Collectors.toList());
        DeleteByQueryRequest deleteByQueryRequest = this.buildDeleteByQuery(jobId, forecastIds);
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"ml", (Action)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, (ActionListener)ActionListener.wrap(response -> {
            if (response.isTimedOut()) {
                listener.onFailure((Exception)new TimeoutException("Delete request timed out. Successfully deleted " + response.getDeleted() + " forecast documents from job [" + jobId + "]"));
                return;
            }
            if (!(response.getBulkFailures().isEmpty() && response.getSearchFailures().isEmpty())) {
                Tuple<RestStatus, Throwable> statusAndReason = TransportDeleteForecastAction.getStatusAndReason(response);
                listener.onFailure((Exception)new ElasticsearchStatusException(((Throwable)statusAndReason.v2()).getMessage(), (RestStatus)statusAndReason.v1(), (Throwable)statusAndReason.v2(), new Object[0]));
                return;
            }
            this.logger.info("Deleted forecast(s) [{}] from job [{}]", (Object)forecastIds, (Object)jobId);
            listener.onResponse((Object)new AcknowledgedResponse(true));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    private static Tuple<RestStatus, Throwable> getStatusAndReason(BulkByScrollResponse response) {
        RestStatus status = RestStatus.OK;
        Throwable reason = new Exception("Unknown error");
        for (BulkItemResponse.Failure failure : response.getBulkFailures()) {
            if (failure.getStatus().getStatus() <= status.getStatus()) continue;
            status = failure.getStatus();
            reason = failure.getCause();
        }
        for (BulkItemResponse.Failure failure : response.getSearchFailures()) {
            RestStatus failureStatus = ExceptionsHelper.status((Throwable)failure.getReason());
            if (failureStatus.getStatus() <= status.getStatus()) continue;
            status = failureStatus;
            reason = failure.getReason();
        }
        return new Tuple((Object)status, (Object)reason);
    }

    private static Set<ForecastRequestStats> parseForecastsFromSearch(SearchResponse searchResponse) throws IOException {
        SearchHits hits = searchResponse.getHits();
        ArrayList<ForecastRequestStats> allStats = new ArrayList<ForecastRequestStats>(hits.getHits().length);
        for (SearchHit hit : hits) {
            StreamInput stream = hit.getSourceRef().streamInput();
            try {
                XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, (InputStream)stream);
                try {
                    allStats.add((ForecastRequestStats)ForecastRequestStats.STRICT_PARSER.apply(parser, null));
                }
                finally {
                    if (parser == null) continue;
                    parser.close();
                }
            }
            finally {
                if (stream == null) continue;
                stream.close();
            }
        }
        return new HashSet<ForecastRequestStats>(allStats);
    }

    private DeleteByQueryRequest buildDeleteByQuery(String jobId, List<String> forecastsToDelete) {
        DeleteByQueryRequest request = (DeleteByQueryRequest)((DeleteByQueryRequest)((DeleteByQueryRequest)new DeleteByQueryRequest().setAbortOnVersionConflict(false)).setSize(10000)).setSlices(5);
        request.indices(new String[]{AnomalyDetectorsIndex.jobResultsAliasedName((String)jobId)});
        BoolQueryBuilder innerBoolQuery = QueryBuilders.boolQuery();
        innerBoolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)Result.RESULT_TYPE.getPreferredName(), (String[])new String[]{"model_forecast_request_stats", "model_forecast"})).must((QueryBuilder)QueryBuilders.termsQuery((String)Forecast.FORECAST_ID.getPreferredName(), forecastsToDelete));
        BoolQueryBuilder query = QueryBuilders.boolQuery().filter((QueryBuilder)innerBoolQuery);
        request.setQuery((QueryBuilder)query);
        request.setRefresh(true);
        return request;
    }
}

