/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingClusterStateUpdateRequest;
import org.elasticsearch.cluster.AckedClusterStateTaskListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.DocumentMapper;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.InvalidTypeNameException;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class MetaDataMappingService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    final RefreshTaskExecutor refreshExecutor = new RefreshTaskExecutor();
    final PutMappingExecutor putMappingExecutor = new PutMappingExecutor();

    @Inject
    public MetaDataMappingService(Settings settings, ClusterService clusterService, IndicesService indicesService) {
        super(settings);
        this.clusterService = clusterService;
        this.indicesService = indicesService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState executeRefresh(ClusterState currentState, List<RefreshTask> allTasks) throws Exception {
        HashMap<String, List> tasksPerIndex = new HashMap<String, List>();
        for (RefreshTask task : allTasks) {
            if (task.index == null) {
                this.logger.debug("ignoring a mapping task of type [{}] with a null index.", (Object)task);
            }
            tasksPerIndex.computeIfAbsent(task.index, k -> new ArrayList()).add(task);
        }
        boolean dirty = false;
        MetaData.Builder mdBuilder = MetaData.builder(currentState.metaData());
        for (Map.Entry entry : tasksPerIndex.entrySet()) {
            IndexMetaData indexMetaData = mdBuilder.get((String)entry.getKey());
            if (indexMetaData == null) {
                this.logger.debug("[{}] ignoring tasks - index meta data doesn't exist", entry.getKey());
                continue;
            }
            Index index = indexMetaData.getIndex();
            List allIndexTasks = (List)entry.getValue();
            boolean hasTaskWithRightUUID = false;
            for (RefreshTask task : allIndexTasks) {
                if (indexMetaData.isSameUUID(task.indexUUID)) {
                    hasTaskWithRightUUID = true;
                    continue;
                }
                this.logger.debug("{} ignoring task [{}] - index meta data doesn't match task uuid", (Object)index, (Object)task);
            }
            if (!hasTaskWithRightUUID) continue;
            boolean removeIndex = false;
            IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = this.indicesService.indexService(indexMetaData.getIndex());
            if (indexService == null) {
                indexService = this.indicesService.createIndex(indexMetaData, Collections.emptyList());
                removeIndex = true;
                ((IndexService)indexService).mapperService().merge(indexMetaData, MapperService.MergeReason.MAPPING_RECOVERY, true);
            }
            IndexMetaData.Builder builder = IndexMetaData.builder(indexMetaData);
            try {
                boolean indexDirty = this.refreshIndexMapping((IndexService)indexService, builder);
                if (!indexDirty) continue;
                mdBuilder.put(builder);
                dirty = true;
            }
            finally {
                if (!removeIndex) continue;
                this.indicesService.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for mapping processing");
            }
        }
        if (!dirty) {
            return currentState;
        }
        return ClusterState.builder(currentState).metaData(mdBuilder).build();
    }

    private boolean refreshIndexMapping(IndexService indexService, IndexMetaData.Builder builder) {
        boolean dirty = false;
        String index = indexService.index().getName();
        try {
            ArrayList<String> updatedTypes = new ArrayList<String>();
            for (DocumentMapper mapper : indexService.mapperService().docMappers(true)) {
                String type = mapper.type();
                if (mapper.mappingSource().equals(builder.mapping(type).source())) continue;
                updatedTypes.add(type);
            }
            if (!updatedTypes.isEmpty()) {
                this.logger.warn("[{}] re-syncing mappings with cluster state because of types [{}]", (Object)index, (Object)updatedTypes);
                dirty = true;
                for (DocumentMapper mapper : indexService.mapperService().docMappers(true)) {
                    builder.putMapping(new MappingMetaData(mapper));
                }
            }
        }
        catch (Exception e) {
            this.logger.warn(() -> new ParameterizedMessage("[{}] failed to refresh-mapping in cluster state", (Object)index), (Throwable)e);
        }
        return dirty;
    }

    public void refreshMapping(String index, String indexUUID) {
        RefreshTask refreshTask = new RefreshTask(index, indexUUID);
        this.clusterService.submitStateUpdateTask("refresh-mapping", refreshTask, ClusterStateTaskConfig.build(Priority.HIGH), this.refreshExecutor, (source, e) -> this.logger.warn(() -> new ParameterizedMessage("failure during [{}]", (Object)source), (Throwable)e));
    }

    public void putMapping(final PutMappingClusterStateUpdateRequest request, final ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("put-mapping", request, ClusterStateTaskConfig.build(Priority.HIGH, request.masterNodeTimeout()), this.putMappingExecutor, new AckedClusterStateTaskListener(){

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public boolean mustAck(DiscoveryNode discoveryNode) {
                return true;
            }

            @Override
            public void onAllNodesAcked(@Nullable Exception e) {
                listener.onResponse(new ClusterStateUpdateResponse(e == null));
            }

            @Override
            public void onAckTimeout() {
                listener.onResponse(new ClusterStateUpdateResponse(false));
            }

            @Override
            public TimeValue ackTimeout() {
                return request.ackTimeout();
            }
        });
    }

    class PutMappingExecutor
    implements ClusterStateTaskExecutor<PutMappingClusterStateUpdateRequest> {
        PutMappingExecutor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<PutMappingClusterStateUpdateRequest> execute(ClusterState currentState, List<PutMappingClusterStateUpdateRequest> tasks) throws Exception {
            HashMap<Index, MapperService> indexMapperServices = new HashMap<Index, MapperService>();
            ClusterStateTaskExecutor.ClusterTasksResult.Builder<PutMappingClusterStateUpdateRequest> builder = ClusterStateTaskExecutor.ClusterTasksResult.builder();
            try {
                for (PutMappingClusterStateUpdateRequest request : tasks) {
                    try {
                        for (Index index : request.indices()) {
                            IndexMetaData indexMetaData = currentState.metaData().getIndexSafe(index);
                            if (indexMapperServices.containsKey(indexMetaData.getIndex())) continue;
                            MapperService mapperService = MetaDataMappingService.this.indicesService.createIndexMapperService(indexMetaData);
                            indexMapperServices.put(index, mapperService);
                            mapperService.merge(indexMetaData, MapperService.MergeReason.MAPPING_RECOVERY, request.updateAllTypes());
                        }
                        currentState = this.applyRequest(currentState, request, indexMapperServices);
                        builder.success(request);
                    }
                    catch (Exception e) {
                        builder.failure(request, e);
                    }
                }
                ClusterStateTaskExecutor.ClusterTasksResult clusterTasksResult = builder.build(currentState);
                return clusterTasksResult;
            }
            finally {
                IOUtils.close(indexMapperServices.values());
            }
        }

        private ClusterState applyRequest(ClusterState currentState, PutMappingClusterStateUpdateRequest request, Map<Index, MapperService> indexMapperServices) throws IOException {
            String mappingType = request.type();
            CompressedXContent mappingUpdateSource = new CompressedXContent(request.source());
            MetaData metaData = currentState.metaData();
            ArrayList<IndexMetaData> updateList = new ArrayList<IndexMetaData>();
            for (Index index : request.indices()) {
                DocumentMapper newMapper;
                MapperService mapperService = indexMapperServices.get(index);
                IndexMetaData indexMetaData = currentState.getMetaData().getIndexSafe(index);
                updateList.add(indexMetaData);
                DocumentMapper existingMapper = mapperService.documentMapper(request.type());
                if ("_default_".equals(request.type())) {
                    newMapper = mapperService.parse(request.type(), mappingUpdateSource, false);
                } else {
                    newMapper = mapperService.parse(request.type(), mappingUpdateSource, existingMapper == null);
                    if (existingMapper != null) {
                        existingMapper.merge(newMapper.mapping(), request.updateAllTypes());
                    } else if (newMapper.parentFieldMapper().active()) {
                        for (ObjectCursor mapping : indexMetaData.getMappings().values()) {
                            String parentType = newMapper.parentFieldMapper().type();
                            if (!parentType.equals(((MappingMetaData)mapping.value).type()) || mapperService.getParentTypes().contains(parentType)) continue;
                            throw new IllegalArgumentException("can't add a _parent field that points to an already existing type, that isn't already a parent");
                        }
                    }
                }
                if (mappingType == null) {
                    mappingType = newMapper.type();
                    continue;
                }
                if (mappingType.equals(newMapper.type())) continue;
                throw new InvalidTypeNameException("Type name provided does not match type name within mapping definition");
            }
            assert (mappingType != null);
            if (!"_default_".equals(mappingType) && !"_doc".equals(mappingType) && mappingType.charAt(0) == '_') {
                throw new InvalidTypeNameException("Document mapping type name can't start with '_', found: [" + mappingType + "]");
            }
            MetaData.Builder builder = MetaData.builder(metaData);
            boolean updated = false;
            for (IndexMetaData indexMetaData : updateList) {
                boolean updatedMapping = false;
                Index index = indexMetaData.getIndex();
                MapperService mapperService = indexMapperServices.get(index);
                CompressedXContent existingSource = null;
                DocumentMapper existingMapper = mapperService.documentMapper(mappingType);
                if (existingMapper != null) {
                    existingSource = existingMapper.mappingSource();
                }
                DocumentMapper mergedMapper = mapperService.merge(mappingType, mappingUpdateSource, MapperService.MergeReason.MAPPING_UPDATE, request.updateAllTypes());
                CompressedXContent updatedSource = mergedMapper.mappingSource();
                if (existingSource != null) {
                    if (!existingSource.equals(updatedSource)) {
                        updatedMapping = true;
                        if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                            MetaDataMappingService.this.logger.debug("{} update_mapping [{}] with source [{}]", (Object)index, (Object)mergedMapper.type(), (Object)updatedSource);
                        } else if (MetaDataMappingService.this.logger.isInfoEnabled()) {
                            MetaDataMappingService.this.logger.info("{} update_mapping [{}]", (Object)index, (Object)mergedMapper.type());
                        }
                    }
                } else {
                    updatedMapping = true;
                    if (MetaDataMappingService.this.logger.isDebugEnabled()) {
                        MetaDataMappingService.this.logger.debug("{} create_mapping [{}] with source [{}]", (Object)index, (Object)mappingType, (Object)updatedSource);
                    } else if (MetaDataMappingService.this.logger.isInfoEnabled()) {
                        MetaDataMappingService.this.logger.info("{} create_mapping [{}]", (Object)index, (Object)mappingType);
                    }
                }
                IndexMetaData.Builder indexMetaDataBuilder = IndexMetaData.builder(indexMetaData);
                for (DocumentMapper mapper : mapperService.docMappers(true)) {
                    indexMetaDataBuilder.putMapping(new MappingMetaData(mapper.mappingSource()));
                }
                if (updatedMapping) {
                    indexMetaDataBuilder.mappingVersion(1L + indexMetaDataBuilder.mappingVersion());
                }
                builder.put(indexMetaDataBuilder);
                updated |= updatedMapping;
            }
            if (updated) {
                return ClusterState.builder(currentState).metaData(builder).build();
            }
            return currentState;
        }

        @Override
        public String describeTasks(List<PutMappingClusterStateUpdateRequest> tasks) {
            return String.join((CharSequence)", ", tasks.stream().map(t -> t.type())::iterator);
        }
    }

    class RefreshTaskExecutor
    implements ClusterStateTaskExecutor<RefreshTask> {
        RefreshTaskExecutor() {
        }

        @Override
        public ClusterStateTaskExecutor.ClusterTasksResult<RefreshTask> execute(ClusterState currentState, List<RefreshTask> tasks) throws Exception {
            ClusterState newClusterState = MetaDataMappingService.this.executeRefresh(currentState, tasks);
            return ClusterStateTaskExecutor.ClusterTasksResult.builder().successes(tasks).build(newClusterState);
        }
    }

    static class RefreshTask {
        final String index;
        final String indexUUID;

        RefreshTask(String index, String indexUUID) {
            this.index = index;
            this.indexUUID = indexUUID;
        }

        public String toString() {
            return "[" + this.index + "][" + this.indexUUID + "]";
        }
    }
}

