/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;

public class MetaDataUpdateSettingsService
extends AbstractComponent {
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ThreadPool threadPool;

    @Inject
    public MetaDataUpdateSettingsService(Settings settings, ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ThreadPool threadPool) {
        super(settings);
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false, true);
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        final boolean preserveExisting = request.isPreserveExisting();
        this.clusterService.submitStateUpdateTask("update-settings", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                Settings finalSettings;
                Settings.Builder indexSettings;
                Settings.Builder updates;
                IndexMetaData indexMetaData;
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                HashSet<Index> openIndices = new HashSet<Index>();
                HashSet<Index> closeIndices = new HashSet<Index>();
                String[] actualIndices = new String[request.indices().length];
                for (int i2 = 0; i2 < request.indices().length; ++i2) {
                    Index index = request.indices()[i2];
                    actualIndices[i2] = index.getName();
                    IndexMetaData metaData = currentState.metaData().getIndexSafe(index);
                    if (metaData.getState() == IndexMetaData.State.OPEN) {
                        openIndices.add(index);
                        continue;
                    }
                    closeIndices.add(index);
                }
                if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
                }
                int updatedNumberOfReplicas = openSettings.getAsInt("index.number_of_replicas", -1);
                if (updatedNumberOfReplicas != -1 && !preserveExisting) {
                    int totalNewShards = Arrays.stream(request.indices()).mapToInt(i -> MetaDataUpdateSettingsService.this.getTotalNewShards(i, currentState, updatedNumberOfReplicas)).sum();
                    Optional<String> error = IndicesService.checkShardLimit(totalNewShards, currentState, MetaDataUpdateSettingsService.this.deprecationLogger);
                    if (error.isPresent()) {
                        ValidationException ex = new ValidationException();
                        ex.addValidationError(error.get());
                        throw ex;
                    }
                    routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    metaDataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                    MetaDataUpdateSettingsService.this.logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_READ_ONLY_BLOCK, IndexMetaData.INDEX_READ_ONLY_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK, IndexMetaData.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_METADATA_BLOCK, IndexMetaData.INDEX_BLOCKS_METADATA_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_WRITE_BLOCK, IndexMetaData.INDEX_BLOCKS_WRITE_SETTING, openSettings);
                MetaDataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, IndexMetaData.INDEX_READ_BLOCK, IndexMetaData.INDEX_BLOCKS_READ_SETTING, openSettings);
                if (!openIndices.isEmpty()) {
                    for (Index index : openIndices) {
                        indexMetaData = metaDataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetaData.getSettings());
                        if (!MetaDataUpdateSettingsService.this.indexScopedSettings.updateDynamicSettings(openSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetaData.getSettings());
                        }
                        finalSettings = indexSettings.build();
                        MetaDataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetaDataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metaDataBuilder.put(IndexMetaData.builder(indexMetaData).settings(finalSettings));
                    }
                }
                if (!closeIndices.isEmpty()) {
                    for (Index index : closeIndices) {
                        indexMetaData = metaDataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetaData.getSettings());
                        if (!MetaDataUpdateSettingsService.this.indexScopedSettings.updateSettings(closedSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetaData.getSettings());
                        }
                        finalSettings = indexSettings.build();
                        MetaDataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetaDataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metaDataBuilder.put(IndexMetaData.builder(indexMetaData).settings(finalSettings));
                    }
                }
                for (String index : actualIndices) {
                    if (IndexSettings.same(currentState.metaData().index(index).getSettings(), metaDataBuilder.get(index).getSettings())) continue;
                    IndexMetaData.Builder builder = IndexMetaData.builder(metaDataBuilder.get(index));
                    builder.settingsVersion(1L + builder.settingsVersion());
                    metaDataBuilder.put(builder);
                }
                ClusterState updatedState = ClusterState.builder(currentState).metaData(metaDataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
                updatedState = MetaDataUpdateSettingsService.this.allocationService.reroute(updatedState, "settings update");
                try {
                    IndexMetaData updatedMetaData;
                    IndexMetaData currentMetaData;
                    for (Index index : openIndices) {
                        currentMetaData = currentState.getMetaData().getIndexSafe(index);
                        updatedMetaData = updatedState.metaData().getIndexSafe(index);
                        MetaDataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetaData, updatedMetaData);
                    }
                    for (Index index : closeIndices) {
                        currentMetaData = currentState.getMetaData().getIndexSafe(index);
                        updatedMetaData = updatedState.metaData().getIndexSafe(index);
                        MetaDataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetaData, updatedMetaData);
                        MetaDataUpdateSettingsService.this.indicesService.verifyIndexMetadata(updatedMetaData, updatedMetaData);
                    }
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToElastic(ex);
                }
                return updatedState;
            }
        });
    }

    private int getTotalNewShards(Index index, ClusterState currentState, int updatedNumberOfReplicas) {
        IndexMetaData indexMetaData = currentState.metaData().index(index);
        int shardsInIndex = indexMetaData.getNumberOfShards();
        int oldNumberOfReplicas = indexMetaData.getNumberOfReplicas();
        int replicaIncrease = updatedNumberOfReplicas - oldNumberOfReplicas;
        return replicaIncrease * shardsInIndex;
    }

    private static void maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    blocks.addIndexBlock(index, block);
                    continue;
                }
                blocks.removeIndexBlock(index, block);
            }
        }
    }

    public void upgradeIndexSettings(final UpgradeSettingsClusterStateUpdateRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-index-compatibility-versions", new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(Priority.URGENT, (AckedRequest)request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                MetaData.Builder metaDataBuilder = MetaData.builder(currentState.metaData());
                for (Map.Entry<String, Tuple<Version, String>> entry : request.versions().entrySet()) {
                    String index = entry.getKey();
                    IndexMetaData indexMetaData = metaDataBuilder.get(index);
                    if (indexMetaData == null || Version.CURRENT.equals(indexMetaData.getCreationVersion())) continue;
                    metaDataBuilder.put(IndexMetaData.builder(indexMetaData).settings(Settings.builder().put(indexMetaData.getSettings()).put("index.version.upgraded", entry.getValue().v1())).settingsVersion(1L + indexMetaData.getSettingsVersion()));
                }
                return ClusterState.builder(currentState).metaData(metaDataBuilder).build();
            }
        });
    }
}

