/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.logging;

import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.common.logging.PrefixLogger;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.shard.ShardId;

public class Loggers {
    public static final String SPACE = " ";
    public static final Setting<Level> LOG_DEFAULT_LEVEL_SETTING = new Setting<Level>("logger.level", Level.INFO.name(), Level::valueOf, Setting.Property.NodeScope);
    public static final Setting.AffixSetting<Level> LOG_LEVEL_SETTING = Setting.prefixKeySetting("logger.", key -> new Setting<Level>((String)key, Level.INFO.name(), Level::valueOf, Setting.Property.Dynamic, Setting.Property.NodeScope));

    public static Logger getLogger(Class<?> clazz, ShardId shardId, String ... prefixes) {
        return Loggers.getLogger(clazz, shardId.getIndex(), CollectionUtils.asArrayList(Integer.toString(shardId.id()), prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(String loggerName, ShardId shardId) {
        return ESLoggerFactory.getLogger(Loggers.formatPrefix(shardId.getIndexName(), Integer.toString(shardId.id())), loggerName);
    }

    public static Logger getLogger(Class<?> clazz, Index index, String ... prefixes) {
        return Loggers.getLogger(clazz, CollectionUtils.asArrayList(SPACE, index.getName(), prefixes).toArray(new String[0]));
    }

    public static Logger getLogger(Class<?> clazz, String ... prefixes) {
        return ESLoggerFactory.getLogger(Loggers.formatPrefix(prefixes), clazz);
    }

    public static Logger getLogger(Logger parentLogger, String s) {
        String prefix = null;
        if (parentLogger instanceof PrefixLogger) {
            prefix = ((PrefixLogger)parentLogger).prefix();
        }
        return ESLoggerFactory.getLogger(prefix, parentLogger.getName() + s);
    }

    @Deprecated
    public static Logger getLogger(String s) {
        return LogManager.getLogger(s);
    }

    @Deprecated
    public static Logger getLogger(Class<?> clazz) {
        return ESLoggerFactory.getLogger(null, clazz);
    }

    private static String formatPrefix(String ... prefixes) {
        String prefix = null;
        if (prefixes != null && prefixes.length > 0) {
            StringBuilder sb = new StringBuilder();
            for (String prefixX : prefixes) {
                if (prefixX == null) continue;
                if (prefixX.equals(SPACE)) {
                    sb.append(SPACE);
                    continue;
                }
                sb.append("[").append(prefixX).append("]");
            }
            if (sb.length() > 0) {
                prefix = sb.toString();
            }
        }
        return prefix;
    }

    public static void setLevel(Logger logger, String level) {
        Level l = level == null ? null : Level.valueOf(level);
        Loggers.setLevel(logger, l);
    }

    public static void setLevel(Logger logger, Level level) {
        LoggerContext ctx;
        if (!"".equals(logger.getName())) {
            Configurator.setLevel(logger.getName(), level);
        } else {
            ctx = LoggerContext.getContext(false);
            Configuration config = ctx.getConfiguration();
            LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
            loggerConfig.setLevel(level);
            ctx.updateLoggers();
        }
        ctx = LoggerContext.getContext(false);
        for (LoggerConfig loggerConfig : ctx.getConfiguration().getLoggers().values()) {
            if (!"".equals(logger.getName()) && !loggerConfig.getName().startsWith(logger.getName() + ".")) continue;
            Configurator.setLevel(loggerConfig.getName(), level);
        }
    }

    public static void addAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        config.addAppender(appender);
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.addAppender(appender, null, null);
        ctx.updateLoggers();
    }

    public static void removeAppender(Logger logger, Appender appender) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        if (!logger.getName().equals(loggerConfig.getName())) {
            loggerConfig = new LoggerConfig(logger.getName(), logger.getLevel(), true);
            config.addLogger(logger.getName(), loggerConfig);
        }
        loggerConfig.removeAppender(appender.getName());
        ctx.updateLoggers();
    }

    public static Appender findAppender(Logger logger, Class<? extends Appender> clazz) {
        LoggerContext ctx = (LoggerContext)LogManager.getContext(false);
        Configuration config = ctx.getConfiguration();
        LoggerConfig loggerConfig = config.getLoggerConfig(logger.getName());
        for (Map.Entry<String, Appender> entry : loggerConfig.getAppenders().entrySet()) {
            if (!entry.getValue().getClass().equals(clazz)) continue;
            return entry.getValue();
        }
        return null;
    }
}

