/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.LongSupplier;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.lease.Releasable;

final class SoftDeletesPolicy {
    private final LongSupplier globalCheckpointSupplier;
    private long localCheckpointOfSafeCommit;
    private int retentionLockCount;
    private long retentionOperations;
    private long minRetainedSeqNo;

    SoftDeletesPolicy(LongSupplier globalCheckpointSupplier, long minRetainedSeqNo, long retentionOperations) {
        this.globalCheckpointSupplier = globalCheckpointSupplier;
        this.retentionOperations = retentionOperations;
        this.minRetainedSeqNo = minRetainedSeqNo;
        this.localCheckpointOfSafeCommit = -1L;
        this.retentionLockCount = 0;
    }

    synchronized void setRetentionOperations(long retentionOperations) {
        this.retentionOperations = retentionOperations;
    }

    synchronized void setLocalCheckpointOfSafeCommit(long newCheckpoint) {
        if (newCheckpoint < this.localCheckpointOfSafeCommit) {
            throw new IllegalArgumentException("Local checkpoint can't go backwards; new checkpoint [" + newCheckpoint + "],current checkpoint [" + this.localCheckpointOfSafeCommit + "]");
        }
        this.localCheckpointOfSafeCommit = newCheckpoint;
    }

    synchronized Releasable acquireRetentionLock() {
        assert (this.retentionLockCount >= 0) : "Invalid number of retention locks [" + this.retentionLockCount + "]";
        ++this.retentionLockCount;
        AtomicBoolean released = new AtomicBoolean();
        return () -> {
            if (released.compareAndSet(false, true)) {
                this.releaseRetentionLock();
            }
        };
    }

    private synchronized void releaseRetentionLock() {
        assert (this.retentionLockCount > 0) : "Invalid number of retention locks [" + this.retentionLockCount + "]";
        --this.retentionLockCount;
    }

    synchronized long getMinRetainedSeqNo() {
        if (this.retentionLockCount == 0) {
            long minSeqNoForQueryingChanges = this.globalCheckpointSupplier.getAsLong() - this.retentionOperations;
            long minSeqNoToRetain = Math.min(minSeqNoForQueryingChanges, this.localCheckpointOfSafeCommit) + 1L;
            this.minRetainedSeqNo = Math.max(this.minRetainedSeqNo, minSeqNoToRetain);
        }
        return this.minRetainedSeqNo;
    }

    Query getRetentionQuery() {
        return LongPoint.newRangeQuery("_seq_no", this.getMinRetainedSeqNo(), Long.MAX_VALUE);
    }
}

