/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.pipeline;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.PipelineAggregationBuilder;
import org.elasticsearch.search.aggregations.pipeline.PipelineAggregator;

public abstract class AbstractPipelineAggregationBuilder<PAB extends AbstractPipelineAggregationBuilder<PAB>>
extends PipelineAggregationBuilder {
    public static final ParseField BUCKETS_PATH_FIELD = new ParseField("buckets_path", new String[0]);
    protected final String type;
    protected Map<String, Object> metaData;

    protected AbstractPipelineAggregationBuilder(String name, String type, String[] bucketsPaths) {
        super(name, bucketsPaths);
        if (type == null) {
            throw new IllegalArgumentException("[type] must not be null: [" + name + "]");
        }
        this.type = type;
    }

    protected AbstractPipelineAggregationBuilder(StreamInput in, String type) throws IOException {
        this(in.readString(), type, in.readStringArray());
        this.metaData = in.readMap();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeStringArray(this.bucketsPaths);
        out.writeMap(this.metaData);
        this.doWriteTo(out);
    }

    protected abstract void doWriteTo(StreamOutput var1) throws IOException;

    public String type() {
        return this.type;
    }

    @Override
    public final void validate(AggregatorFactory<?> parent, Collection<AggregationBuilder> factories, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
        this.doValidate(parent, factories, pipelineAggregatorFactories);
    }

    protected abstract PipelineAggregator createInternal(Map<String, Object> var1) throws IOException;

    @Override
    public final PipelineAggregator create() throws IOException {
        PipelineAggregator aggregator = this.createInternal(this.metaData);
        return aggregator;
    }

    public void doValidate(AggregatorFactory<?> parent, Collection<AggregationBuilder> factories, Collection<PipelineAggregationBuilder> pipelineAggregatorFactories) {
    }

    public PAB setMetaData(Map<String, Object> metaData) {
        this.metaData = metaData;
        return (PAB)this;
    }

    @Override
    public final XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject(this.getName());
        if (this.metaData != null) {
            builder.field("meta", this.metaData);
        }
        builder.startObject(this.type);
        if (!this.overrideBucketsPath() && this.bucketsPaths != null) {
            builder.startArray(PipelineAggregator.Parser.BUCKETS_PATH.getPreferredName());
            for (String path : this.bucketsPaths) {
                builder.value(path);
            }
            builder.endArray();
        }
        this.internalXContent(builder, params);
        builder.endObject();
        return builder.endObject();
    }

    protected boolean overrideBucketsPath() {
        return false;
    }

    protected abstract XContentBuilder internalXContent(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    public int hashCode() {
        return Objects.hash(Arrays.hashCode(this.bucketsPaths), this.metaData, this.name, this.type, this.doHashCode());
    }

    protected abstract int doHashCode();

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractPipelineAggregationBuilder other = (AbstractPipelineAggregationBuilder)obj;
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.deepEquals(this.bucketsPaths, other.bucketsPaths)) {
            return false;
        }
        if (!Objects.equals(this.metaData, other.metaData)) {
            return false;
        }
        return this.doEquals(obj);
    }

    protected abstract boolean doEquals(Object var1);

    @Override
    public String getType() {
        return this.type;
    }
}

