/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.fetch.subphase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.index.SortedNumericDocValues;
import org.elasticsearch.common.document.DocumentField;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.fielddata.AtomicFieldData;
import org.elasticsearch.index.fielddata.AtomicNumericFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.fetch.FetchSubPhase;
import org.elasticsearch.search.fetch.subphase.DocValueFieldsContext;
import org.elasticsearch.search.internal.SearchContext;

public final class DocValueFieldsFetchSubPhase
implements FetchSubPhase {
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(Loggers.getLogger(DocValueFieldsFetchSubPhase.class));

    @Override
    public void hitsExecute(SearchContext context, SearchHit[] hits) throws IOException {
        if (context.collapse() != null) {
            String name = context.collapse().getFieldName();
            if (context.docValueFieldsContext() == null) {
                context.docValueFieldsContext(new DocValueFieldsContext(Collections.singletonList(new DocValueFieldsContext.FieldAndFormat(name, "use_field_mapping"))));
            } else if (!context.docValueFieldsContext().fields().stream().map(ff -> ff.field).anyMatch(name::equals)) {
                context.docValueFieldsContext().fields().add(new DocValueFieldsContext.FieldAndFormat(name, "use_field_mapping"));
            }
        }
        if (context.docValueFieldsContext() == null) {
            return;
        }
        hits = (SearchHit[])hits.clone();
        Arrays.sort(hits, Comparator.comparingInt(SearchHit::docId));
        List noFormatFields = context.docValueFieldsContext().fields().stream().filter(f -> f.format == null).map(f -> f.field).collect(Collectors.toList());
        if (!noFormatFields.isEmpty()) {
            DEPRECATION_LOGGER.deprecated("There are doc-value fields which are not using a format. The output will change in 7.0 when doc value fields get formatted based on mappings by default. It is recommended to pass [format={}] with a doc value field in order to opt in for the future behaviour and ease the migration to 7.0: {}", "use_field_mapping", noFormatFields);
        }
        for (DocValueFieldsContext.FieldAndFormat fieldAndFormat : context.docValueFieldsContext().fields()) {
            DocValueFormat format;
            String field = fieldAndFormat.field;
            MappedFieldType fieldType = context.mapperService().fullName(field);
            if (fieldType == null) continue;
            Object indexFieldData = context.getForField(fieldType);
            if (fieldAndFormat.format == null) {
                format = null;
            } else {
                String formatDesc = fieldAndFormat.format;
                if (Objects.equals(formatDesc, "use_field_mapping")) {
                    formatDesc = null;
                }
                format = fieldType.docValueFormat(formatDesc, null);
            }
            LeafReaderContext subReaderContext = null;
            AtomicFieldData data = null;
            ScriptDocValues<?> scriptValues = null;
            SortedBinaryDocValues binaryValues = null;
            SortedNumericDocValues longValues = null;
            SortedNumericDoubleValues doubleValues = null;
            for (SearchHit hit : hits) {
                int i;
                int count;
                DocumentField hitField;
                if (subReaderContext == null || hit.docId() >= subReaderContext.docBase + subReaderContext.reader().maxDoc()) {
                    int readerIndex = ReaderUtil.subIndex(hit.docId(), context.searcher().getIndexReader().leaves());
                    subReaderContext = context.searcher().getIndexReader().leaves().get(readerIndex);
                    data = (AtomicFieldData)indexFieldData.load(subReaderContext);
                    if (format == null) {
                        scriptValues = data.getLegacyFieldValues();
                    } else if (indexFieldData instanceof IndexNumericFieldData) {
                        if (((IndexNumericFieldData)indexFieldData).getNumericType().isFloatingPoint()) {
                            doubleValues = ((AtomicNumericFieldData)data).getDoubleValues();
                        } else {
                            longValues = ((AtomicNumericFieldData)data).getLongValues();
                        }
                    } else {
                        binaryValues = data.getBytesValues();
                    }
                }
                if (hit.fieldsOrNull() == null) {
                    hit.fields(new HashMap<String, DocumentField>(2));
                }
                if ((hitField = hit.getFields().get(field)) == null) {
                    hitField = new DocumentField(field, new ArrayList<Object>(2));
                    hit.getFields().put(field, hitField);
                }
                List<Object> values = hitField.getValues();
                int subDocId = hit.docId() - subReaderContext.docBase;
                if (scriptValues != null) {
                    scriptValues.setNextDocId(subDocId);
                    values.addAll(scriptValues);
                    continue;
                }
                if (binaryValues != null) {
                    if (!binaryValues.advanceExact(subDocId)) continue;
                    count = binaryValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(binaryValues.nextValue()));
                    }
                    continue;
                }
                if (longValues != null) {
                    if (!longValues.advanceExact(subDocId)) continue;
                    count = longValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(longValues.nextValue()));
                    }
                    continue;
                }
                if (doubleValues != null) {
                    if (!doubleValues.advanceExact(subDocId)) continue;
                    count = doubleValues.docValueCount();
                    for (i = 0; i < count; ++i) {
                        values.add(format.format(doubleValues.nextValue()));
                    }
                    continue;
                }
                throw new AssertionError((Object)"Unreachable code");
            }
        }
    }
}

