/*
 * Decompiled with CFR 0.152.
 */
package org.jline.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jline.terminal.Terminal;
import org.jline.terminal.impl.AbstractPosixTerminal;
import org.jline.terminal.spi.Pty;
import org.jline.utils.ClosedException;
import org.jline.utils.NonBlocking;
import org.jline.utils.NonBlockingInputStream;
import org.jline.utils.NonBlockingReader;

public class PosixPtyTerminal
extends AbstractPosixTerminal {
    private final InputStream in;
    private final OutputStream out;
    private final InputStream masterInput;
    private final OutputStream masterOutput;
    private final NonBlockingInputStream input;
    private final OutputStream output;
    private final NonBlockingReader reader;
    private final PrintWriter writer;
    private Thread inputPumpThread;
    private Thread outputPumpThread;
    private AtomicBoolean paused = new AtomicBoolean(true);

    public PosixPtyTerminal(String name, String type, Pty pty, InputStream in, OutputStream out, Charset encoding) throws IOException {
        this(name, type, pty, in, out, encoding, Terminal.SignalHandler.SIG_DFL);
    }

    public PosixPtyTerminal(String name, String type, Pty pty, InputStream in, OutputStream out, Charset encoding, Terminal.SignalHandler signalHandler) throws IOException {
        super(name, type, pty, encoding, signalHandler);
        this.in = Objects.requireNonNull(in);
        this.out = Objects.requireNonNull(out);
        this.masterInput = pty.getMasterInput();
        this.masterOutput = pty.getMasterOutput();
        this.input = new InputStreamWrapper(NonBlocking.nonBlocking(name, pty.getSlaveInput()));
        this.output = pty.getSlaveOutput();
        this.reader = NonBlocking.nonBlocking(name, this.input, this.encoding());
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, this.encoding()));
        this.parseInfoCmp();
        this.resume();
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public NonBlockingReader reader() {
        return this.reader;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.reader.close();
    }

    @Override
    public boolean canPauseResume() {
        return true;
    }

    @Override
    public void pause() {
        this.paused.compareAndSet(false, true);
    }

    @Override
    public void resume() {
        if (this.paused.compareAndSet(true, false)) {
            this.inputPumpThread = new PumpThread(this.in, this.masterOutput);
            this.outputPumpThread = new PumpThread(this.masterInput, this.out);
            this.inputPumpThread.start();
            this.outputPumpThread.start();
        }
    }

    @Override
    public boolean paused() {
        return this.paused.get();
    }

    private class PumpThread
    extends Thread {
        private final InputStream in;
        private final OutputStream out;

        public PumpThread(InputStream in, OutputStream out) {
            this.in = in;
            this.out = out;
        }

        @Override
        public void run() {
            try {
                while (!PosixPtyTerminal.this.paused.get()) {
                    int b = this.in.read();
                    if (b < 0) {
                        PosixPtyTerminal.this.input.close();
                        break;
                    }
                    this.out.write(b);
                    this.out.flush();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private class InputStreamWrapper
    extends NonBlockingInputStream {
        private final NonBlockingInputStream in;
        private final AtomicBoolean closed = new AtomicBoolean();

        protected InputStreamWrapper(NonBlockingInputStream in) {
            this.in = in;
        }

        @Override
        public int read(long timeout, boolean isPeek) throws IOException {
            if (this.closed.get()) {
                throw new ClosedException();
            }
            return this.in.read(timeout, isPeek);
        }

        @Override
        public void close() throws IOException {
            this.closed.set(true);
        }
    }
}

