/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.Set;
import java.util.function.BiConsumer;
import org.apache.lucene.util.SPIClassIterator;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.security.authc.AuthenticationFailureHandler;
import org.elasticsearch.xpack.core.security.authc.Realm;
import org.elasticsearch.xpack.core.security.authz.store.RoleRetrievalResult;

public interface SecurityExtension {
    default public Map<String, Realm.Factory> getRealms(ResourceWatcherService resourceWatcherService) {
        return Collections.emptyMap();
    }

    default public Map<String, Set<Setting<?>>> getRealmSettings() {
        return Collections.emptyMap();
    }

    default public AuthenticationFailureHandler getAuthenticationFailureHandler() {
        return null;
    }

    default public List<BiConsumer<Set<String>, ActionListener<RoleRetrievalResult>>> getRolesProviders(Settings settings, ResourceWatcherService resourceWatcherService) {
        return Collections.emptyList();
    }

    public static List<SecurityExtension> loadExtensions(ClassLoader loader) {
        SPIClassIterator iterator = SPIClassIterator.get(SecurityExtension.class, (ClassLoader)loader);
        ArrayList<SecurityExtension> extensions = new ArrayList<SecurityExtension>();
        while (iterator.hasNext()) {
            Class c = iterator.next();
            try {
                extensions.add((SecurityExtension)c.getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (Exception e) {
                throw new ServiceConfigurationError("failed to load security extension [" + c.getName() + "]", e);
            }
        }
        return extensions;
    }
}

