/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.XPackField;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;

public abstract class Collector
extends AbstractComponent {
    public static final Setting<List<String>> INDICES = Setting.listSetting((String)Collector.collectionSetting("indices"), Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    private final String name;
    private final Setting<TimeValue> collectionTimeoutSetting;
    protected final ClusterService clusterService;
    protected final XPackLicenseState licenseState;

    public Collector(Settings settings, String name, ClusterService clusterService, Setting<TimeValue> timeoutSetting, XPackLicenseState licenseState) {
        super(settings);
        this.name = name;
        this.clusterService = clusterService;
        this.collectionTimeoutSetting = timeoutSetting;
        this.licenseState = licenseState;
    }

    public String name() {
        return this.name;
    }

    public String toString() {
        return this.name();
    }

    protected boolean shouldCollect(boolean isElectedMaster) {
        if (!this.licenseState.isMonitoringAllowed()) {
            this.logger.trace("collector [{}] can not collect data due to invalid license", (Object)this.name());
            return false;
        }
        return true;
    }

    public Collection<MonitoringDoc> collect(long timestamp, long interval, ClusterState clusterState) {
        try {
            boolean isElectedMaster = clusterState.getNodes().isLocalNodeElectedMaster();
            if (this.shouldCollect(isElectedMaster)) {
                this.logger.trace("collector [{}] - collecting data...", (Object)this.name());
                return this.doCollect(Collector.convertNode(timestamp, this.clusterService.localNode()), interval, clusterState);
            }
        }
        catch (ElasticsearchTimeoutException e) {
            this.logger.error(() -> new ParameterizedMessage("collector [{}] timed out when collecting data", (Object)this.name()));
        }
        catch (Exception e) {
            this.logger.error(() -> new ParameterizedMessage("collector [{}] failed to collect data", (Object)this.name()), (Throwable)e);
        }
        return null;
    }

    protected abstract Collection<MonitoringDoc> doCollect(MonitoringDoc.Node var1, long var2, ClusterState var4) throws Exception;

    protected static long timestamp() {
        return System.currentTimeMillis();
    }

    protected static String clusterUuid(ClusterState clusterState) {
        return clusterState.metaData().clusterUUID();
    }

    public TimeValue getCollectionTimeout() {
        if (this.collectionTimeoutSetting == null) {
            return null;
        }
        return (TimeValue)this.clusterService.getClusterSettings().get(this.collectionTimeoutSetting);
    }

    public String[] getCollectionIndices() {
        List indices = (List)this.clusterService.getClusterSettings().get(INDICES);
        assert (indices != null);
        if (indices.isEmpty()) {
            return Strings.EMPTY_ARRAY;
        }
        return indices.toArray(new String[indices.size()]);
    }

    public static MonitoringDoc.Node convertNode(long timestamp, @Nullable DiscoveryNode node) {
        if (node == null) {
            return null;
        }
        return new MonitoringDoc.Node(node.getId(), node.getHostName(), node.getAddress().toString(), node.getHostAddress(), node.getName(), timestamp);
    }

    protected static String collectionSetting(String settingName) {
        Objects.requireNonNull(settingName, "setting name must not be null");
        return XPackField.featureSettingPrefix((String)"monitoring") + ".collection." + settingName;
    }

    protected static Setting<TimeValue> collectionTimeoutSetting(String settingName) {
        String name = Collector.collectionSetting(settingName);
        return Setting.timeSetting((String)name, (TimeValue)TimeValue.timeValueSeconds((long)10L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope});
    }
}

