#ifndef _EFL_SELECTION_TYPES_EOT_H_
#define _EFL_SELECTION_TYPES_EOT_H_

#ifndef _EFL_SELECTION_TYPES_EOT_TYPES
#define _EFL_SELECTION_TYPES_EOT_TYPES

/** Selection type
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_SELECTION_TYPE_PRIMARY = 0, /**< Primary text selection (highlighted or
                                   * selected text) */
  EFL_SELECTION_TYPE_SECONDARY, /**< Used when primary selection is in use */
  EFL_SELECTION_TYPE_DND, /**< Drag and Drop */
  EFL_SELECTION_TYPE_CLIPBOARD /**< Clipboard selection (ctrl+C) */
} Efl_Selection_Type;

/** Selection format
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_SELECTION_FORMAT_TARGETS = -1 /* +1 */, /**< For matching every possible
                                               * atom */
  EFL_SELECTION_FORMAT_NONE = 0, /**< Content is from outside of Elementary */
  EFL_SELECTION_FORMAT_TEXT = 1, /**< Plain unformatted text: Used for things
                                  * that don't want rich markup */
  EFL_SELECTION_FORMAT_MARKUP = 2, /**< Edje textblock markup, including inline
                                    * images */
  EFL_SELECTION_FORMAT_IMAGE = 4, /**< Images */
  EFL_SELECTION_FORMAT_VCARD = 8, /**< Vcards */
  EFL_SELECTION_FORMAT_HTML = 16 /**< Raw HTML-like data (eg. webkit) */
} Efl_Selection_Format;

/** Defines the kind of action associated with the drop data
 *
 * @ingroup Efl
 */
typedef enum
{
  EFL_SELECTION_ACTION_UNKNOWN = 0, /**< Action type is unknown */
  EFL_SELECTION_ACTION_COPY, /**< Copy the data */
  EFL_SELECTION_ACTION_MOVE, /**< Move the data */
  EFL_SELECTION_ACTION_PRIVATE, /**< Private action type */
  EFL_SELECTION_ACTION_ASK, /**< Ask the user what to do */
  EFL_SELECTION_ACTION_LIST, /**< List the data */
  EFL_SELECTION_ACTION_LINK, /**< Link the data */
  EFL_SELECTION_ACTION_DESCRIPTION /**< Describe the data */
} Efl_Selection_Action;

/** Structure holding the info about selected data
 *
 * @ingroup Efl
 */
typedef struct _Efl_Selection_Data
{
  Eina_Position2D pos; /**< Coordinates of the drop (DND operations only) */
  Efl_Selection_Format format; /**< Format of the selection */
  Eina_Slice content; /**< Selection data */
  Efl_Selection_Action action; /**< Action to perform with the data */
  Efl_Object *item; /**< Item under the drag position. It is only available for
                     * container */
} Efl_Selection_Data;

/** Function pointer for getting selection
 *
 * @ingroup Efl
 */
typedef void (*Efl_Selection_Data_Ready)(void *data, Efl_Object *obj, Efl_Selection_Data *seldata);

typedef struct _Efl_Selection_Changed
{
  Efl_Selection_Type type; /**< Selection type */
  int seat; /**< The seat on which the selection changed, or NULL for "default"
             */
  void *display; /**< The display connection object, NULL under X11 */
  Eina_Bool exist; /**< EINA_TRUE if the selection has an owner */
} Efl_Selection_Changed;


#endif

#endif
