/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.p2;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.osgi.p2.P2Artifact;
import org.apache.ivy.osgi.p2.P2Descriptor;
import org.apache.ivy.osgi.p2.PropertiesParser;
import org.apache.ivy.osgi.p2.XMLInputParser;
import org.apache.ivy.osgi.util.DelegatingHandler;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;
import org.apache.ivy.util.Message;
import org.apache.ivy.util.XMLHelper;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class P2MetadataParser
implements XMLInputParser {
    private final P2Descriptor p2Descriptor;
    private int logLevel = 2;

    public P2MetadataParser(P2Descriptor p2Descriptor) {
        this.p2Descriptor = p2Descriptor;
    }

    public void setLogLevel(int logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public void parse(InputStream in) throws ParseException, IOException, SAXException {
        RepositoryHandler handler = new RepositoryHandler(this.p2Descriptor);
        try {
            XMLHelper.parse(in, null, (DefaultHandler)handler, null);
        }
        catch (ParserConfigurationException e) {
            throw new SAXException(e);
        }
    }

    private static String namespace2Type(String namespace) {
        if (namespace.equals("java.package")) {
            return "package";
        }
        if (namespace.equals("osgi.bundle")) {
            return "bundle";
        }
        return null;
    }

    private class InstructionHandler
    extends DelegatingHandler {
        private static final String INSTRUCTION = "instruction";
        private static final String KEY = "key";
        String key;

        public InstructionHandler() {
            super(INSTRUCTION);
            this.setBufferingChar(true);
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            this.key = atts.getValue(KEY);
        }
    }

    private class InstructionsHandler
    extends DelegatingHandler {
        private static final String INSTRUCTIONS = "instructions";
        String manifest;
        Boolean zipped;

        public InstructionsHandler() {
            super(INSTRUCTIONS);
            this.addChild(new InstructionHandler(), new DelegatingHandler.ChildElementHandler<InstructionHandler>(){

                @Override
                public void childHanlded(InstructionHandler child) {
                    InstructionsHandler.this.manifest = null;
                    InstructionsHandler.this.zipped = null;
                    String buffer = child.getBufferedChars().trim();
                    if ("manifest".equals(child.key)) {
                        InstructionsHandler.this.manifest = buffer;
                    } else if ("zipped".equals(child.key) && buffer.length() != 0) {
                        InstructionsHandler.this.zipped = Boolean.valueOf(buffer);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
        }
    }

    private class TouchpointDataHandler
    extends DelegatingHandler {
        private static final String TOUCHPOINTDATA = "touchpointData";
        String manifest;
        Boolean zipped;

        public TouchpointDataHandler() {
            super(TOUCHPOINTDATA);
            this.addChild(new InstructionsHandler(), new DelegatingHandler.ChildElementHandler<InstructionsHandler>(){

                @Override
                public void childHanlded(InstructionsHandler child) {
                    TouchpointDataHandler.this.manifest = child.manifest;
                    TouchpointDataHandler.this.zipped = child.zipped;
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
        }
    }

    private class ArtifactHandler
    extends DelegatingHandler {
        private static final String ARTIFACT = "artifact";
        private static final String ID = "id";
        private static final String VERSION = "version";
        private static final String CLASSIFIER = "classifier";
        P2Artifact artifact;

        public ArtifactHandler() {
            super(ARTIFACT);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            String classifier = atts.getValue(CLASSIFIER);
            try {
                this.artifact = new P2Artifact(id, new Version(version), classifier);
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on artifact '" + id + "': " + version + " (" + e.getMessage() + ")");
            }
        }
    }

    private class ArtifactsHandler
    extends DelegatingHandler {
        private static final String ARTIFACTS = "artifacts";
        private static final String SIZE = "size";
        List<P2Artifact> artifacts;

        public ArtifactsHandler() {
            super(ARTIFACTS);
            this.addChild(new ArtifactHandler(), new DelegatingHandler.ChildElementHandler<ArtifactHandler>(){

                @Override
                public void childHanlded(ArtifactHandler child) {
                    ArtifactsHandler.this.artifacts.add(child.artifact);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.artifacts = new ArrayList<P2Artifact>(size);
        }
    }

    private class MetaRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String META_REQUIREMENTS = "metaRequirements";

        public MetaRequirementsHandler() {
            super(META_REQUIREMENTS);
        }
    }

    private class HostRequirementsHandler
    extends AbstractRequirementHandler {
        private static final String HOST_REQUIREMENTS = "hostRequirements";

        public HostRequirementsHandler() {
            super(HOST_REQUIREMENTS);
        }
    }

    private class RequiredHandler
    extends DelegatingHandler {
        private static final String REQUIRED = "required";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String RANGE = "range";
        private static final String OPTIONAL = "optional";
        String namespace;
        String name;
        VersionRange range;
        boolean optional;

        public RequiredHandler() {
            super(REQUIRED);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXParseException {
            this.namespace = atts.getValue(NAMESPACE);
            this.name = atts.getValue(NAME);
            try {
                this.range = new VersionRange(atts.getValue(RANGE));
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            this.optional = this.getOptionalBooleanAttribute(atts, OPTIONAL, Boolean.FALSE);
        }
    }

    private class RequiresHandler
    extends AbstractRequirementHandler {
        private static final String REQUIRES = "requires";

        public RequiresHandler() {
            super(REQUIRES);
        }
    }

    abstract class AbstractRequirementHandler
    extends DelegatingHandler {
        private static final String SIZE = "size";
        List<BundleRequirement> requirements;

        public AbstractRequirementHandler(String name) {
            super(name);
            this.addChild(new RequiredHandler(), new DelegatingHandler.ChildElementHandler<RequiredHandler>(){

                @Override
                public void childHanlded(RequiredHandler child) {
                    String name = child.name;
                    VersionRange range = child.range;
                    String type = P2MetadataParser.namespace2Type(child.namespace);
                    if (type == null) {
                        if (P2MetadataParser.this.logLevel >= 4) {
                            Message.debug("Unsupported required capability " + child.namespace + " " + name + " " + range);
                        }
                    } else {
                        String resolution = child.optional ? "optional" : null;
                        AbstractRequirementHandler.this.requirements.add(new BundleRequirement(type, name, range, resolution));
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.requirements = new ArrayList<BundleRequirement>(size);
        }
    }

    private static class ProvidedHandler
    extends DelegatingHandler {
        private static final String PROVIDED = "provided";
        private static final String NAMESPACE = "namespace";
        private static final String NAME = "name";
        private static final String VERSION = "version";
        String namespace;
        String name;
        Version version;

        public ProvidedHandler() {
            super(PROVIDED);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            this.namespace = atts.getValue(NAMESPACE);
            this.name = atts.getValue(NAME);
            try {
                this.version = new Version(atts.getValue(VERSION));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on provided capability: " + this.version + " (" + e.getMessage() + ")");
            }
        }
    }

    private class ProvidesHandler
    extends DelegatingHandler {
        private static final String PROVIDES = "provides";
        private static final String SIZE = "size";
        List<BundleCapability> capabilities;
        String eclipseType;

        public ProvidesHandler() {
            super(PROVIDES);
            this.addChild(new ProvidedHandler(), new DelegatingHandler.ChildElementHandler<ProvidedHandler>(){

                @Override
                public void childHanlded(ProvidedHandler child) {
                    if (child.namespace.equals("org.eclipse.equinox.p2.eclipse.type")) {
                        ProvidesHandler.this.eclipseType = child.name;
                    } else {
                        String type = P2MetadataParser.namespace2Type(child.namespace);
                        if (type == null) {
                            if (P2MetadataParser.this.logLevel >= 4) {
                                Message.debug("Unsupported provided capability " + child.namespace + " " + child.name + " " + child.version);
                            }
                            return;
                        }
                        BundleCapability capability = type == "package" ? new ExportPackage(child.name, child.version) : new BundleCapability(type, child.name, child.version);
                        ProvidesHandler.this.capabilities.add(capability);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.capabilities = new ArrayList<BundleCapability>(size);
        }
    }

    private static class FilterHandler
    extends DelegatingHandler {
        private static final String FILTER = "filter";

        public FilterHandler() {
            super(FILTER);
            this.setBufferingChar(true);
        }
    }

    class UnitHandler
    extends DelegatingHandler {
        private static final String CATEGORY_PROPERTY = "org.eclipse.equinox.p2.type.category";
        private static final String UNIT = "unit";
        private static final String ID = "id";
        private static final String VERSION = "version";
        BundleInfo bundleInfo;

        public UnitHandler() {
            super(UNIT);
            this.addChild(new PropertiesParser.PropertiesHandler(new String[]{CATEGORY_PROPERTY}), new DelegatingHandler.ChildElementHandler<PropertiesParser.PropertiesHandler>(){

                @Override
                public void childHanlded(PropertiesParser.PropertiesHandler child) {
                    String category = child.properties.get(UnitHandler.CATEGORY_PROPERTY);
                    if (category != null && Boolean.valueOf(category).booleanValue()) {
                        child.getParent().skip();
                        UnitHandler.this.bundleInfo = null;
                    }
                }
            });
            this.addChild(new ProvidesHandler(), new DelegatingHandler.ChildElementHandler<ProvidesHandler>(){

                @Override
                public void childHanlded(ProvidesHandler child) {
                    if ("source".equals(child.eclipseType)) {
                        UnitHandler.this.bundleInfo.setSource(true);
                        String symbolicName = UnitHandler.this.bundleInfo.getSymbolicName();
                        if (symbolicName.endsWith(".source")) {
                            UnitHandler.this.bundleInfo.setSymbolicNameTarget(symbolicName.substring(0, symbolicName.length() - 7));
                            UnitHandler.this.bundleInfo.setVersionTarget(UnitHandler.this.bundleInfo.getVersion());
                        }
                    }
                    for (BundleCapability capability : child.capabilities) {
                        UnitHandler.this.bundleInfo.addCapability(capability);
                    }
                }
            });
            this.addChild(new FilterHandler(), new DelegatingHandler.ChildElementHandler<FilterHandler>(){

                @Override
                public void childHanlded(FilterHandler child) {
                }
            });
            this.addChild(new RequiresHandler(), new DelegatingHandler.ChildElementHandler<RequiresHandler>(){

                @Override
                public void childHanlded(RequiresHandler child) {
                    for (BundleRequirement requirement : child.requirements) {
                        UnitHandler.this.bundleInfo.addRequirement(requirement);
                    }
                }
            });
            this.addChild(new HostRequirementsHandler(), new DelegatingHandler.ChildElementHandler<HostRequirementsHandler>(){

                @Override
                public void childHanlded(HostRequirementsHandler child) {
                }
            });
            this.addChild(new MetaRequirementsHandler(), new DelegatingHandler.ChildElementHandler<MetaRequirementsHandler>(){

                @Override
                public void childHanlded(MetaRequirementsHandler child) {
                }
            });
            this.addChild(new ArtifactsHandler(), new DelegatingHandler.ChildElementHandler<ArtifactsHandler>(){

                @Override
                public void childHanlded(ArtifactsHandler child) {
                }
            });
            this.addChild(new TouchpointDataHandler(), new DelegatingHandler.ChildElementHandler<TouchpointDataHandler>(){

                @Override
                public void childHanlded(TouchpointDataHandler child) throws SAXParseException {
                    if (child.zipped != null) {
                        UnitHandler.this.bundleInfo.setHasInnerClasspath(child.zipped);
                    }
                    if (!UnitHandler.this.bundleInfo.isSource()) {
                        return;
                    }
                    if (child.manifest != null) {
                        BundleInfo embeddedInfo;
                        String manifest = ManifestParser.formatLines(child.manifest.trim());
                        try {
                            embeddedInfo = ManifestParser.parseManifest(manifest);
                        }
                        catch (IOException e) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " could not be parsed", e);
                            }
                            return;
                        }
                        catch (ParseException e) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is ill formed", e);
                            }
                            return;
                        }
                        if (!embeddedInfo.isSource()) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is not declaring being a source.");
                            }
                            return;
                        }
                        String symbolicNameTarget = embeddedInfo.getSymbolicNameTarget();
                        if (symbolicNameTarget == null) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is not declaring a target symbolic name.");
                            }
                            return;
                        }
                        Version versionTarget = embeddedInfo.getVersionTarget();
                        if (versionTarget == null) {
                            if (P2MetadataParser.this.logLevel >= 3) {
                                Message.verbose("The Manifest of the source bundle " + UnitHandler.this.bundleInfo.getSymbolicName() + " is not declaring a target version.");
                            }
                            return;
                        }
                        UnitHandler.this.bundleInfo.setSymbolicNameTarget(symbolicNameTarget);
                        UnitHandler.this.bundleInfo.setVersionTarget(versionTarget);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            String id = atts.getValue(ID);
            String version = atts.getValue(VERSION);
            try {
                this.bundleInfo = new BundleInfo(id, new Version(version));
            }
            catch (ParseException e) {
                throw new SAXException("Incorrect version on bundle '" + id + "': " + version + " (" + e.getMessage() + ")");
            }
        }
    }

    private class UnitsHandler
    extends DelegatingHandler {
        private static final String UNITS = "units";
        private static final String SIZE = "size";
        List<BundleInfo> bundles;

        public UnitsHandler() {
            super(UNITS);
            this.addChild(new UnitHandler(), new DelegatingHandler.ChildElementHandler<UnitHandler>(){

                @Override
                public void childHanlded(UnitHandler child) {
                    if (child.bundleInfo != null && !child.bundleInfo.getCapabilities().isEmpty()) {
                        UnitsHandler.this.bundles.add(child.bundleInfo);
                    }
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.bundles = new ArrayList<BundleInfo>(size);
        }
    }

    private class RepositoryReferenceHandler
    extends DelegatingHandler {
        private static final String REPOSITORY = "repository";
        private static final String URI = "uri";
        private static final String URL = "url";
        URI uri;

        public RepositoryReferenceHandler() {
            super(REPOSITORY);
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            String uriAtt = atts.getValue(URI);
            String urlAtt = atts.getValue(URL);
            if (uriAtt != null) {
                try {
                    this.uri = new URI(uriAtt);
                }
                catch (URISyntaxException e) {
                    throw new SAXParseException("Invalid uri attribute " + uriAtt + "(" + e.getMessage() + ")", this.getLocator());
                }
            }
            if (this.uri != null && urlAtt != null) {
                try {
                    this.uri = new URI(urlAtt);
                }
                catch (URISyntaxException e) {
                    throw new SAXParseException("Invalid url attribute " + urlAtt + "(" + e.getMessage() + ")", this.getLocator());
                }
            }
        }
    }

    private class ReferencesHandler
    extends DelegatingHandler {
        private static final String REFERENCES = "references";
        private static final String SIZE = "size";
        List<URI> repositoryUris;

        public ReferencesHandler() {
            super(REFERENCES);
            this.addChild(new RepositoryReferenceHandler(), new DelegatingHandler.ChildElementHandler<RepositoryReferenceHandler>(){

                @Override
                public void childHanlded(RepositoryReferenceHandler child) {
                    ReferencesHandler.this.repositoryUris.add(child.uri);
                }
            });
        }

        @Override
        protected void handleAttributes(Attributes atts) throws SAXException {
            int size = Integer.parseInt(atts.getValue(SIZE));
            this.repositoryUris = new ArrayList<URI>(size);
        }
    }

    private class RepositoryHandler
    extends DelegatingHandler {
        private static final String REPOSITORY = "repository";

        public RepositoryHandler(final P2Descriptor p2Descriptor) {
            super(REPOSITORY);
            this.addChild(new UnitsHandler(), new DelegatingHandler.ChildElementHandler<UnitsHandler>(){

                @Override
                public void childHanlded(UnitsHandler child) {
                    for (BundleInfo bundle : child.bundles) {
                        p2Descriptor.addBundle(bundle);
                    }
                }
            });
            this.addChild(new ReferencesHandler(), new DelegatingHandler.ChildElementHandler<ReferencesHandler>(){

                @Override
                public void childHanlded(ReferencesHandler child) {
                }
            });
        }
    }
}

