/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.io;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.Authenticator;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.data.osm.Changeset;
import org.openstreetmap.josm.data.osm.IPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.CacheCustomContent;
import org.openstreetmap.josm.io.Capabilities;
import org.openstreetmap.josm.io.ChangesetClosedException;
import org.openstreetmap.josm.io.DiffResultProcessor;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.io.OnlineResource;
import org.openstreetmap.josm.io.OsmApiException;
import org.openstreetmap.josm.io.OsmApiInitializationException;
import org.openstreetmap.josm.io.OsmApiPrimitiveGoneException;
import org.openstreetmap.josm.io.OsmChangeBuilder;
import org.openstreetmap.josm.io.OsmConnection;
import org.openstreetmap.josm.io.OsmTransferCanceledException;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.io.OsmWriter;
import org.openstreetmap.josm.io.OsmWriterFactory;
import org.openstreetmap.josm.io.auth.CredentialsManager;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.CheckParameterUtil;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ListenerList;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;
import org.openstreetmap.josm.tools.XmlParsingException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class OsmApi
extends OsmConnection {
    public static final int DEFAULT_MAX_NUM_RETRIES = 5;
    public static final int MAX_DOWNLOAD_THREADS = 2;
    @Deprecated
    public static final String DEFAULT_API_URL = "https://api.openstreetmap.org/api";
    private static final Map<String, OsmApi> instances = new HashMap<String, OsmApi>();
    private static final ListenerList<OsmApiInitializationListener> listeners = ListenerList.create();
    private URL url;
    private final String serverUrl;
    private Changeset changeset;
    private String version;
    private Capabilities capabilities;
    private boolean initialized;

    public static void addOsmApiInitializationListener(OsmApiInitializationListener listener) {
        listeners.addListener(listener);
    }

    public static void removeOsmApiInitializationListener(OsmApiInitializationListener listener) {
        listeners.removeListener(listener);
    }

    public static OsmApi getOsmApi(String serverUrl) {
        OsmApi api = instances.get(serverUrl);
        if (api == null) {
            api = new OsmApi(serverUrl);
            OsmApi.cacheInstance(api);
        }
        return api;
    }

    protected static void cacheInstance(OsmApi api) {
        instances.put(api.getServerUrl(), api);
    }

    private static String getServerUrlFromPref() {
        return Config.getPref().get("osm-server.url", Config.getUrls().getDefaultOsmApiUrl());
    }

    public static OsmApi getOsmApi() {
        return OsmApi.getOsmApi(OsmApi.getServerUrlFromPref());
    }

    protected OsmApi(String serverUrl) {
        CheckParameterUtil.ensureParameterNotNull(serverUrl, "serverUrl");
        this.serverUrl = serverUrl;
    }

    public String getVersion() {
        return this.version;
    }

    public String getHost() {
        String host = null;
        try {
            host = new URL(this.serverUrl).getHost();
        }
        catch (MalformedURLException e) {
            Logging.warn(e);
        }
        return host;
    }

    public void initialize(ProgressMonitor monitor) throws OsmTransferCanceledException, OsmApiInitializationException {
        this.initialize(monitor, false);
    }

    public void initialize(ProgressMonitor monitor, boolean fastFail) throws OsmTransferCanceledException, OsmApiInitializationException {
        if (this.initialized) {
            return;
        }
        this.cancel = false;
        try {
            CapabilitiesCache cache = new CapabilitiesCache(monitor, fastFail);
            try {
                this.initializeCapabilities(cache.updateIfRequiredString());
            }
            catch (SAXParseException parseException) {
                Logging.trace(parseException);
                this.initializeCapabilities(cache.updateForceString());
            }
            catch (SecurityException e) {
                Logging.log(Logging.LEVEL_ERROR, "Unable to initialize OSM API", e);
            }
            if (this.capabilities == null) {
                if (NetworkManager.isOffline(OnlineResource.OSM_API)) {
                    Logging.warn(I18n.tr("{0} not available (offline mode)", I18n.tr("OSM API", new Object[0])));
                } else {
                    Logging.error(I18n.tr("Unable to initialize OSM API.", new Object[0]));
                }
                return;
            }
            if (!this.capabilities.supportsVersion("0.6")) {
                Logging.error(I18n.tr("This version of JOSM is incompatible with the configured server.", new Object[0]));
                Logging.error(I18n.tr("It supports protocol version 0.6, while the server says it supports {0} to {1}.", this.capabilities.get("version", "minimum"), this.capabilities.get("version", "maximum")));
                return;
            }
            this.version = "0.6";
            this.initialized = true;
            listeners.fireEvent(l -> l.apiInitialized(this));
        }
        catch (OsmTransferCanceledException e) {
            throw e;
        }
        catch (OsmTransferException e) {
            this.initialized = false;
            NetworkManager.addNetworkError(this.url, Utils.getRootCause(e));
            throw new OsmApiInitializationException(e);
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            this.initialized = false;
            throw new OsmApiInitializationException(e);
        }
    }

    private synchronized void initializeCapabilities(String xml) throws SAXException, IOException, ParserConfigurationException {
        if (xml != null) {
            this.capabilities = Capabilities.CapabilitiesParser.parse(new InputSource(new StringReader(xml)));
        }
    }

    protected final String toXml(IPrimitive o, boolean addBody) {
        StringWriter swriter = new StringWriter();
        try (OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(swriter), true, this.version);){
            swriter.getBuffer().setLength(0);
            osmWriter.setWithBody(addBody);
            osmWriter.setChangeset(this.changeset);
            osmWriter.header();
            o.accept(osmWriter);
            osmWriter.footer();
            osmWriter.flush();
        }
        catch (IOException e) {
            Logging.warn(e);
        }
        return swriter.toString();
    }

    protected final String toXml(Changeset s) {
        StringWriter swriter = new StringWriter();
        try (OsmWriter osmWriter = OsmWriterFactory.createOsmWriter(new PrintWriter(swriter), true, this.version);){
            swriter.getBuffer().setLength(0);
            osmWriter.header();
            osmWriter.visit(s);
            osmWriter.footer();
            osmWriter.flush();
        }
        catch (IOException e) {
            Logging.warn(e);
        }
        return swriter.toString();
    }

    private static String getBaseUrl(String serverUrl, String version) {
        int p;
        StringBuilder rv = new StringBuilder(serverUrl);
        if (version != null) {
            rv.append('/').append(version);
        }
        rv.append('/');
        while ((p = rv.indexOf("//", rv.indexOf("://") + 2)) > -1) {
            rv.delete(p, p + 1);
        }
        return rv.toString();
    }

    public String getBaseUrl() {
        return OsmApi.getBaseUrl(this.serverUrl, this.version);
    }

    public String getServerUrl() {
        return this.serverUrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void individualPrimitiveModification(String method, String verb, IPrimitive osm, ProgressMonitor monitor, Consumer<String> consumer, Function<String, String> errHandler) throws OsmTransferException {
        String ret = "";
        try {
            this.ensureValidChangeset();
            this.initialize(monitor);
            ret = this.sendRequest(method, OsmPrimitiveType.from(osm).getAPIName() + '/' + verb, this.toXml(osm, true), monitor);
            boolean locked = false;
            if (osm instanceof OsmPrimitive && (locked = ((OsmPrimitive)osm).getDataSet().isLocked())) {
                ((OsmPrimitive)osm).getDataSet().unlock();
            }
            try {
                consumer.accept(ret);
            }
            finally {
                if (locked) {
                    ((OsmPrimitive)osm).getDataSet().lock();
                }
            }
        }
        catch (NumberFormatException e) {
            throw new OsmTransferException(errHandler.apply(ret), e);
        }
    }

    public void createPrimitive(IPrimitive osm, ProgressMonitor monitor) throws OsmTransferException {
        this.individualPrimitiveModification("PUT", "create", osm, monitor, ret -> {
            osm.setOsmId(Long.parseLong(ret.trim()), 1);
            osm.setChangesetId(this.getChangeset().getId());
        }, ret -> I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", ret));
    }

    public void modifyPrimitive(IPrimitive osm, ProgressMonitor monitor) throws OsmTransferException {
        this.individualPrimitiveModification("PUT", Long.toString(osm.getId()), osm, monitor, ret -> {
            osm.setOsmId(osm.getId(), Integer.parseInt(ret.trim()));
            osm.setChangesetId(this.getChangeset().getId());
            osm.setVisible(true);
        }, ret -> I18n.tr("Unexpected format of new version of modified primitive ''{0}''. Got ''{1}''.", osm.getId(), ret));
    }

    public void deletePrimitive(OsmPrimitive osm, ProgressMonitor monitor) throws OsmTransferException {
        this.individualPrimitiveModification("DELETE", Long.toString(osm.getId()), osm, monitor, ret -> {
            osm.setOsmId(osm.getId(), Integer.parseInt(ret.trim()));
            osm.setChangesetId(this.getChangeset().getId());
            osm.setVisible(false);
        }, ret -> I18n.tr("Unexpected format of new version of deleted primitive ''{0}''. Got ''{1}''.", osm.getId(), ret));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openChangeset(Changeset changeset, ProgressMonitor progressMonitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        try {
            progressMonitor.beginTask(I18n.tr("Creating changeset...", new Object[0]));
            this.initialize(progressMonitor);
            String ret = "";
            try {
                ret = this.sendRequest("PUT", "changeset/create", this.toXml(changeset), progressMonitor);
                changeset.setId(Integer.parseInt(ret.trim()));
                changeset.setOpen(true);
            }
            catch (NumberFormatException e) {
                throw new OsmTransferException(I18n.tr("Unexpected format of ID replied by the server. Got ''{0}''.", ret), e);
            }
            progressMonitor.setCustomText(I18n.tr("Successfully opened changeset {0}", changeset.getId()));
        }
        finally {
            progressMonitor.finishTask();
        }
    }

    public void updateChangeset(Changeset changeset, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            monitor.beginTask(I18n.tr("Updating changeset...", new Object[0]));
            this.initialize(monitor);
            monitor.setCustomText(I18n.tr("Updating changeset {0}...", changeset.getId()));
            this.sendRequest("PUT", "changeset/" + changeset.getId(), this.toXml(changeset), monitor);
        }
        catch (ChangesetClosedException e) {
            e.setSource(ChangesetClosedException.Source.UPDATE_CHANGESET);
            throw e;
        }
        catch (OsmApiException e) {
            String errorHeader = e.getErrorHeader();
            if (e.getResponseCode() == 409 && ChangesetClosedException.errorHeaderMatchesPattern(errorHeader)) {
                throw new ChangesetClosedException(errorHeader, ChangesetClosedException.Source.UPDATE_CHANGESET, e);
            }
            throw e;
        }
        finally {
            monitor.finishTask();
        }
    }

    public void closeChangeset(Changeset changeset, ProgressMonitor monitor) throws OsmTransferException {
        CheckParameterUtil.ensureParameterNotNull(changeset, "changeset");
        if (monitor == null) {
            monitor = NullProgressMonitor.INSTANCE;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        try {
            monitor.beginTask(I18n.tr("Closing changeset...", new Object[0]));
            this.initialize(monitor);
            this.sendRequest("PUT", "changeset/" + changeset.getId() + "/close", "\r\n", monitor);
            changeset.setOpen(false);
        }
        finally {
            monitor.finishTask();
        }
    }

    public Collection<OsmPrimitive> uploadDiff(Collection<? extends OsmPrimitive> list, ProgressMonitor monitor) throws OsmTransferException {
        try {
            monitor.beginTask("", list.size() * 2);
            if (this.changeset == null) {
                throw new OsmTransferException(I18n.tr("No changeset present for diff upload.", new Object[0]));
            }
            this.initialize(monitor);
            OsmChangeBuilder changeBuilder = new OsmChangeBuilder(this.changeset);
            monitor.subTask(I18n.tr("Preparing upload request...", new Object[0]));
            changeBuilder.start();
            changeBuilder.append(list);
            changeBuilder.finish();
            String diffUploadRequest = changeBuilder.getDocument();
            monitor.indeterminateSubTask(I18n.trn("Uploading {0} object...", "Uploading {0} objects...", list.size(), list.size()));
            String diffUploadResponse = this.sendRequest("POST", "changeset/" + this.changeset.getId() + "/upload", diffUploadRequest, monitor);
            DiffResultProcessor reader = new DiffResultProcessor(list);
            reader.parse(diffUploadResponse, monitor.createSubTaskMonitor(-1, false));
            Set<OsmPrimitive> set = reader.postProcess(this.getChangeset(), monitor.createSubTaskMonitor(-1, false));
            return set;
        }
        catch (OsmTransferException e) {
            throw e;
        }
        catch (XmlParsingException e) {
            throw new OsmTransferException(e);
        }
        finally {
            monitor.finishTask();
        }
    }

    private void sleepAndListen(int retry, ProgressMonitor monitor) throws OsmTransferCanceledException {
        Logging.info(I18n.tr("Waiting 10 seconds ... ", new Object[0]));
        for (int i = 0; i < 10; ++i) {
            if (monitor != null) {
                monitor.setCustomText(I18n.tr("Starting retry {0} of {1} in {2} seconds ...", this.getMaxRetries() - retry, this.getMaxRetries(), 10 - i));
            }
            if (this.cancel) {
                throw new OsmTransferCanceledException("Operation canceled" + (i > 0 ? " in retry #" + i : ""));
            }
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException ex) {
                Logging.warn("InterruptedException in " + this.getClass().getSimpleName() + " during sleep");
                Thread.currentThread().interrupt();
            }
        }
        Logging.info(I18n.tr("OK - trying again.", new Object[0]));
    }

    protected int getMaxRetries() {
        int ret = Config.getPref().getInt("osm-server.max-num-retries", 5);
        return Math.max(ret, 0);
    }

    public static boolean isUsingOAuth() {
        return "oauth".equals(OsmApi.getAuthMethod());
    }

    public static String getAuthMethod() {
        return Config.getPref().get("osm-server.auth-method", "oauth");
    }

    protected final String sendRequest(String requestMethod, String urlSuffix, String requestBody, ProgressMonitor monitor) throws OsmTransferException {
        return this.sendRequest(requestMethod, urlSuffix, requestBody, monitor, true, false);
    }

    /*
     * Loose catch block
     */
    protected final String sendRequest(String requestMethod, String urlSuffix, String requestBody, ProgressMonitor monitor, boolean doAuthenticate, boolean fastFail) throws OsmTransferException {
        int retries = fastFail ? 0 : this.getMaxRetries();
        while (true) {
            try {
                int retCode;
                HttpClient.Response response;
                HttpClient client;
                while (true) {
                    this.url = new URL(new URL(this.getBaseUrl()), urlSuffix);
                    this.activeConnection = client = HttpClient.create(this.url, requestMethod).keepAlive(false);
                    if (fastFail) {
                        client.setConnectTimeout(1000);
                        client.setReadTimeout(1000);
                    } else {
                        client.setReadTimeout(0);
                    }
                    if (doAuthenticate) {
                        this.addAuth(client);
                    }
                    if ("PUT".equals(requestMethod) || "POST".equals(requestMethod) || "DELETE".equals(requestMethod)) {
                        client.setHeader("Content-Type", "text/xml");
                        client.setRequestBody((requestBody != null ? requestBody : "").getBytes(StandardCharsets.UTF_8));
                    }
                    response = client.connect();
                    Logging.info(response.getResponseMessage());
                    retCode = response.getResponseCode();
                    if (retCode < 500 || retries-- <= 0) break;
                    this.sleepAndListen(retries, monitor);
                    Logging.info(I18n.tr("Starting retry {0} of {1}.", this.getMaxRetries() - retries, this.getMaxRetries()));
                }
                String responseBody = response.fetchContent();
                String errorHeader = null;
                if (response.getHeaderField("Error") != null) {
                    errorHeader = response.getHeaderField("Error");
                    Logging.error("Error header: " + errorHeader);
                } else if (retCode != 200 && responseBody.length() > 0) {
                    Logging.error("Error body: " + responseBody);
                }
                this.activeConnection.disconnect();
                errorHeader = errorHeader == null ? null : errorHeader.trim();
                String errorBody = responseBody.length() == 0 ? null : responseBody.trim();
                switch (retCode) {
                    case 200: {
                        return responseBody;
                    }
                    case 410: {
                        throw new OsmApiPrimitiveGoneException(errorHeader, errorBody);
                    }
                    case 409: {
                        if (ChangesetClosedException.errorHeaderMatchesPattern(errorHeader)) {
                            throw new ChangesetClosedException(errorBody, ChangesetClosedException.Source.UPLOAD_DATA);
                        }
                        throw new OsmApiException(retCode, errorHeader, errorBody);
                    }
                    case 401: 
                    case 403: {
                        CredentialsManager.getInstance().purgeCredentialsCache(Authenticator.RequestorType.SERVER);
                        throw new OsmApiException(retCode, errorHeader, errorBody, this.activeConnection.getURL().toString(), doAuthenticate ? this.retrieveBasicAuthorizationLogin(client) : null, response.getContentType());
                    }
                }
                throw new OsmApiException(retCode, errorHeader, errorBody);
            }
            catch (ConnectException | SocketTimeoutException e) {
                if (retries-- > 0) continue;
                throw new OsmTransferException(e);
            }
            catch (IOException e) {
                throw new OsmTransferException(e);
            }
            break;
        }
        catch (OsmTransferException e) {
            throw e;
        }
    }

    public synchronized Capabilities getCapabilities() {
        return this.capabilities;
    }

    protected void ensureValidChangeset() throws OsmTransferException {
        if (this.changeset == null) {
            throw new OsmTransferException(I18n.tr("Current changeset is null. Cannot upload data.", new Object[0]));
        }
        if (this.changeset.getId() <= 0) {
            throw new OsmTransferException(I18n.tr("ID of current changeset > 0 required. Current ID is {0}.", this.changeset.getId()));
        }
    }

    public Changeset getChangeset() {
        return this.changeset;
    }

    public void setChangeset(Changeset changeset) {
        if (changeset == null) {
            this.changeset = null;
            return;
        }
        if (changeset.getId() <= 0) {
            throw new IllegalArgumentException(I18n.tr("Changeset ID > 0 expected. Got {0}.", changeset.getId()));
        }
        if (!changeset.isOpen()) {
            throw new IllegalArgumentException(I18n.tr("Open changeset expected. Got closed changeset with id {0}.", changeset.getId()));
        }
        this.changeset = changeset;
    }

    private static StringBuilder noteStringBuilder(Note note) {
        return new StringBuilder().append("notes/").append(note.getId());
    }

    public Note createNote(LatLon latlon, String text, ProgressMonitor monitor) throws OsmTransferException {
        this.initialize(monitor);
        String noteUrl = "notes?lat=" + latlon.lat() + "&lon=" + latlon.lon() + "&text=" + Utils.encodeUrl(text);
        String response = this.sendRequest("POST", noteUrl, null, monitor, true, false);
        return OsmApi.parseSingleNote(response);
    }

    public Note addCommentToNote(Note note, String comment, ProgressMonitor monitor) throws OsmTransferException {
        this.initialize(monitor);
        String noteUrl = OsmApi.noteStringBuilder(note).append("/comment?text=").append(Utils.encodeUrl(comment)).toString();
        String response = this.sendRequest("POST", noteUrl, null, monitor, true, false);
        return OsmApi.parseSingleNote(response);
    }

    public Note closeNote(Note note, String closeMessage, ProgressMonitor monitor) throws OsmTransferException {
        this.initialize(monitor);
        String encodedMessage = Utils.encodeUrl(closeMessage);
        StringBuilder urlBuilder = OsmApi.noteStringBuilder(note).append("/close");
        if (!encodedMessage.trim().isEmpty()) {
            urlBuilder.append("?text=");
            urlBuilder.append(encodedMessage);
        }
        String response = this.sendRequest("POST", urlBuilder.toString(), null, monitor, true, false);
        return OsmApi.parseSingleNote(response);
    }

    public Note reopenNote(Note note, String reactivateMessage, ProgressMonitor monitor) throws OsmTransferException {
        this.initialize(monitor);
        String encodedMessage = Utils.encodeUrl(reactivateMessage);
        StringBuilder urlBuilder = OsmApi.noteStringBuilder(note).append("/reopen");
        if (!encodedMessage.trim().isEmpty()) {
            urlBuilder.append("?text=");
            urlBuilder.append(encodedMessage);
        }
        String response = this.sendRequest("POST", urlBuilder.toString(), null, monitor, true, false);
        return OsmApi.parseSingleNote(response);
    }

    private static Note parseSingleNote(String xml) throws OsmTransferException {
        try {
            List<Note> newNotes = new NoteReader(xml).parse();
            if (newNotes.size() == 1) {
                return newNotes.get(0);
            }
            throw new OsmTransferException(I18n.tr("Note upload failed", new Object[0]));
        }
        catch (IOException | SAXException e) {
            Logging.error(e);
            throw new OsmTransferException(I18n.tr("Error parsing note response from server", new Object[0]), e);
        }
    }

    private class CapabilitiesCache
    extends CacheCustomContent<OsmTransferException> {
        private static final String CAPABILITIES = "capabilities";
        private final ProgressMonitor monitor;
        private final boolean fastFail;

        CapabilitiesCache(ProgressMonitor monitor, boolean fastFail) {
            super(CAPABILITIES + OsmApi.this.getBaseUrl().hashCode(), CacheCustomContent.INTERVAL_WEEKLY);
            this.monitor = monitor;
            this.fastFail = fastFail;
        }

        @Override
        protected void checkOfflineAccess() {
            OnlineResource.OSM_API.checkOfflineAccess(OsmApi.getBaseUrl(OsmApi.getServerUrlFromPref(), "0.6") + CAPABILITIES, OsmApi.getServerUrlFromPref());
        }

        @Override
        protected byte[] updateData() throws OsmTransferException {
            return OsmApi.this.sendRequest("GET", CAPABILITIES, null, this.monitor, false, this.fastFail).getBytes(StandardCharsets.UTF_8);
        }
    }

    public static interface OsmApiInitializationListener {
        public void apiInitialized(OsmApi var1);
    }
}

