// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `PropertiesAdmin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __Ice_PropertiesAdmin_h__
#define __Ice_PropertiesAdmin_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/BuiltinSequences.h>
#include <IceUtil/UndefSysMacros.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 > 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 1
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICE_API
#   if defined(ICE_STATIC_LIBS)
#       define ICE_API /**/
#   elif defined(ICE_API_EXPORTS)
#       define ICE_API ICE_DECLSPEC_EXPORT
#   else
#       define ICE_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace Ice
{

class PropertiesAdmin;
class PropertiesAdminPrx;

}

namespace Ice
{

/**
 * A simple collection of properties, represented as a dictionary of
 * key/value pairs. Both key and value are strings.
 * @see Properties#getPropertiesForPrefix
 */
using PropertyDict = ::std::map<::std::string, ::std::string>;

}

namespace Ice
{

/**
 * The PropertiesAdmin interface provides remote access to the properties
 * of a communicator.
 * \headerfile Ice/Ice.h
 */
class ICE_API PropertiesAdmin : public virtual Object
{
public:

    using ProxyType = PropertiesAdminPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param current The Current object for the invocation.
     * @return The property value.
     */
    virtual ::std::string getProperty(::std::string key, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getProperty(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param current The Current object for the invocation.
     * @return The matching property set.
     */
    virtual PropertyDict getPropertiesForPrefix(::std::string prefix, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_getPropertiesForPrefix(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param current The Current object for the invocation.
     */
    virtual void setProperties(PropertyDict newProperties, const Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setProperties(::IceInternal::Incoming&, const Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&) override;
    /// \endcond
};

}

namespace Ice
{

/**
 * The PropertiesAdmin interface provides remote access to the properties
 * of a communicator.
 * \headerfile Ice/Ice.h
 */
class ICE_CLASS(ICE_API) PropertiesAdminPrx : public virtual Proxy<PropertiesAdminPrx, ObjectPrx>
{
public:

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @return The property value.
     */
    ::std::string getProperty(const ::std::string& key, const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<::std::string>(true, this, &PropertiesAdminPrx::_iceI_getProperty, key, context).get();
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getPropertyAsync(const ::std::string& key, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<::std::string>>().get_future())
    {
        return _makePromiseOutgoing<::std::string, P>(false, this, &PropertiesAdminPrx::_iceI_getProperty, key, context);
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getPropertyAsync(const ::std::string& key,
                     ::std::function<void(::std::string)> response,
                     ::std::function<void(::std::exception_ptr)> ex = nullptr,
                     ::std::function<void(bool)> sent = nullptr,
                     const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::string>(response, ex, sent, this, &PropertiesAdminPrx::_iceI_getProperty, key, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getProperty(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::string>>&, const ::std::string&, const Context&);
    /// \endcond

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @return The matching property set.
     */
    PropertyDict getPropertiesForPrefix(const ::std::string& prefix, const Context& context = noExplicitContext)
    {
        return _makePromiseOutgoing<PropertyDict>(true, this, &PropertiesAdminPrx::_iceI_getPropertiesForPrefix, prefix, context).get();
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto getPropertiesForPrefixAsync(const ::std::string& prefix, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<PropertyDict>>().get_future())
    {
        return _makePromiseOutgoing<PropertyDict, P>(false, this, &PropertiesAdminPrx::_iceI_getPropertiesForPrefix, prefix, context);
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    getPropertiesForPrefixAsync(const ::std::string& prefix,
                                ::std::function<void(PropertyDict)> response,
                                ::std::function<void(::std::exception_ptr)> ex = nullptr,
                                ::std::function<void(bool)> sent = nullptr,
                                const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<PropertyDict>(response, ex, sent, this, &PropertiesAdminPrx::_iceI_getPropertiesForPrefix, prefix, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_getPropertiesForPrefix(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<PropertyDict>>&, const ::std::string&, const Context&);
    /// \endcond

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     */
    void setProperties(const PropertyDict& newProperties, const Context& context = noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &PropertiesAdminPrx::_iceI_setProperties, newProperties, context).get();
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setPropertiesAsync(const PropertyDict& newProperties, const Context& context = noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &PropertiesAdminPrx::_iceI_setProperties, newProperties, context);
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setPropertiesAsync(const PropertyDict& newProperties,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const Context& context = noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(response, ex, sent, this, &PropertiesAdminPrx::_iceI_setProperties, newProperties, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICE_API) void _iceI_setProperties(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const PropertyDict&, const Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    PropertiesAdminPrx() = default;
    friend ::std::shared_ptr<PropertiesAdminPrx> IceInternal::createProxy<PropertiesAdminPrx>();

    ICE_MEMBER(ICE_API) virtual ::std::shared_ptr<ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace Ice
{

using PropertiesAdminPtr = ::std::shared_ptr<PropertiesAdmin>;
using PropertiesAdminPrxPtr = ::std::shared_ptr<PropertiesAdminPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace Ice
{

class PropertiesAdmin;
/// \cond INTERNAL
ICE_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< ::IceProxy::Ice::PropertiesAdmin>&);
ICE_API ::IceProxy::Ice::Object* upCast(::IceProxy::Ice::PropertiesAdmin*);
/// \endcond

}

}

namespace Ice
{

class PropertiesAdmin;
/// \cond INTERNAL
ICE_API Object* upCast(PropertiesAdmin*);
/// \endcond
typedef ::IceInternal::Handle< PropertiesAdmin> PropertiesAdminPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::Ice::PropertiesAdmin> PropertiesAdminPrx;
typedef PropertiesAdminPrx PropertiesAdminPrxPtr;
/// \cond INTERNAL
ICE_API void _icePatchObjectPtr(PropertiesAdminPtr&, const ObjectPtr&);
/// \endcond

}

namespace Ice
{

/**
 * A simple collection of properties, represented as a dictionary of
 * key/value pairs. Both key and value are strings.
 * @see Properties#getPropertiesForPrefix
 */
typedef ::std::map< ::std::string, ::std::string> PropertyDict;

}

namespace Ice
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_getProperty.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_getProperty.
 */
class Callback_PropertiesAdmin_getProperty_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_PropertiesAdmin_getProperty_Base> Callback_PropertiesAdmin_getPropertyPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_getPropertiesForPrefix.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_getPropertiesForPrefix.
 */
class Callback_PropertiesAdmin_getPropertiesForPrefix_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_PropertiesAdmin_getPropertiesForPrefix_Base> Callback_PropertiesAdmin_getPropertiesForPrefixPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_setProperties.
 */
class Callback_PropertiesAdmin_setProperties_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_PropertiesAdmin_setProperties_Base> Callback_PropertiesAdmin_setPropertiesPtr;

}

namespace IceProxy
{

namespace Ice
{

class ICE_CLASS(ICE_API) PropertiesAdmin : public virtual ::Ice::Proxy<PropertiesAdmin, ::IceProxy::Ice::Object>
{
public:

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @return The property value.
     */
    ICE_MEMBER(ICE_API) ::std::string getProperty(const ::std::string& key, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getProperty(_iceI_begin_getProperty(key, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProperty(const ::std::string& key, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getProperty(key, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProperty(const ::std::string& key, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProperty(key, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProperty(const ::std::string& key, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProperty(key, context, cb, cookie);
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProperty(const ::std::string& key, const ::Ice::Callback_PropertiesAdmin_getPropertyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProperty(key, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getProperty(const ::std::string& key, const ::Ice::Context& context, const ::Ice::Callback_PropertiesAdmin_getPropertyPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getProperty(key, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getProperty.
     * @param result The asynchronous result object for the invocation.
     * @return The property value.
     */
    ICE_MEMBER(ICE_API) ::std::string end_getProperty(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getProperty(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @return The matching property set.
     */
    ICE_MEMBER(ICE_API) ::Ice::PropertyDict getPropertiesForPrefix(const ::std::string& prefix, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_getPropertiesForPrefix(_iceI_begin_getPropertiesForPrefix(prefix, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPropertiesForPrefix(const ::std::string& prefix, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_getPropertiesForPrefix(prefix, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPropertiesForPrefix(const ::std::string& prefix, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPropertiesForPrefix(prefix, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPropertiesForPrefix(const ::std::string& prefix, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPropertiesForPrefix(prefix, context, cb, cookie);
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPropertiesForPrefix(const ::std::string& prefix, const ::Ice::Callback_PropertiesAdmin_getPropertiesForPrefixPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPropertiesForPrefix(prefix, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_getPropertiesForPrefix(const ::std::string& prefix, const ::Ice::Context& context, const ::Ice::Callback_PropertiesAdmin_getPropertiesForPrefixPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_getPropertiesForPrefix(prefix, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_getPropertiesForPrefix.
     * @param result The asynchronous result object for the invocation.
     * @return The matching property set.
     */
    ICE_MEMBER(ICE_API) ::Ice::PropertyDict end_getPropertiesForPrefix(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_getPropertiesForPrefix(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICE_API) void setProperties(const ::Ice::PropertyDict& newProperties, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setProperties(_iceI_begin_setProperties(newProperties, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProperties(const ::Ice::PropertyDict& newProperties, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setProperties(newProperties, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProperties(const ::Ice::PropertyDict& newProperties, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProperties(newProperties, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProperties(const ::Ice::PropertyDict& newProperties, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProperties(newProperties, context, cb, cookie);
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProperties(const ::Ice::PropertyDict& newProperties, const ::Ice::Callback_PropertiesAdmin_setPropertiesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProperties(newProperties, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setProperties(const ::Ice::PropertyDict& newProperties, const ::Ice::Context& context, const ::Ice::Callback_PropertiesAdmin_setPropertiesPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setProperties(newProperties, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setProperties.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICE_API) void end_setProperties(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICE_API) ::Ice::AsyncResultPtr _iceI_begin_setProperties(const ::Ice::PropertyDict&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICE_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICE_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace Ice
{

/**
 * The PropertiesAdmin interface provides remote access to the properties
 * of a communicator.
 * \headerfile Ice/Ice.h
 */
class ICE_API PropertiesAdmin : public virtual Object
{
public:

    typedef PropertiesAdminPrx ProxyType;
    typedef PropertiesAdminPtr PointerType;

    virtual ~PropertiesAdmin();

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const Current& current = emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const Current& current = emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const Current& current = emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Get a property by key. If the property is not set, an empty
     * string is returned.
     * @param key The property key.
     * @param current The Current object for the invocation.
     * @return The property value.
     */
    virtual ::std::string getProperty(const ::std::string& key, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getProperty(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Get all properties whose keys begin with <em>prefix</em>. If
     * <em>prefix</em> is an empty string then all properties are returned.
     * @param prefix The prefix to search for (empty string if none).
     * @param current The Current object for the invocation.
     * @return The matching property set.
     */
    virtual PropertyDict getPropertiesForPrefix(const ::std::string& prefix, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_getPropertiesForPrefix(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Update the communicator's properties with the given property set.
     * @param newProperties Properties to be added, changed, or removed.
     * If an entry in <em>newProperties</em> matches the name of an existing property,
     * that property's value is replaced with the new value. If the new value
     * is an empty string, the property is removed. Any existing properties
     * that are not modified or removed by the entries in newProperties are
     * retained with their original values.
     * @param current The Current object for the invocation.
     */
    virtual void setProperties(const PropertyDict& newProperties, const Current& current = emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setProperties(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(OutputStream*) const;
    virtual void _iceReadImpl(InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const PropertiesAdmin& lhs, const PropertiesAdmin& rhs)
{
    return static_cast<const Object&>(lhs) == static_cast<const Object&>(rhs);
}

inline bool operator<(const PropertiesAdmin& lhs, const PropertiesAdmin& rhs)
{
    return static_cast<const Object&>(lhs) < static_cast<const Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

namespace Ice
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_getProperty.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_getProperty.
 */
template<class T>
class CallbackNC_PropertiesAdmin_getProperty : public Callback_PropertiesAdmin_getProperty_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::std::string&);

    CallbackNC_PropertiesAdmin_getProperty(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        PropertiesAdminPrx proxy = PropertiesAdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getProperty(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getProperty.
 */
template<class T> Callback_PropertiesAdmin_getPropertyPtr
newCallback_PropertiesAdmin_getProperty(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_getProperty<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getProperty.
 */
template<class T> Callback_PropertiesAdmin_getPropertyPtr
newCallback_PropertiesAdmin_getProperty(T* instance, void (T::*cb)(const ::std::string&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_getProperty<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_getProperty.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_getProperty.
 */
template<class T, typename CT>
class Callback_PropertiesAdmin_getProperty : public Callback_PropertiesAdmin_getProperty_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::std::string&, const CT&);

    Callback_PropertiesAdmin_getProperty(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        PropertiesAdminPrx proxy = PropertiesAdminPrx::uncheckedCast(result->getProxy());
        ::std::string ret;
        try
        {
            ret = proxy->end_getProperty(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getProperty.
 */
template<class T, typename CT> Callback_PropertiesAdmin_getPropertyPtr
newCallback_PropertiesAdmin_getProperty(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_getProperty<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getProperty.
 */
template<class T, typename CT> Callback_PropertiesAdmin_getPropertyPtr
newCallback_PropertiesAdmin_getProperty(T* instance, void (T::*cb)(const ::std::string&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_getProperty<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_getPropertiesForPrefix.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_getPropertiesForPrefix.
 */
template<class T>
class CallbackNC_PropertiesAdmin_getPropertiesForPrefix : public Callback_PropertiesAdmin_getPropertiesForPrefix_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const PropertyDict&);

    CallbackNC_PropertiesAdmin_getPropertiesForPrefix(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        PropertiesAdminPrx proxy = PropertiesAdminPrx::uncheckedCast(result->getProxy());
        PropertyDict ret;
        try
        {
            ret = proxy->end_getPropertiesForPrefix(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getPropertiesForPrefix.
 */
template<class T> Callback_PropertiesAdmin_getPropertiesForPrefixPtr
newCallback_PropertiesAdmin_getPropertiesForPrefix(const IceUtil::Handle<T>& instance, void (T::*cb)(const PropertyDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_getPropertiesForPrefix<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getPropertiesForPrefix.
 */
template<class T> Callback_PropertiesAdmin_getPropertiesForPrefixPtr
newCallback_PropertiesAdmin_getPropertiesForPrefix(T* instance, void (T::*cb)(const PropertyDict&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_getPropertiesForPrefix<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_getPropertiesForPrefix.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_getPropertiesForPrefix.
 */
template<class T, typename CT>
class Callback_PropertiesAdmin_getPropertiesForPrefix : public Callback_PropertiesAdmin_getPropertiesForPrefix_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const PropertyDict&, const CT&);

    Callback_PropertiesAdmin_getPropertiesForPrefix(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const AsyncResultPtr& result) const
    {
        PropertiesAdminPrx proxy = PropertiesAdminPrx::uncheckedCast(result->getProxy());
        PropertyDict ret;
        try
        {
            ret = proxy->end_getPropertiesForPrefix(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getPropertiesForPrefix.
 */
template<class T, typename CT> Callback_PropertiesAdmin_getPropertiesForPrefixPtr
newCallback_PropertiesAdmin_getPropertiesForPrefix(const IceUtil::Handle<T>& instance, void (T::*cb)(const PropertyDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_getPropertiesForPrefix<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_getPropertiesForPrefix.
 */
template<class T, typename CT> Callback_PropertiesAdmin_getPropertiesForPrefixPtr
newCallback_PropertiesAdmin_getPropertiesForPrefix(T* instance, void (T::*cb)(const PropertyDict&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_getPropertiesForPrefix<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_setProperties.
 */
template<class T>
class CallbackNC_PropertiesAdmin_setProperties : public Callback_PropertiesAdmin_setProperties_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_PropertiesAdmin_setProperties(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_setProperties<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_setProperties<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_setProperties<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_PropertiesAdmin_setProperties<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 * Create a wrapper instance by calling ::Ice::newCallback_PropertiesAdmin_setProperties.
 */
template<class T, typename CT>
class Callback_PropertiesAdmin_setProperties : public Callback_PropertiesAdmin_setProperties_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_PropertiesAdmin_setProperties(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T, typename CT> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_setProperties<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T, typename CT> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_setProperties<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T, typename CT> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_setProperties<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::Ice::PropertiesAdmin::begin_setProperties.
 */
template<class T, typename CT> Callback_PropertiesAdmin_setPropertiesPtr
newCallback_PropertiesAdmin_setProperties(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_PropertiesAdmin_setProperties<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
