#ifndef _EFL_UI_SCROLLABLE_EO_H_
#define _EFL_UI_SCROLLABLE_EO_H_

#ifndef _EFL_UI_SCROLLABLE_EO_CLASS_TYPE
#define _EFL_UI_SCROLLABLE_EO_CLASS_TYPE

typedef Eo Efl_Ui_Scrollable;

#endif

#ifndef _EFL_UI_SCROLLABLE_EO_TYPES
#define _EFL_UI_SCROLLABLE_EO_TYPES

/**
 * @brief Direction in which a scroller should be blocked.
 *
 * @note These options may be effective only in case of thumbscroll (i.e. when
 * scrolling by dragging).
 *
 * @since 1.21
 *
 * @ingroup Efl_Ui
 */
typedef enum
{
  EFL_UI_SCROLL_BLOCK_NONE = 0, /**< Don't block any movement. */
  EFL_UI_SCROLL_BLOCK_VERTICAL = 1, /**< Block vertical movement. */
  EFL_UI_SCROLL_BLOCK_HORIZONTAL = 2 /**< Block horizontal movement. */
} Efl_Ui_Scroll_Block;


#endif
/** Efl UI scrollable interface
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_SCROLLABLE_INTERFACE efl_ui_scrollable_interface_get()

EWAPI const Efl_Class *efl_ui_scrollable_interface_get(void);

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_START;

/** Called when scroll operation starts
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_START (&(_EFL_UI_EVENT_SCROLL_START))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL;

/** Called when scrolling
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL (&(_EFL_UI_EVENT_SCROLL))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_STOP;

/** Called when scroll operation stops
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_STOP (&(_EFL_UI_EVENT_SCROLL_STOP))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_UP;

/** Called when scrolling upwards
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_UP (&(_EFL_UI_EVENT_SCROLL_UP))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_DOWN;

/** Called when scrolling downwards
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_DOWN (&(_EFL_UI_EVENT_SCROLL_DOWN))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_LEFT;

/** Called when scrolling left
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_LEFT (&(_EFL_UI_EVENT_SCROLL_LEFT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_RIGHT;

/** Called when scrolling right
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_RIGHT (&(_EFL_UI_EVENT_SCROLL_RIGHT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_UP;

/** Called when hitting the top edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_UP (&(_EFL_UI_EVENT_EDGE_UP))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_DOWN;

/** Called when hitting the bottom edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_DOWN (&(_EFL_UI_EVENT_EDGE_DOWN))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_LEFT;

/** Called when hitting the left edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_LEFT (&(_EFL_UI_EVENT_EDGE_LEFT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_EDGE_RIGHT;

/** Called when hitting the right edge
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_EDGE_RIGHT (&(_EFL_UI_EVENT_EDGE_RIGHT))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_ANIM_START;

/** Called when scroll animation starts
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_ANIM_START (&(_EFL_UI_EVENT_SCROLL_ANIM_START))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_ANIM_STOP;

/** Called when scroll animation stopps
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_ANIM_STOP (&(_EFL_UI_EVENT_SCROLL_ANIM_STOP))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_DRAG_START;

/** Called when scroll drag starts
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_DRAG_START (&(_EFL_UI_EVENT_SCROLL_DRAG_START))

EWAPI extern const Efl_Event_Description _EFL_UI_EVENT_SCROLL_DRAG_STOP;

/** Called when scroll drag stops
 *
 * @ingroup Efl_Ui_Scrollable
 */
#define EFL_UI_EVENT_SCROLL_DRAG_STOP (&(_EFL_UI_EVENT_SCROLL_DRAG_STOP))

#endif
