/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import java.text.Collator;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AutoCompleteTextField
extends JTextField {
    private List<String> autoCompletionStrings;
    private boolean directChange;

    public AutoCompleteTextField(String string, int n, List<String> list) {
        super(n);
        this.autoCompletionStrings = list;
        this.setDocument(new AutoCompleteDocument(string));
        this.directChange = true;
    }

    @Override
    public void setText(String string) {
        this.directChange = false;
        super.setText(string);
        this.directChange = true;
    }

    private class AutoCompleteDocument
    extends PlainDocument {
        public AutoCompleteDocument(String string) {
            try {
                this.replace(0, 0, string, null);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException(badLocationException);
            }
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            String string2;
            String string3;
            int n2;
            if (AutoCompleteTextField.this.directChange && string != null && string.length() > 0 && (n == (n2 = this.getLength()) || n == AutoCompleteTextField.this.getSelectionStart() && n2 - 1 == AutoCompleteTextField.this.getSelectionEnd()) && (string3 = this.autoComplete((string2 = this.getText(0, n)) + string)) != null) {
                int n3 = n + string.length();
                super.remove(n, n2 - n);
                super.insertString(n, string, attributeSet);
                super.insertString(n3, string3.substring(n3), attributeSet);
                AutoCompleteTextField.this.select(n3, this.getLength());
                return;
            }
            super.insertString(n, string, attributeSet);
        }

        private String autoComplete(String string) {
            string = string.toLowerCase();
            final Collator collator = Collator.getInstance();
            collator.setStrength(2);
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    return collator.compare(string, string2);
                }
            });
            for (String string2 : AutoCompleteTextField.this.autoCompletionStrings) {
                if (!string2.toLowerCase().startsWith(string)) continue;
                treeSet.add(string2);
            }
            if (treeSet.size() > 0) {
                return treeSet.first();
            }
            return null;
        }
    }
}

