/*
 * Decompiled with CFR 0.152.
 */
package org.directwebremoting.extend;

import java.util.Collection;
import org.directwebremoting.extend.NonNestedOutboundVariable;
import org.directwebremoting.extend.OutboundContext;
import org.directwebremoting.extend.OutboundVariable;

public abstract class NestedOutboundVariable
implements OutboundVariable {
    private boolean referenced = false;
    private Collection<OutboundVariable> children;
    private OutboundVariable reference;
    private String varName;
    private final OutboundContext context;

    protected NestedOutboundVariable(OutboundContext context) {
        this.context = context;
    }

    public void setChildren(Collection<OutboundVariable> children) {
        this.children = children;
    }

    public Collection<OutboundVariable> getChildren() {
        return this.children;
    }

    protected String getChildDeclareCodes() {
        StringBuilder builder = new StringBuilder();
        for (OutboundVariable child : this.children) {
            builder.append(child.getDeclareCode());
        }
        return builder.toString();
    }

    protected String getChildBuildCodes() {
        StringBuilder builder = new StringBuilder();
        for (OutboundVariable child : this.children) {
            builder.append(child.getBuildCode());
        }
        return builder.toString();
    }

    @Override
    public OutboundVariable getReferenceVariable() {
        if (this.reference == null) {
            this.reference = new NonNestedOutboundVariable(this.getVariableName());
        }
        this.referenced = true;
        return this.reference;
    }

    protected String getVariableName() {
        if (this.varName == null) {
            this.varName = this.context.getNextVariableName();
        }
        return this.varName;
    }

    protected boolean isInline() {
        return this.context.isJsonMode() || !this.referenced;
    }

    public boolean isJsonMode() {
        return this.context.isJsonMode();
    }
}

