/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BinaryOperator;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.ReportPanel;
import net.sf.freecol.client.gui.panel.Utility;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.BuildableType;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.ExportData;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.Market;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Region;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovementType;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.CollectionUtils;

public final class ReportCompactColonyPanel
extends ReportPanel
implements ActionListener {
    private static final String BUILDQUEUE = "buildQueue.";
    private static final String cAlarmKey = "color.report.colony.alarm";
    private static final String cWarnKey = "color.report.colony.warning";
    private static final String cPlainKey = "color.report.colony.plain";
    private static final String cExportKey = "color.report.colony.export";
    private static final String cGoodKey = "color.report.colony.good";
    private static Color cAlarm = null;
    private static Color cWarn;
    private static Color cPlain;
    private static Color cExport;
    private static Color cGood;
    private final Specification spec;
    private final ImageLibrary lib;
    private final List<List<Colony>> colonies = new ArrayList<List<Colony>>();
    private final Market market;
    private final List<GoodsType> goodsTypes = new ArrayList<GoodsType>();

    public ReportCompactColonyPanel(FreeColClient freeColClient) {
        super(freeColClient, "reportColonyAction");
        Player player = this.getMyPlayer();
        final Comparator<Colony> colonyComparator = freeColClient.getClientOptions().getColonyComparator();
        Comparator<List<Colony>> firstColonyComparator = new Comparator<List<Colony>>(){

            @Override
            public int compare(List<Colony> l1, List<Colony> l2) {
                return colonyComparator.compare(l1.get(0), l2.get(0));
            }
        };
        this.spec = this.getSpecification();
        this.lib = this.getImageLibrary();
        HashMap continents = new HashMap();
        for (Colony colony : freeColClient.getMySortedColonies()) {
            if (colony.getUnitCount() <= 0) continue;
            CollectionUtils.appendToMapList(continents, colony.getTile().getContiguity(), colony);
        }
        for (Map.Entry entry : CollectionUtils.mapEntriesByValue(continents, firstColonyComparator)) {
            this.colonies.add((List<Colony>)entry.getValue());
        }
        this.market = player.getMarket();
        this.goodsTypes.addAll(this.spec.getGoodsTypeList());
        Iterator<GoodsType> gti = this.goodsTypes.iterator();
        while (gti.hasNext()) {
            GoodsType goodsType = gti.next();
            if (goodsType.isStorable() && !goodsType.isTradeGoods()) continue;
            gti.remove();
        }
        Collections.sort(this.goodsTypes, GoodsType.goodsTypeComparator);
        this.loadResources();
        this.update();
    }

    private synchronized void loadResources() {
        if (cAlarm != null) {
            return;
        }
        cAlarm = ResourceManager.hasColorResource(cAlarmKey) ? ResourceManager.getColor(cAlarmKey) : Color.RED;
        cWarn = ResourceManager.hasColorResource(cWarnKey) ? ResourceManager.getColor(cWarnKey) : Color.MAGENTA;
        cPlain = ResourceManager.hasColorResource(cPlainKey) ? ResourceManager.getColor(cPlainKey) : Color.DARK_GRAY;
        cExport = ResourceManager.hasColorResource(cExportKey) ? ResourceManager.getColor(cExportKey) : Color.GREEN;
        cGood = ResourceManager.hasColorResource(cGoodKey) ? ResourceManager.getColor(cGoodKey) : Color.BLUE;
    }

    private static StringTemplate stpl(String messageId) {
        return Messages.containsKey(messageId) ? StringTemplate.template(messageId) : null;
    }

    private static StringTemplate stpld(String messageId) {
        messageId = Messages.descriptionKey(messageId);
        return ReportCompactColonyPanel.stpl(messageId);
    }

    private JLabel newLabel(String h, ImageIcon i, Color c) {
        JLabel l = new JLabel(h, i, 0);
        l.setForeground(c == null ? Color.BLACK : c);
        return l;
    }

    private JLabel newLabel(String h, ImageIcon i, Color c, StringTemplate t) {
        if (h != null && Messages.containsKey(h)) {
            h = Messages.message(h);
        }
        JLabel l = this.newLabel(h, i, c);
        if (t != null) {
            Utility.localizeToolTip((JComponent)l, t);
        }
        return l;
    }

    private JButton newButton(String action, String h, ImageIcon i, Color c, StringTemplate t) {
        if (h != null && Messages.containsKey(h)) {
            h = Messages.message(h);
        }
        JButton b = Utility.getLinkButton(h, i, action);
        b.setForeground(c == null ? Color.BLACK : c);
        if (t != null) {
            Utility.localizeToolTip((JComponent)b, t);
        }
        b.addActionListener(this);
        return b;
    }

    private void addTogether(List<? extends JComponent> components) {
        if (components.isEmpty()) {
            this.reportPanel.add(new JLabel());
            return;
        }
        String layout = components.size() > 1 ? "split " + components.size() : null;
        for (JComponent jComponent : components) {
            this.reportPanel.add((Component)jComponent, layout);
            layout = null;
        }
    }

    private void updateColony(ColonySummary s) {
        StringTemplate t;
        String cac = s.colony.getId();
        UnitType defaultUnitType = this.spec.getDefaultUnitType(s.colony.getOwner());
        ArrayList<JComponent> buttons = new ArrayList<JComponent>();
        Color c = s.bonus <= -2 ? cAlarm : (s.bonus == -1 ? cWarn : (s.bonus == 0 ? cPlain : (s.bonus == 1 ? cExport : cGood)));
        JButton b = this.newButton(cac, s.colony.getName(), null, c, null);
        if (s.famine) {
            b.setFont(b.getFont().deriveFont(1));
        }
        this.reportPanel.add((Component)b, "newline");
        if (s.sizeChange < 0) {
            c = cAlarm;
            t = ReportCompactColonyPanel.stpld("report.colony.shrinking").addName("%colony%", s.colony.getName()).addAmount("%amount%", -s.sizeChange);
            b = this.newButton(cac, Integer.toString(-s.sizeChange), null, c, t);
        } else if (s.sizeChange > 0) {
            c = cGood;
            t = ReportCompactColonyPanel.stpld("report.colony.growing").addName("%colony%", s.colony.getName()).addAmount("%amount%", s.sizeChange);
            b = this.newButton(cac, Integer.toString(s.sizeChange), null, c, t);
        } else {
            b = null;
        }
        this.reportPanel.add(b == null ? new JLabel() : b);
        int n = 0;
        for (Colony.TileImprovementSuggestion tis : s.tileSuggestions) {
            if (!tis.isExploration()) continue;
            ++n;
        }
        if (n > 0) {
            t = ReportCompactColonyPanel.stpld("report.colony.exploring").addName("%colony%", s.colony.getName()).addAmount("%amount%", n);
            b = this.newButton(cac, Integer.toString(n), null, cAlarm, t);
        } else {
            b = null;
        }
        this.reportPanel.add(b == null ? new JLabel() : b);
        for (TileImprovementType ti : this.spec.getTileImprovementTypeList()) {
            if (ti.isNatural()) continue;
            n = 0;
            boolean center = false;
            for (Colony.TileImprovementSuggestion tileImprovementSuggestion : s.tileSuggestions) {
                if (tileImprovementSuggestion.tileImprovementType != ti) continue;
                ++n;
                if (tileImprovementSuggestion.tile != s.colony.getTile()) continue;
                center = true;
            }
            if (n > 0) {
                c = cAlarm;
                if (n == 1) {
                    Colony.TileImprovementSuggestion tis = s.tileSuggestions.get(0);
                    for (Unit u : tis.tile.getUnitList()) {
                        if (u.getState() != Unit.UnitState.IMPROVING || u.getWorkImprovement() == null || u.getWorkImprovement().getType() != tis.tileImprovementType) continue;
                        c = cWarn;
                        break;
                    }
                    t = ReportCompactColonyPanel.stpld("report.colony.tile." + ti.getSuffix() + ".specific").addName("%colony%", s.colony.getName()).addStringTemplate("%location%", tis.tile.getColonyTileLocationLabel(s.colony));
                } else {
                    t = ReportCompactColonyPanel.stpld("report.colony.tile." + ti.getSuffix()).addName("%colony%", s.colony.getName()).addAmount("%amount%", n);
                }
                b = this.newButton(cac, Integer.toString(n), null, c, t);
                if (center) {
                    b.setFont(b.getFont().deriveFont(1));
                }
            } else {
                b = null;
            }
            this.reportPanel.add(b == null ? new JLabel() : b);
        }
        for (GoodsType gt : this.goodsTypes) {
            ColonySummary.GoodsProduction gp = s.production.get(gt);
            switch (gp.status) {
                case FAIL: {
                    c = cAlarm;
                    t = ReportCompactColonyPanel.stpld("report.colony.production.low").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", -gp.amount).addAmount("%turns%", gp.extra);
                    break;
                }
                case BAD: {
                    c = cWarn;
                    t = ReportCompactColonyPanel.stpld("report.colony.production").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount);
                    break;
                }
                case NONE: {
                    c = null;
                    t = null;
                    break;
                }
                case ZERO: {
                    c = cPlain;
                    t = ReportCompactColonyPanel.stpld("report.colony.production").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount);
                    break;
                }
                case GOOD: {
                    c = cGood;
                    t = ReportCompactColonyPanel.stpld("report.colony.production").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount);
                    break;
                }
                case EXPORT: {
                    c = cExport;
                    t = ReportCompactColonyPanel.stpld("report.colony.production.export").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount).addAmount("%export%", gp.extra);
                    break;
                }
                case EXCESS: {
                    c = cWarn;
                    t = ReportCompactColonyPanel.stpld("report.colony.production.high").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount).addAmount("%turns%", gp.extra);
                    break;
                }
                case OVERFLOW: {
                    c = cAlarm;
                    t = ReportCompactColonyPanel.stpld("report.colony.production.waste").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount).addAmount("%waste%", gp.extra);
                    break;
                }
                case PRODUCTION: {
                    c = cWarn;
                    t = ReportCompactColonyPanel.stpld("report.colony.production.maxProduction").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount).addAmount("%more%", gp.extra);
                    break;
                }
                case CONSUMPTION: {
                    c = cWarn;
                    t = ReportCompactColonyPanel.stpld("report.colony.production.maxConsumption").addName("%colony%", s.colony.getName()).addNamed("%goods%", gt).addAmount("%amount%", gp.amount).addAmount("%more%", gp.extra);
                    break;
                }
                default: {
                    throw new IllegalStateException("Bogus status: " + (Object)((Object)gp.status));
                }
            }
            this.reportPanel.add(c == null ? new JLabel() : this.newButton(cac, Integer.toString(gp.amount), null, c, t));
        }
        if (s.newColonist > 0) {
            t = ReportCompactColonyPanel.stpld("report.colony.arriving").addName("%colony%", s.colony.getName()).addNamed("%unit%", defaultUnitType).addAmount("%turns%", s.newColonist);
            b = this.newButton(cac, Integer.toString(s.newColonist), null, cGood, t);
        } else if (s.newColonist < 0) {
            c = s.famine ? cAlarm : cWarn;
            t = ReportCompactColonyPanel.stpld("report.colony.starving").addName("%colony%", s.colony.getName()).addAmount("%turns%", -s.newColonist);
            b = this.newButton(cac, Integer.toString(-s.newColonist), null, c, t);
            if (s.famine) {
                b.setFont(b.getFont().deriveFont(1));
            }
        } else {
            b = null;
        }
        this.reportPanel.add(b == null ? new JLabel() : b);
        String qac = BUILDQUEUE + cac;
        if (s.build != null) {
            int turns = s.completeTurns;
            String name = Messages.getName(s.build);
            if (turns == Integer.MIN_VALUE) {
                t = ReportCompactColonyPanel.stpld("report.colony.making.noconstruction").addName("%colony%", s.colony.getName());
                b = this.newButton(qac, name, null, cWarn, t);
            } else if (turns >= 0) {
                t = ReportCompactColonyPanel.stpld("report.colony.making.constructing").addName("%colony%", s.colony.getName()).addNamed("%buildable%", s.build).addAmount("%turns%", turns);
                b = this.newButton(qac, name + " " + Integer.toString(turns), null, cGood, t);
            } else if (turns < 0) {
                turns = -(turns + 1);
                t = ReportCompactColonyPanel.stpld("report.colony.making.blocking").addName("%colony%", s.colony.getName()).addAmount("%amount%", s.needed.getAmount()).addNamed("%goods%", s.needed.getType()).addNamed("%buildable%", s.build).addAmount("%turns%", turns);
                b = this.newButton(qac, name + " " + Integer.toString(turns), null, cAlarm, t);
                if (turns == 0) {
                    b.setFont(b.getFont().deriveFont(1));
                }
            }
            buttons.add(b);
        }
        int empty = 0;
        Building school = s.colony.getWorkLocationWithAbility("model.ability.teach", Building.class);
        if (school != null) {
            empty = school.getType().getWorkPlaces();
        }
        for (Map.Entry entry : CollectionUtils.mapEntriesByValue(s.teachers, CollectionUtils.descendingIntegerComparator)) {
            Unit u;
            u = (Unit)entry.getKey();
            ImageIcon ii = new ImageIcon(this.lib.getTinyUnitImage(u.getType(), false));
            if ((Integer)entry.getValue() <= 0) {
                t = ReportCompactColonyPanel.stpld("report.colony.making.noteach").addName("%colony%", s.colony.getName()).addStringTemplate("%teacher%", u.getLabel(Unit.UnitLabelType.NATIONAL));
                b = this.newButton(cac, Integer.toString(0), ii, cAlarm, t);
            } else {
                t = ReportCompactColonyPanel.stpld("report.colony.making.educating").addName("%colony%", s.colony.getName()).addStringTemplate("%teacher%", u.getLabel(Unit.UnitLabelType.NATIONAL)).addAmount("%turns%", (Number)entry.getValue());
                b = this.newButton(cac, Integer.toString((Integer)entry.getValue()), ii, cPlain, t);
            }
            buttons.add(b);
            --empty;
        }
        if (empty > 0) {
            ImageIcon emptyIcon = new ImageIcon(this.lib.getTinyUnitImage(defaultUnitType, true));
            t = ReportCompactColonyPanel.stpld("report.colony.making.educationVacancy").addName("%colony%", s.colony.getName()).addAmount("%number%", empty);
            while (empty > 0) {
                buttons.add(this.newButton(cac, "", emptyIcon, cPlain, t));
                --empty;
            }
        }
        this.addTogether(buttons);
        if (s.improve.isEmpty() && s.want.isEmpty()) {
            this.reportPanel.add(new JLabel());
        } else {
            buttons.clear();
            buttons.addAll(this.unitButtons(s.improve, s.couldWork, s.colony));
            buttons.add(new JLabel("/"));
            for (UnitType unitType : s.improve.keySet()) {
                s.want.remove(unitType);
            }
            buttons.addAll(this.unitButtons(s.want, s.couldWork, s.colony));
            this.addTogether(buttons);
        }
    }

    private List<JButton> unitButtons(final Map<UnitType, WorkLocation.Suggestion> suggestions, List<UnitType> have, Colony colony) {
        String cac = colony.getId();
        ArrayList<JButton> result = new ArrayList<JButton>();
        ArrayList<UnitType> types = new ArrayList<UnitType>();
        types.addAll(suggestions.keySet());
        Collections.sort(types, new Comparator<UnitType>(){

            @Override
            public int compare(UnitType t1, UnitType t2) {
                WorkLocation.Suggestion s1 = (WorkLocation.Suggestion)suggestions.get(t1);
                WorkLocation.Suggestion s2 = (WorkLocation.Suggestion)suggestions.get(t2);
                return WorkLocation.Suggestion.descendingAmountComparator.compare(s1, s2);
            }
        });
        for (UnitType type : types) {
            boolean present = have.contains(type);
            WorkLocation.Suggestion suggestion = suggestions.get(type);
            String label = Integer.toString(suggestion.amount);
            ImageIcon icon = new ImageIcon(this.lib.getTinyUnitImage(type, false));
            StringTemplate tip = suggestion.oldType == null ? ReportCompactColonyPanel.stpld("report.colony.wanting").addName("%colony%", colony.getName()).addNamed("%unit%", type).addStringTemplate("%location%", suggestion.workLocation.getLabel()).addNamed("%goods%", suggestion.goodsType).addAmount("%amount%", suggestion.amount) : ReportCompactColonyPanel.stpld("report.colony.improving").addName("%colony%", colony.getName()).addNamed("%oldUnit%", suggestion.oldType).addNamed("%unit%", type).addStringTemplate("%location%", suggestion.workLocation.getLabel()).addNamed("%goods%", suggestion.goodsType).addAmount("%amount%", suggestion.amount);
            JButton b = this.newButton(cac, label, icon, present ? cGood : cPlain, tip);
            if (present) {
                b.setFont(b.getFont().deriveFont(1));
            }
            result.add(b);
        }
        return result;
    }

    private void updateCombinedColonies(List<ColonySummary> summaries) {
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
        HashMap rRegionMap = new HashMap();
        ArrayList<Colony.TileImprovementSuggestion> rTileSuggestions = new ArrayList<Colony.TileImprovementSuggestion>();
        int rFamine = 0;
        int rBonus = 0;
        int rSizeChange = 0;
        int teacherLen = 0;
        int improveLen = 0;
        double rNewColonist = 0.0;
        HashMap rProduction = new HashMap();
        HashMap<UnitType, Integer> rTeachers = new HashMap<UnitType, Integer>();
        ArrayList<Unit> rNotWorking = new ArrayList<Unit>();
        ArrayList<UnitType> rCouldWork = new ArrayList<UnitType>();
        HashMap<UnitType, Integer> rImprove = new HashMap<UnitType, Integer>();
        HashMap rNeeded = new HashMap();
        for (ColonySummary colonySummary : summaries) {
            CollectionUtils.accumulateToMap(rRegionMap, colonySummary.colony.getTile().getRegion(), 1, CollectionUtils.integerAccumulator);
            rTileSuggestions.addAll(colonySummary.tileSuggestions);
            if (colonySummary.famine) {
                ++rFamine;
            }
            if (colonySummary.newColonist > 0) {
                rNewColonist += (double)colonySummary.newColonist;
            }
            rBonus += colonySummary.bonus;
            rSizeChange += colonySummary.sizeChange;
            CollectionUtils.accumulateMap(rProduction, colonySummary.production, ColonySummary.goodsProductionAccumulator);
            teacherLen = Math.max(teacherLen, colonySummary.teachers.size());
            for (Unit unit : colonySummary.teachers.keySet()) {
                CollectionUtils.accumulateToMap(rTeachers, unit.getType(), 1, CollectionUtils.integerAccumulator);
            }
            rNotWorking.addAll(colonySummary.notWorking);
            rCouldWork.addAll(colonySummary.couldWork);
            improveLen = Math.max(improveLen, colonySummary.improve.size() + colonySummary.want.size());
            for (UnitType unitType : colonySummary.improve.keySet()) {
                CollectionUtils.accumulateToMap(rImprove, unitType, 1, CollectionUtils.integerAccumulator);
            }
            for (UnitType unitType : colonySummary.want.keySet()) {
                CollectionUtils.accumulateToMap(rImprove, unitType, 1, CollectionUtils.integerAccumulator);
            }
            if (colonySummary.needed == null || !colonySummary.needed.getType().isStorable()) continue;
            CollectionUtils.accumulateToMap(rNeeded, colonySummary.needed.getType(), (double)colonySummary.needed.getAmount() / (double)colonySummary.completeTurns, CollectionUtils.doubleAccumulator);
        }
        rNewColonist = Math.round(rNewColonist / (double)summaries.size());
        StringTemplate t = ((Region)CollectionUtils.mapEntriesByValue(rRegionMap, CollectionUtils.descendingIntegerComparator).get(0).getKey()).getLabel();
        this.reportPanel.add((Component)this.newLabel(Messages.message(t), null, cPlain, ReportCompactColonyPanel.stpld("report.colony.name.summary")), "newline");
        this.reportPanel.add(this.newLabel(Integer.toString(rSizeChange), null, rSizeChange < 0 ? cAlarm : cGood, ReportCompactColonyPanel.stpld("report.colony.growing.summary")));
        ArrayList<Tile> tiles = new ArrayList<Tile>();
        for (Colony.TileImprovementSuggestion tis : rTileSuggestions) {
            if (!tis.isExploration() || tiles.contains(tis.tile)) continue;
            tiles.add(tis.tile);
        }
        this.reportPanel.add(tiles.isEmpty() ? new JLabel() : this.newLabel(Integer.toString(tiles.size()), null, cAlarm, ReportCompactColonyPanel.stpld("report.colony.exploring.summary")));
        for (TileImprovementType ti : this.spec.getTileImprovementTypeList()) {
            if (ti.isNatural()) continue;
            tiles.clear();
            for (Colony.TileImprovementSuggestion tis : rTileSuggestions) {
                if (tis.tileImprovementType != ti || tiles.contains(tis.tile)) continue;
                tiles.add(tis.tile);
            }
            this.reportPanel.add(tiles.isEmpty() ? new JLabel() : this.newLabel(Integer.toString(tiles.size()), null, cAlarm, ReportCompactColonyPanel.stpld("report.colony.tile." + ti.getSuffix() + ".summary")));
        }
        for (GoodsType gt : this.goodsTypes) {
            Color c;
            ColonySummary.GoodsProduction goodsProduction = (ColonySummary.GoodsProduction)rProduction.get(gt);
            switch (goodsProduction.status) {
                case BAD: {
                    c = cWarn;
                    break;
                }
                case NONE: {
                    c = null;
                    break;
                }
                case ZERO: {
                    c = cPlain;
                    break;
                }
                case GOOD: {
                    c = cGood;
                    break;
                }
                default: {
                    throw new IllegalStateException("Bogus status: " + (Object)((Object)goodsProduction.status));
                }
            }
            this.reportPanel.add(c == null ? new JLabel() : this.newLabel(Integer.toString(goodsProduction.amount), null, c, ReportCompactColonyPanel.stpld("report.colony.production.summary").addNamed("%goods%", gt)));
        }
        this.reportPanel.add(this.newLabel(Integer.toString((int)rNewColonist), null, rNewColonist < 0.0 ? cWarn : cGood, ReportCompactColonyPanel.stpld("report.colony.arriving.summary")));
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>();
        for (Map.Entry entry : CollectionUtils.mapEntriesByValue(rNeeded, CollectionUtils.descendingDoubleComparator)) {
            arrayList.add(this.newLabel(String.format("%4.1f %s", entry.getValue(), Messages.getName((Named)entry.getKey())), null, cPlain, ReportCompactColonyPanel.stpld("report.colony.making.summary").addNamed("%goods%", (Named)entry.getKey())));
        }
        teacherLen = Math.max(3, teacherLen);
        arrayList.addAll(this.unitTypeLabels(rTeachers, teacherLen, ReportCompactColonyPanel.stpld("report.colony.making.educating.summary")));
        this.addTogether(arrayList);
        this.addTogether(this.unitTypeLabels(rImprove, improveLen, ReportCompactColonyPanel.stpld("report.colony.improving.summary")));
    }

    private List<JLabel> unitTypeLabels(Map<UnitType, Integer> unitTypeMap, int maxSize, StringTemplate t) {
        ArrayList<JLabel> result = new ArrayList<JLabel>();
        int n = 0;
        for (Map.Entry<UnitType, Integer> e : CollectionUtils.mapEntriesByValue(unitTypeMap, CollectionUtils.descendingIntegerComparator)) {
            ImageIcon icon = new ImageIcon(this.lib.getTinyUnitImage(e.getKey(), false));
            result.add(this.newLabel(Integer.toString(e.getValue()), icon, cPlain, t));
            if (++n < maxSize) continue;
            break;
        }
        return result;
    }

    private void conciseHeaders(Market market) {
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
        this.reportPanel.add((Component)this.newLabel("report.colony.name.header", null, null, ReportCompactColonyPanel.stpld("report.colony.name")), "newline");
        this.reportPanel.add(this.newLabel("report.colony.grow.header", null, null, ReportCompactColonyPanel.stpld("report.colony.grow")));
        this.reportPanel.add(this.newLabel("report.colony.explore.header", null, null, ReportCompactColonyPanel.stpld("report.colony.explore")));
        for (TileImprovementType ti : this.spec.getTileImprovementTypeList()) {
            if (ti.isNatural()) continue;
            String key = "report.colony.tile." + ti.getSuffix() + ".header";
            this.reportPanel.add(this.newLabel(key, null, null, ReportCompactColonyPanel.stpld(key)));
        }
        for (GoodsType gt : this.goodsTypes) {
            ImageIcon icon = new ImageIcon(this.lib.getSmallIconImage(gt));
            JLabel l = this.newLabel(null, icon, null, ReportCompactColonyPanel.stpl("report.colony.production.header").addNamed("%goods%", gt));
            l.setEnabled(market == null || market.getArrears(gt) <= 0);
            this.reportPanel.add(l);
        }
        UnitType type = this.spec.getDefaultUnitType(market.getOwner());
        ImageIcon colonistIcon = new ImageIcon(this.lib.getTinyUnitImage(type, false));
        this.reportPanel.add(this.newLabel(null, colonistIcon, null, ReportCompactColonyPanel.stpld("report.colony.birth")));
        this.reportPanel.add(this.newLabel("report.colony.making.header", null, null, ReportCompactColonyPanel.stpld("report.colony.making")));
        this.reportPanel.add(this.newLabel("report.colony.improve.header", null, null, ReportCompactColonyPanel.stpld("report.colony.improve")));
        this.reportPanel.add((Component)new JSeparator(0), "newline, span, growx");
    }

    private void update() {
        this.reportPanel.removeAll();
        String cols = "[l][c][c][c]";
        for (int i = 0; i < this.goodsTypes.size(); ++i) {
            cols = cols + "[c]";
        }
        cols = cols + "[c][c][l][l][l]";
        this.reportPanel.setLayout(new MigLayout("fillx, insets 0, gap 0 0", cols, ""));
        this.conciseHeaders(this.market);
        ArrayList<ColonySummary> summaries = new ArrayList<ColonySummary>();
        for (List<Colony> cs : this.colonies) {
            summaries.clear();
            for (Colony c : cs) {
                ColonySummary s = new ColonySummary(c, this.goodsTypes);
                summaries.add(s);
                this.updateColony(s);
            }
            if (cs.size() > 1) {
                this.updateCombinedColonies(summaries);
            }
            this.conciseHeaders(this.market);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        Game game = this.getGame();
        String command = ae.getActionCommand();
        if (command.startsWith(BUILDQUEUE)) {
            Colony colony = game.getFreeColGameObject(command = command.substring(BUILDQUEUE.length()), Colony.class);
            if (colony != null) {
                this.getGUI().showBuildQueuePanel(colony, () -> this.update());
                return;
            }
        } else {
            Colony colony = game.getFreeColGameObject(command, Colony.class);
            if (colony != null) {
                this.getGUI().showColonyPanel2(colony, null).addClosingCallback(() -> this.update());
                return;
            }
        }
        super.actionPerformed(ae);
    }

    private static class ColonySummary {
        public static BinaryOperator<GoodsProduction> goodsProductionAccumulator = (g1, g2) -> {
            g1.amount += g2.amount;
            g1.status = g1.status == ProductionStatus.NONE && g2.status == ProductionStatus.NONE ? ProductionStatus.NONE : (g1.amount < 0 ? ProductionStatus.BAD : (g1.amount > 0 ? ProductionStatus.GOOD : ProductionStatus.ZERO));
            g1.extra = 0;
            return g1;
        };
        public final Colony colony;
        public final int schoolLevel;
        public final List<Colony.TileImprovementSuggestion> tileSuggestions = new ArrayList<Colony.TileImprovementSuggestion>();
        public final boolean famine;
        public final int newColonist;
        public final int bonus;
        public final int sizeChange;
        public final Map<GoodsType, GoodsProduction> production = new HashMap<GoodsType, GoodsProduction>();
        public final Map<Unit, Integer> teachers = new HashMap<Unit, Integer>();
        public final List<Unit> notWorking = new ArrayList<Unit>();
        public final List<UnitType> couldWork = new ArrayList<UnitType>();
        public final Map<UnitType, WorkLocation.Suggestion> improve = new HashMap<UnitType, WorkLocation.Suggestion>();
        public final Map<UnitType, WorkLocation.Suggestion> want = new HashMap<UnitType, WorkLocation.Suggestion>();
        public final BuildableType build;
        public final int completeTurns;
        public final AbstractGoods needed;

        public ColonySummary(Colony colony, List<GoodsType> goodsTypes) {
            this.colony = colony;
            WorkLocation school = colony.getWorkLocationWithAbility("model.ability.teach");
            this.schoolLevel = school instanceof Building ? ((Building)school).getLevel() : 0;
            Specification spec = colony.getSpecification();
            Player owner = colony.getOwner();
            GoodsType foodType = spec.getPrimaryFoodType();
            this.tileSuggestions.clear();
            this.tileSuggestions.addAll(colony.getTileImprovementSuggestions());
            int starve = colony.getStarvationTurns();
            if (starve < 0) {
                this.famine = false;
                this.newColonist = colony.getNewColonistTurns();
            } else {
                this.famine = starve <= 3;
                this.newColonist = -starve - 1;
            }
            this.bonus = colony.getProductionBonus();
            this.sizeChange = colony.getPreferredSizeChange();
            for (GoodsType gt : goodsTypes) {
                this.produce(gt);
            }
            for (Unit u : colony.getTile().getUnitList()) {
                if (u.getState() == Unit.UnitState.FORTIFIED || u.getState() == Unit.UnitState.SENTRY) continue;
                this.notWorking.add(u);
            }
            for (WorkLocation wl : colony.getAvailableWorkLocations()) {
                if (!wl.canBeWorked()) continue;
                if (wl.canTeach()) {
                    for (Unit unit : wl.getUnitList()) {
                        this.teachers.put(unit, unit.getNeededTurnsOfTraining() - unit.getTurnsOfTraining());
                    }
                    continue;
                }
                for (Unit unit : wl.getUnitList()) {
                    if (unit.getTeacher() != null || unit.getWorkType() != null) continue;
                    this.notWorking.add(unit);
                }
                for (Map.Entry entry : wl.getSuggestions().entrySet()) {
                    Unit u = (Unit)entry.getKey();
                    WorkLocation.Suggestion s = (WorkLocation.Suggestion)entry.getValue();
                    UnitType expert = spec.getExpertForProducing(s.goodsType);
                    if (u == null) {
                        this.addSuggestion(this.want, expert, s);
                        continue;
                    }
                    this.addSuggestion(this.improve, expert, s);
                }
            }
            for (Unit u : this.notWorking) {
                GoodsType w;
                GoodsType t = u.getWorkType();
                WorkLocation workLocation = u.getWorkLocation();
                if (workLocation == null || (w = workLocation.getWorkFor(u)) != null && w == t) continue;
                this.couldWork.add(u.getType());
            }
            this.build = colony.getCurrentlyBuilding();
            if (this.build == null) {
                this.completeTurns = -1;
                this.needed = null;
            } else {
                AbstractGoods needed = new AbstractGoods();
                this.completeTurns = colony.getTurnsToComplete(this.build, needed);
                this.needed = this.completeTurns < 0 ? needed : null;
            }
        }

        private void produce(GoodsType goodsType) {
            ProductionStatus status;
            ExportData exportData = this.colony.getExportData(goodsType);
            int adjustment = this.colony.getWarehouseCapacity() / 100;
            int low = exportData.getLowLevel() * adjustment;
            int high = exportData.getHighLevel() * adjustment;
            int amount = this.colony.getGoodsCount(goodsType);
            int p = this.colony.getAdjustedNetProductionOf(goodsType);
            int extra = 0;
            if (p < 0) {
                status = amount < low ? ProductionStatus.FAIL : ProductionStatus.BAD;
                extra = -amount / p + 1;
            } else if (p == 0 && !this.colony.isProducing(goodsType)) {
                status = ProductionStatus.NONE;
            } else if (p == 0) {
                status = ProductionStatus.ZERO;
                extra = 0;
                AbstractGoods deficit = null;
                for (WorkLocation wl : this.colony.getWorkLocationsForProducing(goodsType)) {
                    ProductionInfo pi = this.colony.getProductionInfo(wl);
                    if (pi == null || (deficit = AbstractGoods.findByType(goodsType, pi.getConsumptionDeficit())) == null) continue;
                    status = ProductionStatus.CONSUMPTION;
                    extra = deficit.getAmount();
                    break;
                }
            } else if (exportData.getExported()) {
                status = ProductionStatus.EXPORT;
                extra = exportData.getExportLevel();
            } else if (goodsType.limitIgnored()) {
                status = ProductionStatus.GOOD;
            } else if (amount + p > this.colony.getWarehouseCapacity()) {
                status = ProductionStatus.OVERFLOW;
                extra = amount + p - this.colony.getWarehouseCapacity();
            } else if (amount >= high) {
                status = ProductionStatus.EXCESS;
                extra = (this.colony.getWarehouseCapacity() - amount) / p;
            } else {
                status = ProductionStatus.GOOD;
                extra = 0;
                AbstractGoods deficit = null;
                for (WorkLocation wl : this.colony.getWorkLocationsForProducing(goodsType)) {
                    ProductionInfo pi = this.colony.getProductionInfo(wl);
                    if (pi == null || (deficit = AbstractGoods.findByType(goodsType, pi.getProductionDeficit())) == null) continue;
                    status = ProductionStatus.PRODUCTION;
                    extra = deficit.getAmount();
                    break;
                }
            }
            this.production.put(goodsType, new GoodsProduction(p, status, extra));
        }

        private void addSuggestion(Map<UnitType, WorkLocation.Suggestion> suggestions, UnitType expert, WorkLocation.Suggestion suggestion) {
            if (suggestion == null || expert == null) {
                return;
            }
            WorkLocation.Suggestion now = suggestions.get(expert);
            if (now == null || now.amount < suggestion.amount) {
                suggestions.put(expert, suggestion);
            }
        }

        public static class GoodsProduction {
            public int amount;
            public ProductionStatus status;
            public int extra;

            public GoodsProduction(int amount, ProductionStatus status, int extra) {
                this.amount = amount;
                this.status = status;
                this.extra = extra;
            }
        }

        public static enum ProductionStatus {
            FAIL,
            BAD,
            NONE,
            ZERO,
            GOOD,
            EXPORT,
            EXCESS,
            OVERFLOW,
            PRODUCTION,
            CONSUMPTION;

        }
    }
}

