/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.plaf;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.plaf.UIResource;
import net.sf.freecol.common.ObjectWithId;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Named;
import net.sf.freecol.common.option.LanguageOption;

public class FreeColComboBoxRenderer<T>
implements ListCellRenderer<T>,
UIResource {
    private static final Logger logger = Logger.getLogger(FreeColComboBoxRenderer.class.getName());
    private final SelectedComponent SELECTED_COMPONENT = new SelectedComponent();
    private final NormalComponent NORMAL_COMPONENT = new NormalComponent();
    private final String prefix;
    private boolean localize = true;

    public FreeColComboBoxRenderer() {
        this("");
    }

    public FreeColComboBoxRenderer(String prefix) {
        this(prefix, true);
    }

    public FreeColComboBoxRenderer(String prefix, boolean localize) {
        this.prefix = prefix;
        this.localize = localize;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends T> list, T value, int index, boolean isSelected, boolean hasFocus) {
        JLabel c = isSelected ? this.SELECTED_COMPONENT : this.NORMAL_COMPONENT;
        c.setForeground(list.getForeground());
        c.setFont(list.getFont());
        this.setLabelValues(c, value);
        return c;
    }

    public void setLabelValues(JLabel c, T value) {
        if (value == null) {
            c.setText(null);
        } else if (value instanceof Integer) {
            c.setText(value.toString());
        } else if (value instanceof LanguageOption.Language) {
            c.setText(value.toString());
        } else if (value instanceof String) {
            String string = (String)value;
            if (this.localize) {
                String[] nd = Messages.getBestNameAndDescription(string);
                c.setText(nd[0]);
                if (nd[1] != null) {
                    c.setToolTipText(nd[1]);
                }
            } else {
                c.setText(string);
            }
        } else if (value instanceof Named) {
            Named named = (Named)value;
            String[] nad = Messages.getBestNameAndDescription(named);
            c.setText(nad[0]);
            if (nad[1] != null) {
                c.setToolTipText(nad[1]);
            }
        } else if (value instanceof ObjectWithId) {
            String realname;
            String id = (this.prefix == null ? "" : this.prefix) + ((ObjectWithId)value).getId();
            String[] nd = Messages.getBestNameAndDescription(id);
            if (value instanceof Nameable && (realname = ((Nameable)value).getName()) != null) {
                nd[0] = realname;
            }
            c.setText(nd[0]);
            if (nd[1] != null) {
                c.setToolTipText(nd[1]);
            }
        } else {
            logger.warning("What is this?: " + value + " (" + value.getClass() + ")");
        }
    }

    private static class NormalComponent
    extends JLabel {
        public NormalComponent() {
            this.setOpaque(false);
        }
    }

    private static class SelectedComponent
    extends JLabel {
        public SelectedComponent() {
            this.setOpaque(false);
        }

        @Override
        public void paintComponent(Graphics g) {
            Graphics2D g2d = (Graphics2D)g;
            Composite oldComposite = g2d.getComposite();
            Color oldColor = g2d.getColor();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.1f));
            g2d.setColor(Color.BLACK);
            g2d.fillRect(0, 0, this.getWidth(), this.getHeight());
            g2d.setComposite(oldComposite);
            g2d.setColor(oldColor);
            super.paintComponent(g);
        }
    }
}

