#include "typedef.h"
#include "tools.h"

/***************************************************************************
@---------------------------------------------------------------------------
@
@  FILE: divide_by_gcd.c
@
@---------------------------------------------------------------------------
****************************************************************************/

/***************************************************************************
@---------------------------------------------------------------------------
@
@ int divide_by_gcd(matrix_TYP *A)
@
@ divides the entries of A->array.SZ by the positive gcd of it's entries,
@ and returns this gcd.
@
@---------------------------------------------------------------------------
****************************************************************************/
int divide_by_gcd(matrix_TYP *A)
{
  int g = labs(A->array.SZ[0][0]),
      i,
      j;

  for (i=0;i<A->rows && (g!=1);i++){
     for (j=0;j<A->cols && (g!=1);j++){
        g = labs(GGT(A->array.SZ[i][j],g));
     }
  }

  if (g!=1){
     for (i=0;i<A->rows;i++){
        for (j=0;j<A->cols;j++){
           A->array.SZ[i][j] = A->array.SZ[i][j]/g;
        }
     }
  }

  return g;
}
