/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import tim.prune.App;
import tim.prune.I18nManager;
import tim.prune.undo.UndoStack;

public class UndoManager {
    private App _app = null;
    private JFrame _parentFrame = null;
    private JDialog _dialog = null;
    private JList<String> _actionList = null;

    public UndoManager(App app, JFrame jFrame) {
        this._app = app;
        this._parentFrame = jFrame;
    }

    public void show() {
        this._dialog = new JDialog(this._parentFrame, I18nManager.getText("dialog.undo.title"), true);
        this._dialog.setLocationRelativeTo(this._parentFrame);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(3, 3));
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        UndoStack undoStack = this._app.getUndoStack();
        jPanel.add((Component)new JLabel(I18nManager.getText("dialog.undo.pretext")), "North");
        String[] stringArray = new String[undoStack.size()];
        int n = 0;
        while (n < undoStack.size()) {
            stringArray[n] = undoStack.getOperationAt(undoStack.size() - 1 - n).getDescription();
            ++n;
        }
        this._actionList = new JList<String>(stringArray);
        this._actionList.setSelectionMode(1);
        this._actionList.setSelectedIndex(0);
        this._actionList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (UndoManager.this._actionList.getMinSelectionIndex() > 0) {
                    UndoManager.this._actionList.setSelectionInterval(0, UndoManager.this._actionList.getMaxSelectionIndex());
                }
            }
        });
        jPanel.add((Component)new JScrollPane(this._actionList), "Center");
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        JButton jButton = new JButton(I18nManager.getText("button.ok"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UndoManager.this._app.undoActions(UndoManager.this._actionList.getMaxSelectionIndex() + 1);
                UndoManager.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(I18nManager.getText("button.cancel"));
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                UndoManager.this._dialog.dispose();
            }
        });
        jPanel2.add(jButton2);
        jPanel.add((Component)jPanel2, "South");
        this._dialog.getContentPane().add(jPanel);
        this._dialog.pack();
        this._dialog.setVisible(true);
    }
}

