/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.language.plugins;

import java.util.Set;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.DomainObjectSet;
import org.gradle.api.Incubating;
import org.gradle.api.Plugin;
import org.gradle.api.Task;
import org.gradle.api.Transformer;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.ConfigurationContainer;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.attributes.Attribute;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.attributes.AttributeDisambiguationRule;
import org.gradle.api.attributes.MultipleCandidatesDetails;
import org.gradle.api.component.ComponentWithVariants;
import org.gradle.api.component.PublishableComponent;
import org.gradle.api.component.SoftwareComponent;
import org.gradle.api.component.SoftwareComponentContainer;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.RegularFile;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.TaskContainerInternal;
import org.gradle.api.plugins.AppliedPlugin;
import org.gradle.api.provider.Provider;
import org.gradle.api.provider.ProviderFactory;
import org.gradle.api.publish.PublishingExtension;
import org.gradle.api.publish.maven.MavenPublication;
import org.gradle.api.publish.maven.internal.publication.MavenPublicationInternal;
import org.gradle.api.publish.maven.internal.publisher.MutableMavenProjectIdentity;
import org.gradle.api.tasks.TaskContainer;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.internal.Cast;
import org.gradle.language.ComponentWithBinaries;
import org.gradle.language.ComponentWithOutputs;
import org.gradle.language.ProductionComponent;
import org.gradle.language.base.plugins.LifecycleBasePlugin;
import org.gradle.language.cpp.CppBinary;
import org.gradle.language.nativeplatform.internal.ComponentWithNames;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithExecutable;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithLinkUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithRuntimeUsage;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithSharedLibrary;
import org.gradle.language.nativeplatform.internal.ConfigurableComponentWithStaticLibrary;
import org.gradle.language.nativeplatform.internal.Names;
import org.gradle.language.nativeplatform.internal.PublicationAwareComponent;
import org.gradle.nativeplatform.Linkage;
import org.gradle.nativeplatform.platform.NativePlatform;
import org.gradle.nativeplatform.tasks.AbstractLinkTask;
import org.gradle.nativeplatform.tasks.CreateStaticLibrary;
import org.gradle.nativeplatform.tasks.ExtractSymbols;
import org.gradle.nativeplatform.tasks.InstallExecutable;
import org.gradle.nativeplatform.tasks.LinkExecutable;
import org.gradle.nativeplatform.tasks.LinkSharedLibrary;
import org.gradle.nativeplatform.tasks.StripSymbols;
import org.gradle.nativeplatform.toolchain.NativeToolChain;
import org.gradle.nativeplatform.toolchain.internal.PlatformToolProvider;

@Incubating
public class NativeBasePlugin
implements Plugin<ProjectInternal> {
    public void apply(ProjectInternal project) {
        project.getPluginManager().apply(LifecycleBasePlugin.class);
        TaskContainerInternal tasks = project.getTasks();
        ProviderFactory providers = project.getProviders();
        DirectoryProperty buildDirectory = project.getLayout().getBuildDirectory();
        SoftwareComponentContainer components = project.getComponents();
        this.addLifecycleTasks((TaskContainer)tasks, components);
        this.addTasksForComponentWithExecutable((TaskContainer)tasks, providers, buildDirectory, components);
        this.addTasksForComponentWithSharedLibrary((TaskContainer)tasks, providers, buildDirectory, components);
        this.addTasksForComponentWithStaticLibrary((TaskContainer)tasks, providers, buildDirectory, components);
        ConfigurationContainer configurations = project.getConfigurations();
        project.getDependencies().getAttributesSchema().attribute(CppBinary.LINKAGE_ATTRIBUTE).getDisambiguationRules().add(LinkageSelectionRule.class);
        this.addOutgoingConfigurationForLinkUsage(components, configurations);
        this.addOutgoingConfigurationForRuntimeUsage(components, configurations);
        this.addPublicationsFromVariants(project, components);
    }

    private void addLifecycleTasks(final TaskContainer tasks, final SoftwareComponentContainer components) {
        components.withType(ComponentWithBinaries.class, (Action)new Action<ComponentWithBinaries>(){

            public void execute(final ComponentWithBinaries component) {
                component.getBinaries().whenElementKnown((Action<? extends SoftwareComponent>)new Action<SoftwareComponent>(){

                    public void execute(SoftwareComponent binary) {
                        components.add((Object)binary);
                    }
                });
                if (component instanceof ProductionComponent) {
                    component.getBinaries().whenElementFinalized(ComponentWithOutputs.class, new Action<ComponentWithOutputs>(){

                        public void execute(ComponentWithOutputs binary) {
                            final FileCollection outputs = binary.getOutputs();
                            Names names = ((ComponentWithNames)((Object)binary)).getNames();
                            tasks.register(names.getTaskName("assemble"), (Action)new Action<Task>(){

                                public void execute(Task lifecycleTask) {
                                    lifecycleTask.dependsOn(new Object[]{outputs});
                                }
                            });
                            if (binary == ((ProductionComponent)((Object)component)).getDevelopmentBinary().get()) {
                                tasks.named("assemble", (Action)new Action<Task>(){

                                    public void execute(Task task) {
                                        task.dependsOn(new Object[]{outputs});
                                    }
                                });
                            }
                        }
                    });
                }
            }
        });
    }

    private void addTasksForComponentWithExecutable(final TaskContainer tasks, final ProviderFactory providers, final DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithExecutable.class, (Action)new Action<ConfigurableComponentWithExecutable>(){

            public void execute(final ConfigurableComponentWithExecutable executable) {
                final Names names = executable.getNames();
                final NativeToolChain toolChain = executable.getToolChain();
                final NativePlatform targetPlatform = executable.getTargetPlatform();
                final PlatformToolProvider toolProvider = executable.getPlatformToolProvider();
                TaskProvider link = tasks.register(names.getTaskName("link"), LinkExecutable.class, (Action)new Action<LinkExecutable>(){

                    public void execute(LinkExecutable link) {
                        link.source((Object)executable.getObjects());
                        link.lib((Object)executable.getLinkLibraries());
                        link.getLinkedFile().set(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() {
                                return toolProvider.getExecutableName("exe/" + names.getDirName() + (String)executable.getBaseName().get());
                            }
                        })));
                        link.getTargetPlatform().set((Object)targetPlatform);
                        link.getToolChain().set((Object)toolChain);
                        link.getDebuggable().set((Object)executable.isDebuggable());
                    }
                });
                executable.getLinkTask().set((Provider)link);
                executable.getDebuggerExecutableFile().set(link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, LinkExecutable>(){

                    public Provider<? extends RegularFile> transform(LinkExecutable linkExecutable) {
                        return linkExecutable.getLinkedFile();
                    }
                }));
                if (executable.isDebuggable() && executable.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                    Provider symbolLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableSymbolFileName("exe/" + names.getDirName() + "stripped/" + (String)executable.getBaseName().get());
                        }
                    }));
                    Provider strippedLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getExecutableName("exe/" + names.getDirName() + "stripped/" + (String)executable.getBaseName().get());
                        }
                    }));
                    TaskProvider stripSymbols = NativeBasePlugin.this.stripSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)strippedLocation);
                    executable.getExecutableFile().set(stripSymbols.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, StripSymbols>(){

                        public Provider<? extends RegularFile> transform(StripSymbols stripSymbols) {
                            return stripSymbols.getOutputFile();
                        }
                    }));
                    TaskProvider extractSymbols = NativeBasePlugin.this.extractSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)symbolLocation);
                    executable.getOutputs().from(new Object[]{extractSymbols.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, ExtractSymbols>(){

                        public Provider<? extends RegularFile> transform(ExtractSymbols extractSymbols) {
                            return extractSymbols.getSymbolFile();
                        }
                    })});
                } else {
                    executable.getExecutableFile().set(link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, LinkExecutable>(){

                        public Provider<? extends RegularFile> transform(LinkExecutable linkExecutable) {
                            return linkExecutable.getLinkedFile();
                        }
                    }));
                }
                TaskProvider install = tasks.register(names.getTaskName("install"), InstallExecutable.class, (Action)new Action<InstallExecutable>(){

                    public void execute(InstallExecutable install) {
                        install.getTargetPlatform().set((Object)targetPlatform);
                        install.getToolChain().set((Object)toolChain);
                        install.getInstallDirectory().set(buildDirectory.dir("install/" + names.getDirName()));
                        install.getExecutableFile().set(executable.getExecutableFile());
                        install.lib((Object)executable.getRuntimeLibraries());
                    }
                });
                executable.getInstallTask().set((Provider)install);
                executable.getInstallDirectory().set(install.flatMap((Transformer)new Transformer<Provider<? extends Directory>, InstallExecutable>(){

                    public Provider<? extends Directory> transform(InstallExecutable installExecutable) {
                        return installExecutable.getInstallDirectory();
                    }
                }));
                executable.getOutputs().from(new Object[]{executable.getInstallDirectory()});
                executable.getDebuggerExecutableFile().set(install.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, InstallExecutable>(){

                    public Provider<? extends RegularFile> transform(InstallExecutable installExecutable) {
                        return installExecutable.getInstalledExecutable();
                    }
                }));
            }
        });
    }

    private void addTasksForComponentWithSharedLibrary(final TaskContainer tasks, final ProviderFactory providers, final DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithSharedLibrary.class, (Action)new Action<ConfigurableComponentWithSharedLibrary>(){

            public void execute(final ConfigurableComponentWithSharedLibrary library) {
                final Names names = library.getNames();
                final NativePlatform targetPlatform = library.getTargetPlatform();
                final NativeToolChain toolChain = library.getToolChain();
                final PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                TaskProvider link = tasks.register(names.getTaskName("link"), LinkSharedLibrary.class, (Action)new Action<LinkSharedLibrary>(){

                    public void execute(LinkSharedLibrary link) {
                        link.source((Object)library.getObjects());
                        link.lib((Object)library.getLinkLibraries());
                        link.getLinkedFile().set(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() {
                                return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + (String)library.getBaseName().get());
                            }
                        })));
                        link.getTargetPlatform().set((Object)targetPlatform);
                        link.getToolChain().set((Object)toolChain);
                        link.getDebuggable().set((Object)library.isDebuggable());
                    }
                });
                Provider linkFile = link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, LinkSharedLibrary>(){

                    public Provider<? extends RegularFile> transform(LinkSharedLibrary linkSharedLibrary) {
                        return linkSharedLibrary.getLinkedFile();
                    }
                });
                Provider runtimeFile = link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, LinkSharedLibrary>(){

                    public Provider<? extends RegularFile> transform(LinkSharedLibrary linkSharedLibrary) {
                        return linkSharedLibrary.getLinkedFile();
                    }
                });
                if (toolProvider.producesImportLibrary()) {
                    link.configure((Action)new Action<LinkSharedLibrary>(){

                        public void execute(LinkSharedLibrary linkSharedLibrary) {
                            linkSharedLibrary.getImportLibrary().set(buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                                @Override
                                public String call() {
                                    return toolProvider.getImportLibraryName("lib/" + names.getDirName() + (String)library.getBaseName().get());
                                }
                            })));
                        }
                    });
                    linkFile = link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, LinkSharedLibrary>(){

                        public Provider<? extends RegularFile> transform(LinkSharedLibrary linkSharedLibrary) {
                            return linkSharedLibrary.getImportLibrary();
                        }
                    });
                }
                if (library.isDebuggable() && library.isOptimized() && toolProvider.requiresDebugBinaryStripping()) {
                    Provider symbolLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getLibrarySymbolFileName("lib/" + names.getDirName() + "stripped/" + (String)library.getBaseName().get());
                        }
                    }));
                    Provider strippedLocation = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                        @Override
                        public String call() {
                            return toolProvider.getSharedLibraryName("lib/" + names.getDirName() + "stripped/" + (String)library.getBaseName().get());
                        }
                    }));
                    TaskProvider stripSymbols = NativeBasePlugin.this.stripSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)strippedLocation);
                    linkFile = runtimeFile = stripSymbols.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, StripSymbols>(){

                        public Provider<? extends RegularFile> transform(StripSymbols stripSymbols) {
                            return stripSymbols.getOutputFile();
                        }
                    });
                    TaskProvider extractSymbols = NativeBasePlugin.this.extractSymbols((TaskProvider<? extends AbstractLinkTask>)link, names, tasks, toolChain, targetPlatform, (Provider<RegularFile>)symbolLocation);
                    library.getOutputs().from(new Object[]{extractSymbols.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, ExtractSymbols>(){

                        public Provider<? extends RegularFile> transform(ExtractSymbols extractSymbols) {
                            return extractSymbols.getSymbolFile();
                        }
                    })});
                }
                library.getLinkTask().set((Provider)link);
                library.getLinkFile().set(linkFile);
                library.getRuntimeFile().set(runtimeFile);
                library.getOutputs().from(new Object[]{library.getLinkFile()});
                library.getOutputs().from(new Object[]{library.getRuntimeFile()});
            }
        });
    }

    private void addTasksForComponentWithStaticLibrary(final TaskContainer tasks, final ProviderFactory providers, final DirectoryProperty buildDirectory, SoftwareComponentContainer components) {
        components.withType(ConfigurableComponentWithStaticLibrary.class, (Action)new Action<ConfigurableComponentWithStaticLibrary>(){

            public void execute(final ConfigurableComponentWithStaticLibrary library) {
                final Names names = library.getNames();
                TaskProvider createTask = tasks.register(names.getTaskName("create"), CreateStaticLibrary.class, (Action)new Action<CreateStaticLibrary>(){

                    public void execute(CreateStaticLibrary createTask) {
                        createTask.source((Object)library.getObjects());
                        final PlatformToolProvider toolProvider = library.getPlatformToolProvider();
                        Provider linktimeFile = buildDirectory.file(providers.provider((Callable)new Callable<String>(){

                            @Override
                            public String call() {
                                return toolProvider.getStaticLibraryName("lib/" + names.getDirName() + (String)library.getBaseName().get());
                            }
                        }));
                        createTask.getOutputFile().set(linktimeFile);
                        createTask.getTargetPlatform().set((Object)library.getTargetPlatform());
                        createTask.getToolChain().set((Object)library.getToolChain());
                    }
                });
                library.getLinkFile().set(createTask.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, CreateStaticLibrary>(){

                    public Provider<? extends RegularFile> transform(CreateStaticLibrary createStaticLibrary) {
                        return createStaticLibrary.getBinaryFile();
                    }
                }));
                library.getCreateTask().set((Provider)createTask);
                library.getOutputs().from(new Object[]{library.getLinkFile()});
            }
        });
    }

    private void addOutgoingConfigurationForLinkUsage(SoftwareComponentContainer components, final ConfigurationContainer configurations) {
        components.withType(ConfigurableComponentWithLinkUsage.class, (Action)new Action<ConfigurableComponentWithLinkUsage>(){

            public void execute(ConfigurableComponentWithLinkUsage component) {
                Names names = component.getNames();
                Configuration linkElements = (Configuration)configurations.create(names.withSuffix("linkElements"));
                linkElements.extendsFrom(new Configuration[]{component.getImplementationDependencies()});
                linkElements.setCanBeResolved(false);
                AttributeContainer attributes = component.getLinkAttributes();
                NativeBasePlugin.this.copyAttributesTo(attributes, linkElements);
                linkElements.getOutgoing().artifact(component.getLinkFile());
                component.getLinkElements().set((Object)linkElements);
            }
        });
    }

    private void addOutgoingConfigurationForRuntimeUsage(SoftwareComponentContainer components, final ConfigurationContainer configurations) {
        components.withType(ConfigurableComponentWithRuntimeUsage.class, (Action)new Action<ConfigurableComponentWithRuntimeUsage>(){

            public void execute(ConfigurableComponentWithRuntimeUsage component) {
                Names names = component.getNames();
                Configuration runtimeElements = (Configuration)configurations.create(names.withSuffix("runtimeElements"));
                runtimeElements.extendsFrom(new Configuration[]{component.getImplementationDependencies()});
                runtimeElements.setCanBeResolved(false);
                AttributeContainer attributes = component.getRuntimeAttributes();
                NativeBasePlugin.this.copyAttributesTo(attributes, runtimeElements);
                if (component.hasRuntimeFile()) {
                    runtimeElements.getOutgoing().artifact(component.getRuntimeFile());
                }
                component.getRuntimeElements().set((Object)runtimeElements);
            }
        });
    }

    private void addPublicationsFromVariants(final ProjectInternal project, final SoftwareComponentContainer components) {
        project.getPluginManager().withPlugin("maven-publish", (Action)new Action<AppliedPlugin>(){

            public void execute(AppliedPlugin appliedPlugin) {
                components.withType(PublicationAwareComponent.class, (Action)new Action<PublicationAwareComponent>(){

                    public void execute(final PublicationAwareComponent component) {
                        project.getExtensions().configure(PublishingExtension.class, (Action)new Action<PublishingExtension>(){

                            public void execute(final PublishingExtension publishing) {
                                final ComponentWithVariants mainVariant = component.getMainPublication();
                                publishing.getPublications().create("main", MavenPublication.class, (Action)new Action<MavenPublication>(){

                                    public void execute(MavenPublication publication) {
                                        MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                                        publicationInternal.getMavenProjectIdentity().getArtifactId().set(component.getBaseName());
                                        publicationInternal.from((SoftwareComponent)mainVariant);
                                        publicationInternal.publishWithOriginalFileName();
                                    }
                                });
                                Set variants = mainVariant.getVariants();
                                if (variants instanceof DomainObjectSet) {
                                    ((DomainObjectSet)variants).all((Action)new Action<SoftwareComponent>(){

                                        public void execute(SoftwareComponent child) {
                                            this.addPublicationFromVariant(child, publishing);
                                        }
                                    });
                                } else {
                                    for (SoftwareComponent variant : variants) {
                                        this.addPublicationFromVariant(variant, publishing);
                                    }
                                }
                            }

                            private void addPublicationFromVariant(final SoftwareComponent child, PublishingExtension publishing) {
                                if (child instanceof PublishableComponent) {
                                    publishing.getPublications().create(child.getName(), MavenPublication.class, (Action)new Action<MavenPublication>(){

                                        public void execute(MavenPublication publication) {
                                            MavenPublicationInternal publicationInternal = (MavenPublicationInternal)publication;
                                            NativeBasePlugin.this.fillInCoordinates(project, publicationInternal, (PublishableComponent)child);
                                            publicationInternal.from(child);
                                            publicationInternal.publishWithOriginalFileName();
                                        }
                                    });
                                }
                            }
                        });
                    }
                });
            }
        });
    }

    private void fillInCoordinates(ProjectInternal project, MavenPublicationInternal publication, PublishableComponent publishableComponent) {
        final ModuleVersionIdentifier coordinates = publishableComponent.getCoordinates();
        MutableMavenProjectIdentity identity = publication.getMavenProjectIdentity();
        identity.getGroupId().set(project.provider((Callable)new Callable<String>(){

            @Override
            public String call() {
                return coordinates.getGroup();
            }
        }));
        identity.getArtifactId().set(project.provider((Callable)new Callable<String>(){

            @Override
            public String call() {
                return coordinates.getName();
            }
        }));
        identity.getVersion().set(project.provider((Callable)new Callable<String>(){

            @Override
            public String call() {
                return coordinates.getVersion();
            }
        }));
    }

    private void copyAttributesTo(AttributeContainer attributes, Configuration linkElements) {
        for (Attribute attribute : attributes.keySet()) {
            Object value = attributes.getAttribute(attribute);
            linkElements.getAttributes().attribute((Attribute)Cast.uncheckedCast((Object)attribute), value);
        }
    }

    private TaskProvider<StripSymbols> stripSymbols(final TaskProvider<? extends AbstractLinkTask> link, Names names, TaskContainer tasks, final NativeToolChain toolChain, final NativePlatform currentPlatform, final Provider<RegularFile> strippedLocation) {
        return tasks.register(names.getTaskName("stripSymbols"), StripSymbols.class, (Action)new Action<StripSymbols>(){

            public void execute(StripSymbols stripSymbols) {
                stripSymbols.getBinaryFile().set(link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, AbstractLinkTask>(){

                    public Provider<? extends RegularFile> transform(AbstractLinkTask abstractLinkTask) {
                        return abstractLinkTask.getLinkedFile();
                    }
                }));
                stripSymbols.getOutputFile().set(strippedLocation);
                stripSymbols.getTargetPlatform().set((Object)currentPlatform);
                stripSymbols.getToolChain().set((Object)toolChain);
            }
        });
    }

    private TaskProvider<ExtractSymbols> extractSymbols(final TaskProvider<? extends AbstractLinkTask> link, Names names, TaskContainer tasks, final NativeToolChain toolChain, final NativePlatform currentPlatform, final Provider<RegularFile> symbolLocation) {
        return tasks.register(names.getTaskName("extractSymbols"), ExtractSymbols.class, (Action)new Action<ExtractSymbols>(){

            public void execute(ExtractSymbols extractSymbols) {
                extractSymbols.getBinaryFile().set(link.flatMap((Transformer)new Transformer<Provider<? extends RegularFile>, AbstractLinkTask>(){

                    public Provider<? extends RegularFile> transform(AbstractLinkTask abstractLinkTask) {
                        return abstractLinkTask.getLinkedFile();
                    }
                }));
                extractSymbols.getSymbolFile().set(symbolLocation);
                extractSymbols.getTargetPlatform().set((Object)currentPlatform);
                extractSymbols.getToolChain().set((Object)toolChain);
            }
        });
    }

    static class LinkageSelectionRule
    implements AttributeDisambiguationRule<Linkage> {
        LinkageSelectionRule() {
        }

        public void execute(MultipleCandidatesDetails<Linkage> details) {
            if (details.getCandidateValues().contains(Linkage.SHARED)) {
                details.closestMatch((Object)Linkage.SHARED);
            }
        }
    }
}

