/*
 * Decompiled with CFR 0.152.
 */
package org.gjt.sp.jedit.gui;

import java.awt.event.InputEvent;
import java.util.Hashtable;
import javax.swing.UIManager;
import org.gjt.sp.jedit.EditAction;
import org.gjt.sp.jedit.View;
import org.gjt.sp.jedit.gui.InputHandler;
import org.gjt.sp.jedit.gui.KeyEventTranslator;
import org.gjt.sp.jedit.gui.ShortcutPrefixActiveEvent;

public class DefaultInputHandler
extends InputHandler {
    public DefaultInputHandler(View view, Hashtable hashtable) {
        super(view);
        if (hashtable == null) {
            throw new NullPointerException();
        }
        this.bindings = this.currentBindings = hashtable;
    }

    public DefaultInputHandler(View view) {
        this(view, new Hashtable());
    }

    public DefaultInputHandler(View view, DefaultInputHandler defaultInputHandler) {
        this(view, defaultInputHandler.bindings);
    }

    @Override
    public boolean isPrefixActive() {
        return this.bindings != this.currentBindings || super.isPrefixActive();
    }

    @Override
    public void setCurrentBindings(Hashtable hashtable) {
        this.view.getStatus().setMessage((String)hashtable.get(PREFIX_STR));
        this.currentBindings = hashtable;
    }

    @Override
    public boolean handleKey(KeyEventTranslator.Key key, boolean bl) {
        Object v;
        char c = '\u0000';
        if (key.modifiers == null || key.modifiers.equals("S")) {
            switch (key.key) {
                case 9: 
                case 10: {
                    c = (char)key.key;
                    break;
                }
                default: {
                    c = key.input;
                }
            }
        }
        if (this.readNextChar != null) {
            if (c != '\u0000') {
                if (!bl) {
                    this.setCurrentBindings(this.bindings);
                    this.invokeReadNextChar(c);
                    this.repeatCount = 1;
                }
                return true;
            }
            if (!bl) {
                this.readNextChar = null;
                this.view.getStatus().setMessage(null);
            }
        }
        if ((v = this.currentBindings.get(key)) == null) {
            if (!bl) {
                if (this.currentBindings != this.bindings) {
                    UIManager.getLookAndFeel().provideErrorFeedback(null);
                    this.repeatCount = 1;
                    this.setCurrentBindings(this.bindings);
                } else if (c != '\u0000' && !key.isFromGlobalContext()) {
                    this.userInput(c);
                }
                this.sendShortcutPrefixOff();
            }
        } else {
            if (v instanceof Hashtable) {
                if (!bl) {
                    this.setCurrentBindings((Hashtable)v);
                    ShortcutPrefixActiveEvent.firePrefixStateChange(this.currentBindings, true);
                    this.shortcutOn = true;
                }
                return true;
            }
            if (v instanceof String) {
                if (!bl) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((String)v);
                }
                return true;
            }
            if (v instanceof EditAction) {
                if (!bl) {
                    this.setCurrentBindings(this.bindings);
                    this.sendShortcutPrefixOff();
                    this.invokeAction((EditAction)v);
                }
                return true;
            }
        }
        if (!bl) {
            this.sendShortcutPrefixOff();
        }
        return false;
    }

    public static char getSymbolicModifierName(int n) {
        return KeyEventTranslator.getSymbolicModifierName(n);
    }

    public static String getModifierString(InputEvent inputEvent) {
        return KeyEventTranslator.getModifierString(inputEvent);
    }
}

