/*
 * Decompiled with CFR 0.152.
 */
package org.openscience.jmol.app.webexport;

import javajs.util.CU;
import javajs.util.P3;
import org.jmol.i18n.GT;
import org.openscience.jmol.app.webexport.JmolInstance;

class Widgets {
    Widget[] widgetList = new Widget[5];

    Widgets() {
        this.widgetList[0] = new SpinOnWidget();
        this.widgetList[1] = new BackgroundColorWidget();
        this.widgetList[2] = new StereoViewWidget();
        this.widgetList[3] = new AnimationWidget();
        this.widgetList[4] = new ConsoleWidget();
    }

    class AnimationWidget
    extends Widget {
        AnimationWidget() {
            this.name = GT.$("Animation Control");
        }

        @Override
        String getJavaScriptFileName() {
            return "JmolAnimationCntrl.js";
        }

        @Override
        String[] getSupportFileNames() {
            String[] stringArray = new String[9];
            String string = "org/openscience/jmol/app/images/";
            stringArray[0] = String.valueOf(string) + "lastButton.png";
            stringArray[1] = String.valueOf(string) + "playButton.png";
            stringArray[2] = String.valueOf(string) + "playLoopButton.png";
            stringArray[3] = String.valueOf(string) + "playOnceButton.png";
            stringArray[4] = String.valueOf(string) + "playPalindromeButton.png";
            stringArray[5] = String.valueOf(string) + "prevButton.png";
            stringArray[6] = String.valueOf(string) + "pauseButton.png";
            stringArray[7] = String.valueOf(string) + "nextButton.png";
            stringArray[8] = String.valueOf(string) + "firstButton.png";
            return stringArray;
        }

        @Override
        String getJavaScript(int n, JmolInstance jmolInstance) {
            String string = "<div class=\"AnimBox\"><div style=\"text-align:center\">" + GT.escapeHTML(GT.$("Animation")) + "</div>" + "<div>" + "<button title=\"" + GT.escapeHTML(GT.$("First Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + n + "'], 'frame rewind'));\">" + "<img src=\"firstButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT.$("Previous Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + n + "'], 'frame previous'));\">" + "<img src=\"prevButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT.$("Play")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + n + "'], 'frame play'));\">" + "<img src=\"playButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT.$("Next Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + n + "'], 'frame next'));\">" + "<img src=\"nextButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT.$("Pause")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + n + "'], 'frame pause'));\">" + "<img src=\"pauseButton.png\"></button>" + "<button title=\"" + GT.escapeHTML(GT.$("Last Frame")) + "\" onclick=\"void(Jmol.scriptWait(window['jmolApplet" + n + "'], 'frame last'));\">" + "<img src=\"lastButton.png\"></button>" + "</div>" + "<div>" + "<span>" + GT.escapeHTML(GT.$("Mode:")) + "</span>" + "<span id=\"jmol_loop_" + n + "\"><button title=\"" + GT.escapeHTML(GT.$("Loop")) + "\" onclick=\"jmol_animationmode('loop'," + n + ");\">" + "<img src=\"playLoopButton.png\"></button></span>" + "<span id=\"jmol_palindrome_" + n + "\"><button title=\"" + GT.escapeHTML(GT.$("Palindrome")) + "\" onclick=\"jmol_animationmode('palindrome', " + n + ");\">" + "<img src=\"playPalindromeButton.png\"></button></span>" + "<span class=\"jmol_playDefault\"" + " id=\"jmol_playOnce_" + n + "\"><button title=\"" + GT.escapeHTML(GT.$("Play Once")) + "\" onclick=\"jmol_animationmode('playOnce', " + n + ");\">" + "<img src=\"playOnceButton.png\"></button></span>" + "</div>" + "</div>";
            return string;
        }
    }

    class BackgroundColorWidget
    extends Widget {
        BackgroundColorWidget() {
            this.name = GT.$("Background Color");
        }

        @Override
        String getJavaScriptFileName() {
            return "JmolColorPicker.js";
        }

        @Override
        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        @Override
        String getJavaScript(int n, JmolInstance jmolInstance) {
            P3 p3 = CU.colorPtFromInt(jmolInstance.bgColor, null);
            return "<table><tbody><tr><td>" + GT.escapeHTML(GT.$("background color:")) + "</td><td style='min-width:70px;'><script type='text/javascript'>" + "var scriptStr = 'color background $COLOR$;';" + "jmolColorPickerBox(scriptStr, [" + (int)p3.x + "," + (int)p3.y + "," + (int)p3.z + "], 'backbox" + n + "',  '" + n + "');" + "</script></td></tr></tbody></table>";
        }
    }

    class ConsoleWidget
    extends Widget {
        ConsoleWidget() {
            this.name = GT.$("Open Console Button");
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        @Override
        String getJavaScript(int n, JmolInstance jmolInstance) {
            return "<button title=\"" + GT.escapeHTML(GT.$("launch Jmol console")) + "\" onclick=\"Jmol.script(window['jmolApplet" + n + "'], 'console');\">" + GT.escapeHTML(GT.$("Jmol Console")) + "</button>";
        }
    }

    class DownLoadWidget
    extends Widget {
        DownLoadWidget() {
            this.name = GT.$("Download view");
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        @Override
        String getJavaScript(int n, JmolInstance jmolInstance) {
            return GT.$("unimplemented");
        }
    }

    class SpinOnWidget
    extends Widget {
        SpinOnWidget() {
            this.name = GT.$("Spin on/off");
        }

        @Override
        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String getJavaScript(int n, JmolInstance jmolInstance) {
            return "<input type=\"checkbox\" id=\"JmolSpinWidget" + n + "\"" + (jmolInstance.spinOn ? " checked=\"\"" : "") + " onclick=\"Jmol.scriptWait(window['jmolApplet" + n + "'], " + "'spin ' + (this.checked ? 'on' : 'off'));\" " + "title=\"" + GT.escapeHTML(GT.$("enable/disable spin")) + "\" />" + "<label for=\"JmolSpinWidget" + n + "\">" + GT.escapeHTML(GT.$("Spin on")) + "</label>";
        }
    }

    class StereoViewWidget
    extends Widget {
        StereoViewWidget() {
            this.name = GT.$("Stereo Viewing");
        }

        @Override
        String getJavaScriptFileName() {
            return "none";
        }

        @Override
        String[] getSupportFileNames() {
            String[] stringArray = new String[]{};
            return stringArray;
        }

        @Override
        String getJavaScript(int n, JmolInstance jmolInstance) {
            return "<select id=\"StereoMode" + n + "\" title=\"" + GT.escapeHTML(GT.$("select stereo type")) + "\"" + "onchange=\"void(Jmol.scriptWait(window['jmolApplet" + n + "'], " + "(this.options[this.selectedIndex]).value));\">" + "\n<option selected=\"\" value=\"stereo off\">" + GT.escapeHTML(GT.$("Stereo Off")) + " </option>" + "\n<option value=\"stereo REDBLUE\">" + GT.escapeHTML(GT.$("Red/Blue")) + "</option>" + "\n<option value=\"stereo REDCYAN\">" + GT.escapeHTML(GT.$("Red/Cyan")) + "</option>" + "\n<option value=\"stereo REDGREEN\">" + GT.escapeHTML(GT.$("Red/Green")) + "</option>" + "\n</select>";
        }
    }

    abstract class Widget {
        String name;

        Widget() {
        }

        abstract String getJavaScript(int var1, JmolInstance var2);

        abstract String getJavaScriptFileName();

        abstract String[] getSupportFileNames();
    }
}

