/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Map;
import javajs.api.GenericBinaryDocument;
import javajs.util.AU;
import javajs.util.Lst;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

class PickleReader {
    private Viewer vwr;
    private GenericBinaryDocument binaryDoc;
    private Lst<Object> stack = new Lst();
    private Lst<Integer> marks = new Lst();
    private Lst<Object> build = new Lst();
    private Map<Object, Object> memo = new Hashtable<Object, Object>();
    private boolean logging;
    private int id;
    private int markCount;
    private int filePt;
    private int emptyListPt;
    private Object thisSection;
    private boolean inMovie;
    private boolean inNames;
    private String thisName;
    private int lastMark;
    private int retrieveCount;
    private static final byte APPEND = 97;
    private static final byte APPENDS = 101;
    private static final byte BINFLOAT = 71;
    private static final byte BININT = 74;
    private static final byte BININT1 = 75;
    private static final byte BININT2 = 77;
    private static final byte BINPUT = 113;
    private static final byte BINSTRING = 84;
    private static final byte BINUNICODE = 87;
    private static final byte BUILD = 98;
    private static final byte EMPTY_DICT = 125;
    private static final byte EMPTY_LIST = 93;
    private static final byte GLOBAL = 99;
    private static final byte LONG_BINPUT = 114;
    private static final byte MARK = 40;
    private static final byte NONE = 78;
    private static final byte OBJ = 111;
    private static final byte SETITEM = 115;
    private static final byte SETITEMS = 117;
    private static final byte SHORT_BINSTRING = 85;
    private static final byte STOP = 46;
    private static final byte BINGET = 104;
    private static final byte LONG_BINGET = 106;
    private static final byte TUPLE = 116;
    private static final byte INT = 73;
    private int ipt = 0;
    byte[] aTemp = new byte[16];

    PickleReader(GenericBinaryDocument doc, Viewer vwr) {
        this.binaryDoc = doc;
        this.vwr = vwr;
        this.stack.ensureCapacity(1000);
    }

    private void log(String s) {
        this.vwr.log(s + "\u0000");
    }

    Map<String, Object> getMap(boolean logging) throws Exception {
        Map map;
        byte[] a;
        int i;
        Object o;
        this.logging = logging;
        this.ipt = 0;
        boolean going = true;
        block29: while (going) {
            byte b = this.binaryDoc.readByte();
            ++this.ipt;
            switch (b) {
                case 125: {
                    this.push(new Hashtable());
                    continue block29;
                }
                case 97: {
                    o = this.pop();
                    ((Lst)this.peek()).addLast(o);
                    continue block29;
                }
                case 101: {
                    Lst<Object> l = this.getObjects(this.getMark());
                    if (this.inNames && this.markCount == 2) {
                        int pt = (int)this.binaryDoc.getPosition();
                        Lst l2 = new Lst();
                        l2.addLast((Object)this.filePt);
                        l2.addLast((Object)(pt - this.filePt));
                        l.addLast((Object)l2);
                    }
                    ((Lst)this.peek()).addAll(l);
                    continue block29;
                }
                case 71: {
                    double d = this.binaryDoc.readDouble();
                    this.push(d);
                    continue block29;
                }
                case 74: {
                    i = this.binaryDoc.readIntLE();
                    this.push(i);
                    continue block29;
                }
                case 75: {
                    i = this.binaryDoc.readByte() & 0xFF;
                    this.push(i);
                    continue block29;
                }
                case 77: {
                    i = (this.binaryDoc.readByte() & 0xFF | (this.binaryDoc.readByte() & 0xFF) << 8) & 0xFFFF;
                    this.push(i);
                    continue block29;
                }
                case 113: {
                    i = this.binaryDoc.readByte();
                    this.putMemo(i, false);
                    continue block29;
                }
                case 114: {
                    i = this.binaryDoc.readIntLE();
                    this.putMemo(i, true);
                    continue block29;
                }
                case 104: {
                    i = this.binaryDoc.readByte();
                    o = this.getMemo(i);
                    this.push(o == null ? "BINGET" + ++this.id : o);
                    continue block29;
                }
                case 106: {
                    i = this.binaryDoc.readIntLE();
                    o = this.getMemo(i);
                    this.push(o == null ? "LONG_BINGET" + ++this.id : o);
                    continue block29;
                }
                case 85: {
                    i = this.binaryDoc.readByte() & 0xFF;
                    a = new byte[i];
                    this.binaryDoc.readByteArray(a, 0, i);
                    if (this.inNames && this.markCount == 3 && this.lastMark == this.stack.size()) {
                        this.thisName = this.bytesToString(a);
                        this.filePt = this.emptyListPt;
                    }
                    this.push(a);
                    continue block29;
                }
                case 84: {
                    i = this.binaryDoc.readIntLE();
                    a = new byte[i];
                    this.binaryDoc.readByteArray(a, 0, i);
                    this.push(a);
                    continue block29;
                }
                case 87: {
                    i = this.binaryDoc.readIntLE();
                    a = new byte[i];
                    this.binaryDoc.readByteArray(a, 0, i);
                    this.push(a);
                    continue block29;
                }
                case 93: {
                    this.emptyListPt = (int)this.binaryDoc.getPosition() - 1;
                    this.push(new Lst());
                    continue block29;
                }
                case 99: {
                    Lst<Object> l = new Lst<Object>();
                    l.addLast((Object)"global");
                    l.addLast((Object)this.readStringAsBytes());
                    l.addLast((Object)this.readStringAsBytes());
                    this.push(l);
                    continue block29;
                }
                case 98: {
                    o = this.pop();
                    this.build.addLast(o);
                    continue block29;
                }
                case 40: {
                    this.putMark(this.stack.size());
                    continue block29;
                }
                case 78: {
                    this.push(null);
                    continue block29;
                }
                case 111: {
                    this.push(this.getObjects(this.getMark()));
                    continue block29;
                }
                case 115: {
                    o = this.pop();
                    String s = this.bytesToString(this.pop());
                    ((Map)this.peek()).put(s, o);
                    continue block29;
                }
                case 117: {
                    int mark = this.getMark();
                    Lst<Object> l = this.getObjects(mark);
                    o = this.peek();
                    if (o instanceof Lst) {
                        for (i = 0; i < l.size(); ++i) {
                            ((Lst)o).addLast(l.get(i));
                        }
                        continue block29;
                    }
                    map = (Map)o;
                    i = l.size();
                    while (--i >= 0) {
                        o = l.get(i);
                        map.put(this.bytesToString(l.get(--i)), o);
                    }
                    continue block29;
                }
                case 46: {
                    going = false;
                    continue block29;
                }
                case 116: {
                    this.push(this.getObjects(this.getMark()));
                    continue block29;
                }
                case 73: {
                    String s = this.bytesToString(this.readStringAsBytes());
                    try {
                        this.push(Integer.parseInt(s));
                    }
                    catch (Exception e) {
                        long ll = Long.parseLong(s);
                        this.push((int)(ll & 0xFFFFFFFFFFFFFFFFL));
                    }
                    continue block29;
                }
            }
            Logger.error((String)("Pickle reader error: " + b + " " + this.binaryDoc.getPosition()));
        }
        if (logging) {
            this.log("");
        }
        Logger.info((String)("PyMOL Pickle reader cached " + this.memo.size() + " tokens; retrieved " + this.retrieveCount));
        map = (Map)this.stack.removeItemAt(0);
        if (map.size() == 0) {
            i = this.stack.size();
            while (--i >= 0) {
                o = this.stack.get(i--);
                a = (byte[])this.stack.get(i);
                map.put(this.bytesToString(a), o);
            }
        }
        this.memo = null;
        return map;
    }

    private String bytesToString(Object o) {
        try {
            return AU.isAB((Object)o) ? new String((byte[])o, "UTF-8") : o.toString();
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    private void putMemo(int i, boolean doCheck) {
        Object o = this.peek();
        if (AU.isAB((Object)o)) {
            o = this.bytesToString((byte[])o);
        }
        if (o instanceof String) {
            if (doCheck && this.markCount >= 6 || this.markCount == 3 && this.inMovie) {
                return;
            }
            this.memo.put(i, o);
        }
    }

    private Object getMemo(int i) {
        Object o = this.memo.get(i);
        if (o == null) {
            return o;
        }
        ++this.retrieveCount;
        return o;
    }

    private Lst<Object> getObjects(int mark) {
        int i;
        int n = this.stack.size() - mark;
        Lst args = new Lst();
        args.ensureCapacity(n);
        for (i = mark; i < this.stack.size(); ++i) {
            args.addLast(this.stack.get(i));
        }
        i = this.stack.size();
        while (--i >= mark) {
            this.stack.removeItemAt(i);
        }
        return args;
    }

    private byte[] readStringAsBytes() throws Exception {
        byte b;
        int n = 0;
        byte[] a = this.aTemp;
        while ((b = this.binaryDoc.readByte()) != 10) {
            if (n >= a.length) {
                a = this.aTemp = AU.arrayCopyByte((byte[])a, (int)(a.length * 2));
            }
            a[n++] = b;
        }
        return AU.arrayCopyByte((byte[])a, (int)n);
    }

    private void putMark(int i) {
        if (this.logging) {
            this.log("\n " + Integer.toHexString((int)this.binaryDoc.getPosition()) + " [");
        }
        this.lastMark = i;
        this.marks.addLast((Object)this.lastMark);
        ++this.markCount;
        switch (this.markCount) {
            case 2: {
                Object o = this.stack.get(i - 2);
                if (!AU.isAB((Object)o)) break;
                this.thisSection = this.bytesToString((byte[])o);
                this.inMovie = "movie".equals(this.thisSection);
                this.inNames = "names".equals(this.thisSection);
                break;
            }
        }
    }

    private int getMark() {
        return (Integer)this.marks.removeItemAt(--this.markCount);
    }

    private void push(Object o) {
        if (this.logging && (o instanceof String || o instanceof Double || o instanceof Integer)) {
            this.log((o instanceof String ? "'" + o + "'" : o) + ", ");
        }
        this.stack.addLast(o);
    }

    private Object peek() {
        return this.stack.get(this.stack.size() - 1);
    }

    private Object pop() {
        return this.stack.removeItemAt(this.stack.size() - 1);
    }
}

