/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.repo;

import java.net.URI;
import java.text.ParseException;
import java.util.Iterator;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.ExecutionEnvironmentProfileProvider;
import org.apache.ivy.osgi.core.ManifestParser;
import org.apache.ivy.osgi.repo.ManifestAndLocation;
import org.apache.ivy.osgi.repo.RepoDescriptor;
import org.apache.ivy.util.Message;

public class BundleRepoDescriptor
extends RepoDescriptor {
    private String name;
    private Long lastModified;

    public BundleRepoDescriptor(URI uRI, ExecutionEnvironmentProfileProvider executionEnvironmentProfileProvider) {
        super(uRI, executionEnvironmentProfileProvider);
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public void setLastModified(Long l) {
        this.lastModified = l;
    }

    public Long getLastModified() {
        return this.lastModified;
    }

    public void populate(Iterator iterator) {
        while (iterator.hasNext()) {
            ManifestAndLocation manifestAndLocation = (ManifestAndLocation)iterator.next();
            try {
                BundleInfo bundleInfo = ManifestParser.parseManifest(manifestAndLocation.getManifest());
                bundleInfo.setUri(manifestAndLocation.getUri());
                this.addBundle(bundleInfo);
            }
            catch (ParseException parseException) {
                Message.error("Rejected " + manifestAndLocation.getUri() + ": " + parseException.getMessage());
            }
        }
    }
}

