/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.util;

import java.text.ParseException;
import org.apache.ivy.osgi.util.Version;

public class VersionRange {
    private boolean startExclusive;
    private Version startVersion;
    private boolean endExclusive;
    private Version endVersion;

    public VersionRange(String string) throws ParseException {
        if (string == null || string.length() == 0) {
            this.startExclusive = false;
            this.startVersion = new Version(0, 0, 0, null);
            this.endExclusive = true;
            this.endVersion = null;
        } else {
            new VersionRangeParser(string).parse();
        }
    }

    public VersionRange(boolean bl, Version version, boolean bl2, Version version2) {
        this.startExclusive = bl;
        this.startVersion = version;
        this.endExclusive = bl2;
        this.endVersion = version2;
    }

    public VersionRange(Version version) {
        this.startExclusive = false;
        this.startVersion = version;
        this.endExclusive = true;
        this.endVersion = null;
    }

    public String toString() {
        return (this.startExclusive ? "(" : "[") + this.startVersion + "," + (this.endVersion == null ? "" : this.endVersion.toString()) + (this.endExclusive ? ")" : "]");
    }

    public String toIvyRevision() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.startExclusive ? "(" : "[");
        stringBuffer.append(this.startVersion);
        if (this.endVersion == null) {
            stringBuffer.append(",)");
        } else if (!this.endExclusive || this.startVersion.equals(this.endVersion)) {
            stringBuffer.append(",");
            stringBuffer.append(this.endVersion.withNudgedPatch());
            stringBuffer.append(")");
        } else {
            stringBuffer.append(",");
            stringBuffer.append(this.endVersion);
            stringBuffer.append(")");
        }
        return stringBuffer.toString();
    }

    public boolean isEndExclusive() {
        return this.endExclusive;
    }

    public Version getEndVersion() {
        return this.endVersion;
    }

    public boolean isStartExclusive() {
        return this.startExclusive;
    }

    public Version getStartVersion() {
        return this.startVersion;
    }

    public boolean isClosedRange() {
        return this.startVersion.equals(this.endVersion);
    }

    public boolean contains(String string) throws ParseException {
        return this.contains(new Version(string));
    }

    public boolean contains(Version version) {
        if (this.startExclusive ? version.compareUnqualified(this.startVersion) <= 0 : version.compareUnqualified(this.startVersion) < 0) {
            return false;
        }
        if (this.endVersion == null) {
            return true;
        }
        return !(this.endExclusive ? version.compareUnqualified(this.endVersion) >= 0 : version.compareUnqualified(this.endVersion) > 0);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.endExclusive ? 1231 : 1237);
        n = 31 * n + (this.endVersion == null ? 0 : this.endVersion.hashCode());
        n = 31 * n + (this.startExclusive ? 1231 : 1237);
        n = 31 * n + (this.startVersion == null ? 0 : this.startVersion.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof VersionRange)) {
            return false;
        }
        VersionRange versionRange = (VersionRange)object;
        if (this.endExclusive != versionRange.endExclusive) {
            return false;
        }
        if (this.endVersion == null ? versionRange.endVersion != null : !this.endVersion.equals(versionRange.endVersion)) {
            return false;
        }
        if (this.startExclusive != versionRange.startExclusive) {
            return false;
        }
        return !(this.startVersion == null ? versionRange.startVersion != null : !this.startVersion.equals(versionRange.startVersion));
    }

    class VersionRangeParser {
        private final String version;
        private int length;
        private int pos = 0;
        private char c;

        VersionRangeParser(String string) {
            this.version = string;
            this.length = string.length();
        }

        void parse() throws ParseException {
            boolean bl = this.parseStart();
            VersionRange.this.startVersion = this.parseVersion();
            if (VersionRange.this.startVersion == null) {
                throw new ParseException("Expecting a number", this.pos);
            }
            if (this.parseVersionSeparator()) {
                VersionRange.this.endVersion = this.parseVersion();
                this.parseEnd();
            } else {
                if (bl) {
                    throw new ParseException("Expecting ,", this.pos);
                }
                VersionRange.this.endVersion = null;
                VersionRange.this.startExclusive = false;
                VersionRange.this.endExclusive = false;
            }
        }

        private char readNext() {
            this.c = this.pos == this.length ? (char)'\u0000' : this.version.charAt(this.pos++);
            return this.c;
        }

        private void unread() {
            if (this.pos > 0) {
                --this.pos;
            }
        }

        private boolean parseStart() {
            this.skipWhiteSpace();
            switch (this.readNext()) {
                case '[': {
                    VersionRange.this.startExclusive = false;
                    return true;
                }
                case '(': {
                    VersionRange.this.startExclusive = true;
                    return true;
                }
            }
            this.unread();
            return false;
        }

        private void skipWhiteSpace() {
            do {
                switch (this.readNext()) {
                    case ' ': {
                        break;
                    }
                    default: {
                        this.unread();
                        return;
                    }
                }
            } while (this.pos < this.length);
        }

        private Version parseVersion() {
            Integer n = this.parseNumber();
            if (n == null) {
                return null;
            }
            Integer n2 = new Integer(0);
            Integer n3 = new Integer(0);
            String string = null;
            if (this.parseNumberSeparator()) {
                n2 = this.parseNumber();
                if (n2 == null) {
                    n2 = new Integer(0);
                } else if (this.parseNumberSeparator()) {
                    n3 = this.parseNumber();
                    if (n3 == null) {
                        n3 = new Integer(0);
                    } else if (this.parseNumberSeparator()) {
                        string = this.parseQualifier();
                    }
                }
            }
            return new Version(n, n2, n3, string);
        }

        private Integer parseNumber() {
            this.skipWhiteSpace();
            Integer n = null;
            do {
                switch (this.readNext()) {
                    case '\u0000': {
                        return n;
                    }
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        n = new Integer((n == null ? 0 : n * 10) + this.c - 48);
                        break;
                    }
                    default: {
                        this.unread();
                        return n;
                    }
                }
            } while (this.pos < this.length);
            return n;
        }

        private boolean parseNumberSeparator() {
            switch (this.readNext()) {
                case '.': {
                    return true;
                }
            }
            this.unread();
            return false;
        }

        private boolean parseVersionSeparator() {
            this.skipWhiteSpace();
            switch (this.readNext()) {
                case ',': {
                    return true;
                }
            }
            this.unread();
            return false;
        }

        private String parseQualifier() {
            StringBuffer stringBuffer = new StringBuffer();
            do {
                this.readNext();
                if (!(this.c >= 'a' && this.c <= 'z' || this.c >= 'A' && this.c <= 'Z' || this.c >= '0' && this.c <= '9' || this.c == '-' || this.c == '_')) {
                    this.unread();
                    break;
                }
                stringBuffer.append(this.c);
            } while (this.pos < this.length);
            if (stringBuffer.length() == 0) {
                return null;
            }
            return stringBuffer.toString();
        }

        private void parseEnd() throws ParseException {
            this.skipWhiteSpace();
            switch (this.readNext()) {
                case ']': {
                    VersionRange.this.endExclusive = false;
                    break;
                }
                case ')': {
                    VersionRange.this.endExclusive = true;
                    break;
                }
                default: {
                    this.unread();
                    throw new ParseException("Expexting ] or )", this.pos);
                }
            }
        }
    }
}

