/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.tools.analyser;

import java.io.File;
import java.util.ArrayList;
import org.apache.ivy.core.IvyPatternHelper;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.plugins.resolver.util.FileURLLister;
import org.apache.ivy.plugins.resolver.util.ResolverHelper;
import org.apache.ivy.tools.analyser.JarModule;

public class JarModuleFinder {
    private String pattern;
    private String filePattern;

    public JarModuleFinder(String string) {
        this.pattern = "file:///" + string;
        this.filePattern = string;
    }

    public JarModule[] findJarModules() {
        ArrayList<JarModule> arrayList = new ArrayList<JarModule>();
        FileURLLister fileURLLister = new FileURLLister();
        try {
            String[] stringArray = ResolverHelper.listTokenValues(fileURLLister, this.pattern, "organisation");
            for (int i = 0; i < stringArray.length; ++i) {
                String string = IvyPatternHelper.substituteToken(this.pattern, "organisation", stringArray[i]);
                String[] stringArray2 = ResolverHelper.listTokenValues(fileURLLister, string, "module");
                for (int j = 0; j < stringArray2.length; ++j) {
                    String string2 = IvyPatternHelper.substituteToken(string, "module", stringArray2[j]);
                    String[] stringArray3 = ResolverHelper.listTokenValues(fileURLLister, string2, "revision");
                    for (int k = 0; k < stringArray3.length; ++k) {
                        File file = new File(IvyPatternHelper.substitute(this.filePattern, stringArray[i], stringArray2[j], stringArray3[k], stringArray2[j], "jar", "jar"));
                        if (!file.exists()) continue;
                        arrayList.add(new JarModule(ModuleRevisionId.newInstance(stringArray[i], stringArray2[j], stringArray3[k]), file));
                    }
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrayList.toArray(new JarModule[arrayList.size()]);
    }

    public static void main(String[] stringArray) {
        JarModule[] jarModuleArray = new JarModuleFinder("D:/temp/test2/ivyrep/[organisation]/[module]/[revision]/[artifact].[ext]").findJarModules();
        for (int i = 0; i < jarModuleArray.length; ++i) {
            System.out.println(jarModuleArray[i]);
        }
    }
}

