/*
 * Decompiled with CFR 0.152.
 */
package org.parosproxy.paros.core.scanner;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class MultipartParam {
    private final List<String> headers = new ArrayList<String>();
    private String name;
    private String fileName;
    private String content;

    public void addHeader(String headerline) throws IOException {
        this.headers.add(headerline);
        if (headerline.toLowerCase().startsWith("content-disposition:")) {
            this.extractDispositionInfo(headerline);
        }
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String value) {
        this.content = value;
    }

    public List<String> getHeaders() {
        return this.headers;
    }

    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        for (String header : this.headers) {
            result.append(header);
            result.append("\r\n");
        }
        result.append("\r\n");
        result.append(this.content);
        result.append("\r\n");
        return result.toString();
    }

    private void extractDispositionInfo(String line) throws IOException {
        String origline = line;
        line = origline.toLowerCase();
        int start = line.indexOf("content-disposition: ");
        int end = line.indexOf(";");
        if (start == -1 || end == -1) {
            throw new IOException("Content disposition corrupt: " + origline);
        }
        String disposition = line.substring(start + 21, end).trim();
        if (!disposition.equals("form-data")) {
            throw new IOException("Invalid content disposition: " + disposition);
        }
        start = line.indexOf("name=\"", end);
        end = line.indexOf("\"", start + 7);
        int startOffset = 6;
        if (start == -1 || end == -1) {
            start = line.indexOf("name=", end);
            end = line.indexOf(";", start + 6);
            if (start == -1) {
                throw new IOException("Content disposition corrupt: " + origline);
            }
            if (end == -1) {
                end = line.length();
            }
            startOffset = 5;
        }
        this.name = origline.substring(start + startOffset, end);
        String filename = null;
        String origname = null;
        start = line.indexOf("filename=\"", end + 2);
        end = line.indexOf("\"", start + 10);
        if (start != -1 && end != -1) {
            origname = filename = origline.substring(start + 10, end);
            int slash = Math.max(filename.lastIndexOf(47), filename.lastIndexOf(92));
            if (slash > -1) {
                filename = filename.substring(slash + 1);
            }
        }
        this.fileName = filename;
    }

    private static String extractContentType(String line) throws IOException {
        int end = (line = line.toLowerCase()).indexOf(";");
        if (end == -1) {
            end = line.length();
        }
        return line.substring(13, end).trim();
    }
}

