/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.extension.pscan;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXTable;
import org.parosproxy.paros.Constant;
import org.parosproxy.paros.core.scanner.Plugin;
import org.parosproxy.paros.model.Model;
import org.parosproxy.paros.view.AbstractParamPanel;
import org.parosproxy.paros.view.View;
import org.zaproxy.zap.control.AddOn;
import org.zaproxy.zap.extension.pscan.PolicyPassiveScanTableModel;
import org.zaproxy.zap.utils.DisplayUtils;
import org.zaproxy.zap.view.LayoutHelper;
import org.zaproxy.zap.view.panels.TableFilterPanel;

public class PolicyPassiveScanPanel
extends AbstractParamPanel {
    private static final long serialVersionUID = 1L;
    private JXTable tableTest = null;
    private JScrollPane jScrollPane = null;
    private PolicyPassiveScanTableModel passiveScanTableModel = null;
    private JComboBox<String> applyToThreshold = null;
    private JComboBox<String> applyToThresholdTarget = null;
    private static final int[] width = new int[]{300, 60, 100};

    public PolicyPassiveScanPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setLayout(new GridBagLayout());
        if (Model.getSingleton().getOptionsParam().getViewParam().getWmUiHandlingOption() == 0) {
            this.setSize(375, 204);
        }
        this.setName(Constant.messages.getString("pscan.options.policy.title"));
        TableFilterPanel<JXTable> passiveScannersFilterPanel = new TableFilterPanel<JXTable>(this.getTableTest());
        JPanel applyToPanel = new JPanel();
        applyToPanel.setLayout(new GridBagLayout());
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("pscan.options.policy.apply.label")), LayoutHelper.getGBC(0, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        applyToPanel.add(this.getApplyToThreshold(), LayoutHelper.getGBC(1, 0, 1, 0.0));
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("pscan.options.policy.thresholdTo.label")), LayoutHelper.getGBC(2, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        applyToPanel.add(this.getApplyToThresholdTarget(), LayoutHelper.getGBC(3, 0, 1, 0.0));
        applyToPanel.add((Component)new JLabel(Constant.messages.getString("pscan.options.policy.rules.label")), LayoutHelper.getGBC(4, 0, 1, 0.0, new Insets(2, 2, 2, 2)));
        JButton applyThresholdButton = new JButton(Constant.messages.getString("pscan.options.policy.go.button"));
        applyThresholdButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PolicyPassiveScanPanel.this.applyThreshold(PolicyPassiveScanPanel.this.strToThreshold((String)PolicyPassiveScanPanel.this.getApplyToThreshold().getSelectedItem()), (String)PolicyPassiveScanPanel.this.getApplyToThresholdTarget().getSelectedItem());
                PolicyPassiveScanPanel.this.getPassiveScanTableModel().fireTableDataChanged();
            }
        });
        applyToPanel.add((Component)applyThresholdButton, LayoutHelper.getGBC(5, 0, 1, 0.0));
        applyToPanel.add((Component)new JLabel(""), LayoutHelper.getGBC(6, 0, 1, 1.0));
        this.add((Component)applyToPanel, LayoutHelper.getGBC(0, 0, 3, 0.0, 0.0, 1, new Insets(0, 0, 0, 0)));
        this.add(passiveScannersFilterPanel, LayoutHelper.getGBC(0, 1, 1, 1.0, 0.0, 1, 18, new Insets(0, 0, 0, 0)));
        this.add((Component)this.getJScrollPane(), LayoutHelper.getGBC(0, 2, 1, 1.0, 1.0, 1, 18, new Insets(0, 0, 0, 0)));
    }

    private JComboBox<String> getApplyToThreshold() {
        if (this.applyToThreshold == null) {
            this.applyToThreshold = new JComboBox();
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.off"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.low"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.medium"));
            this.applyToThreshold.addItem(Constant.messages.getString("ascan.options.level.high"));
            this.applyToThreshold.setSelectedItem(Constant.messages.getString("ascan.options.level.medium"));
        }
        return this.applyToThreshold;
    }

    private JComboBox<String> getApplyToThresholdTarget() {
        if (this.applyToThresholdTarget == null) {
            this.applyToThresholdTarget = new JComboBox();
            this.applyToThresholdTarget.addItem(Constant.messages.getString("ascan.policy.table.quality.all"));
            View view = View.getSingleton();
            this.applyToThresholdTarget.addItem(view.getStatusUI(AddOn.Status.release).toString());
            this.applyToThresholdTarget.addItem(view.getStatusUI(AddOn.Status.beta).toString());
            this.applyToThresholdTarget.addItem(view.getStatusUI(AddOn.Status.alpha).toString());
        }
        return this.applyToThresholdTarget;
    }

    private Plugin.AlertThreshold strToThreshold(String str) {
        if (str.equals(Constant.messages.getString("ascan.options.level.low"))) {
            return Plugin.AlertThreshold.LOW;
        }
        if (str.equals(Constant.messages.getString("ascan.options.level.medium"))) {
            return Plugin.AlertThreshold.MEDIUM;
        }
        if (str.equals(Constant.messages.getString("ascan.options.level.high"))) {
            return Plugin.AlertThreshold.HIGH;
        }
        return Plugin.AlertThreshold.OFF;
    }

    private void applyThreshold(Plugin.AlertThreshold threshold, String target) {
        if (target.equals(Constant.messages.getString("ascan.policy.table.quality.all"))) {
            this.getPassiveScanTableModel().applyThresholdToAll(threshold);
        } else {
            this.getPassiveScanTableModel().applyThreshold(threshold, target);
        }
    }

    private JXTable getTableTest() {
        if (this.tableTest == null) {
            this.tableTest = new JXTable();
            this.tableTest.setModel((TableModel)this.getPassiveScanTableModel());
            this.tableTest.setRowHeight(DisplayUtils.getScaledSize(18));
            this.tableTest.setIntercellSpacing(new Dimension(1, 1));
            this.tableTest.setAutoCreateRowSorter(true);
            ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>(1);
            sortKeys.add(new RowSorter.SortKey(0, SortOrder.ASCENDING));
            this.tableTest.getRowSorter().setSortKeys(sortKeys);
            for (int i = 0; i < this.tableTest.getColumnCount() - 1; ++i) {
                TableColumn column = this.tableTest.getColumnModel().getColumn(i);
                column.setPreferredWidth(width[i]);
            }
            JComboBox<String> jcb1 = new JComboBox<String>();
            for (Plugin.AlertThreshold level : Plugin.AlertThreshold.values()) {
                jcb1.addItem(Constant.messages.getString("ascan.policy.level." + level.name().toLowerCase()));
            }
            this.tableTest.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(jcb1));
        }
        return this.tableTest;
    }

    @Override
    public void initParam(Object obj) {
        this.getPassiveScanTableModel().reset();
    }

    @Override
    public void saveParam(Object obj) throws Exception {
        this.getPassiveScanTableModel().persistChanges();
    }

    @Override
    public void reset() {
        this.getPassiveScanTableModel().applyThresholdToAll(Plugin.AlertThreshold.MEDIUM);
        this.getPassiveScanTableModel().persistChanges();
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView((Component)this.getTableTest());
            this.jScrollPane.setBorder(BorderFactory.createEtchedBorder(0));
        }
        return this.jScrollPane;
    }

    public PolicyPassiveScanTableModel getPassiveScanTableModel() {
        if (this.passiveScanTableModel == null) {
            this.passiveScanTableModel = new PolicyPassiveScanTableModel();
        }
        return this.passiveScanTableModel;
    }

    public void setPassiveScanTableModel(PolicyPassiveScanTableModel categoryTableModel) {
        this.passiveScanTableModel = categoryTableModel;
    }

    @Override
    public String getHelpIndex() {
        return "ui.dialogs.options.pscanrules";
    }
}

