/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jruby.org.objectweb.asm.MethodVisitor;
import org.jruby.org.objectweb.asm.tree.AbstractInsnNode;
import org.jruby.org.objectweb.asm.tree.LabelNode;
import org.jruby.org.objectweb.asm.tree.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameNode
extends AbstractInsnNode {
    public int type;
    public List<Object> local;
    public List<Object> stack;

    private FrameNode() {
        super(-1);
    }

    public FrameNode(int type2, int nLocal, Object[] local2, int nStack, Object[] stack) {
        super(-1);
        this.type = type2;
        switch (type2) {
            case -1: 
            case 0: {
                this.local = Util.asArrayList(nLocal, local2);
                this.stack = Util.asArrayList(nStack, stack);
                break;
            }
            case 1: {
                this.local = Util.asArrayList(nLocal, local2);
                break;
            }
            case 2: {
                this.local = Util.asArrayList(nLocal);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.stack = Util.asArrayList(1, stack);
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public int getType() {
        return 14;
    }

    @Override
    public void accept(MethodVisitor methodVisitor) {
        switch (this.type) {
            case -1: 
            case 0: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), this.stack.size(), FrameNode.asArray(this.stack));
                break;
            }
            case 1: {
                methodVisitor.visitFrame(this.type, this.local.size(), FrameNode.asArray(this.local), 0, null);
                break;
            }
            case 2: {
                methodVisitor.visitFrame(this.type, this.local.size(), null, 0, null);
                break;
            }
            case 3: {
                methodVisitor.visitFrame(this.type, 0, null, 0, null);
                break;
            }
            case 4: {
                methodVisitor.visitFrame(this.type, 0, null, 1, FrameNode.asArray(this.stack));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    @Override
    public AbstractInsnNode clone(Map<LabelNode, LabelNode> clonedLabels) {
        int i2;
        int n;
        FrameNode clone2 = new FrameNode();
        clone2.type = this.type;
        if (this.local != null) {
            clone2.local = new ArrayList<Object>();
            n = this.local.size();
            for (i2 = 0; i2 < n; ++i2) {
                Object localElement = this.local.get(i2);
                if (localElement instanceof LabelNode) {
                    localElement = clonedLabels.get(localElement);
                }
                clone2.local.add(localElement);
            }
        }
        if (this.stack != null) {
            clone2.stack = new ArrayList<Object>();
            n = this.stack.size();
            for (i2 = 0; i2 < n; ++i2) {
                Object stackElement = this.stack.get(i2);
                if (stackElement instanceof LabelNode) {
                    stackElement = clonedLabels.get(stackElement);
                }
                clone2.stack.add(stackElement);
            }
        }
        return clone2;
    }

    private static Object[] asArray(List<Object> list2) {
        Object[] array2 = new Object[list2.size()];
        int n = array2.length;
        for (int i2 = 0; i2 < n; ++i2) {
            Object o = list2.get(i2);
            if (o instanceof LabelNode) {
                o = ((LabelNode)o).getLabel();
            }
            array2[i2] = o;
        }
        return array2;
    }
}

