// **********************************************************************
//
// Copyright (c) 2003-2018 ZeroC, Inc. All rights reserved.
//
// This copy of Ice is licensed to you under the terms described in the
// ICE_LICENSE file included in this distribution.
//
// **********************************************************************
//
// Ice version 3.7.1
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package IceGrid;

/**
 * The IceGrid administrative interface.
 * <p class="Warning">Allowing access to this interface
 * is a security risk! Please see the IceGrid documentation
 * for further information.
 *
 **/
public interface AdminPrx extends Ice.ObjectPrx
{
    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     **/
    public void addApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, Ice.Callback cb);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, Callback_Admin_addApplication cb);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context, Callback_Admin_addApplication cb);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor,
                                                IceInternal.Functional_VoidCallback responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor,
                                                IceInternal.Functional_VoidCallback responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_VoidCallback responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add an application to IceGrid.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addApplication(ApplicationDescriptor descriptor,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_VoidCallback responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add an application to IceGrid.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     **/
    public void end_addApplication(Ice.AsyncResult result)
        throws AccessDeniedException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void syncApplication(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, Ice.Callback cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, Callback_Admin_syncApplication cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor, java.util.Map<String, String> context, Callback_Admin_syncApplication cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor,
                                                 IceInternal.Functional_VoidCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor,
                                                 IceInternal.Functional_VoidCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_VoidCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplication(ApplicationDescriptor descriptor,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_VoidCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void end_syncApplication(Ice.AsyncResult result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void updateApplication(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, Ice.Callback cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, Callback_Admin_updateApplication cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context, Callback_Admin_updateApplication cb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplication(ApplicationUpdateDescriptor descriptor,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Update a deployed application with the given update application
     * descriptor.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void end_updateApplication(Ice.AsyncResult result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void syncApplicationWithoutRestart(ApplicationDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> context);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, Ice.Callback cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, Callback_Admin_syncApplicationWithoutRestart cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor, java.util.Map<String, String> context, Callback_Admin_syncApplicationWithoutRestart cb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor,
                                                               IceInternal.Functional_VoidCallback responseCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor,
                                                               IceInternal.Functional_VoidCallback responseCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor,
                                                               java.util.Map<String, String> context,
                                                               IceInternal.Functional_VoidCallback responseCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_syncApplicationWithoutRestart(ApplicationDescriptor descriptor,
                                                               java.util.Map<String, String> context,
                                                               IceInternal.Functional_VoidCallback responseCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Synchronize a deployed application with the given application
     * descriptor. This operation will replace the current descriptor
     * with this new descriptor only if no server restarts are
     * necessary for the update of the application. If some servers
     * need to be restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void end_syncApplicationWithoutRestart(Ice.AsyncResult result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, Ice.Callback cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, Callback_Admin_updateApplicationWithoutRestart cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor, java.util.Map<String, String> context, Callback_Admin_updateApplicationWithoutRestart cb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor,
                                                                 java.util.Map<String, String> context,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param descriptor The update descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateApplicationWithoutRestart(ApplicationUpdateDescriptor descriptor,
                                                                 java.util.Map<String, String> context,
                                                                 IceInternal.Functional_VoidCallback responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Update a deployed application with the given update application
     * descriptor only if no server restarts are necessary for the
     * update of the application. If some servers need to be
     * restarted, the synchronization is rejected with a
     * DeploymentException.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void end_updateApplicationWithoutRestart(Ice.AsyncResult result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void removeApplication(String name)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void removeApplication(String name, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> context);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, Ice.Callback cb);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, Callback_Admin_removeApplication cb);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name, java.util.Map<String, String> context, Callback_Admin_removeApplication cb);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Remove an application from IceGrid.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeApplication(String name,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Remove an application from IceGrid.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void end_removeApplication(Ice.AsyncResult result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if server instantiation
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void instantiateServer(String application, String node, ServerInstanceDescriptor desc)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if server instantiation
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> context)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> context);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, Ice.Callback cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, Callback_Admin_instantiateServer cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application, String node, ServerInstanceDescriptor desc, java.util.Map<String, String> context, Callback_Admin_instantiateServer cb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application,
                                                   String node,
                                                   ServerInstanceDescriptor desc,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application,
                                                   String node,
                                                   ServerInstanceDescriptor desc,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application,
                                                   String node,
                                                   ServerInstanceDescriptor desc,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param application The application name.
     *
     * @param node The name of the node where the server will be
     * deployed.
     *
     * @param desc The descriptor of the server instance to deploy.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_instantiateServer(String application,
                                                   String node,
                                                   ServerInstanceDescriptor desc,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Instantiate a server template from an application on the given
     * node.
     *
     * @param result The asynchronous result object.
     * @throws AccessDeniedException Raised if the session doesn't
     * hold the exclusive lock or if another session is holding the
     * lock.
     *
     * @throws DeploymentException Raised if server instantiation
     * failed.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public void end_instantiateServer(Ice.AsyncResult result)
        throws AccessDeniedException,
               ApplicationNotExistException,
               DeploymentException;

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @throws PatchException Raised if the patch failed.
     *
     **/
    public void patchApplication(String name, boolean shutdown)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @throws PatchException Raised if the patch failed.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void patchApplication(String name, boolean shutdown, java.util.Map<String, String> context)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> context);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, Ice.Callback cb);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, Callback_Admin_patchApplication cb);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name, boolean shutdown, java.util.Map<String, String> context, Callback_Admin_patchApplication cb);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name,
                                                  boolean shutdown,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name,
                                                  boolean shutdown,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name,
                                                  boolean shutdown,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Patch the given application data.
     *
     * @param name The application name.
     *
     * @param shutdown If true, the servers depending on the data to
     * patch will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchApplication(String name,
                                                  boolean shutdown,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Patch the given application data.
     *
     * @param result The asynchronous result object.
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     * @throws PatchException Raised if the patch failed.
     *
     **/
    public void end_patchApplication(Ice.AsyncResult result)
        throws ApplicationNotExistException,
               PatchException;

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @return The application descriptor.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public ApplicationInfo getApplicationInfo(String name)
        throws ApplicationNotExistException;

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @return The application descriptor.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public ApplicationInfo getApplicationInfo(String name, java.util.Map<String, String> context)
        throws ApplicationNotExistException;

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> context);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, Ice.Callback cb);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, Callback_Admin_getApplicationInfo cb);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name, java.util.Map<String, String> context, Callback_Admin_getApplicationInfo cb);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name,
                                                    IceInternal.Functional_GenericCallback1<ApplicationInfo> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name,
                                                    IceInternal.Functional_GenericCallback1<ApplicationInfo> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<ApplicationInfo> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get an application descriptor.
     *
     * @param name The application name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getApplicationInfo(String name,
                                                    java.util.Map<String, String> context,
                                                    IceInternal.Functional_GenericCallback1<ApplicationInfo> responseCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                    IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                    IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get an application descriptor.
     *
     * @param result The asynchronous result object.
     * @return The application descriptor.
     *
     * @throws ApplicationNotExistException Raised if the application
     * doesn't exist.
     *
     **/
    public ApplicationInfo end_getApplicationInfo(Ice.AsyncResult result)
        throws ApplicationNotExistException;

    /**
     * Get the default application descriptor.
     *
     * @return The default application descriptor.
     *
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     *
     **/
    public ApplicationDescriptor getDefaultApplicationDescriptor()
        throws DeploymentException;

    /**
     * Get the default application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @return The default application descriptor.
     *
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     *
     **/
    public ApplicationDescriptor getDefaultApplicationDescriptor(java.util.Map<String, String> context)
        throws DeploymentException;

    /**
     * Get the default application descriptor.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor();

    /**
     * Get the default application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> context);

    /**
     * Get the default application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(Ice.Callback cb);

    /**
     * Get the default application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the default application descriptor.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(Callback_Admin_getDefaultApplicationDescriptor cb);

    /**
     * Get the default application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> context, Callback_Admin_getDefaultApplicationDescriptor cb);

    /**
     * Get the default application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the default application descriptor.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the default application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> context,
                                                                 IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the default application descriptor.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getDefaultApplicationDescriptor(java.util.Map<String, String> context,
                                                                 IceInternal.Functional_GenericCallback1<ApplicationDescriptor> responseCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the default application descriptor.
     *
     * @param result The asynchronous result object.
     * @return The default application descriptor.
     *
     * @throws DeploymentException Raised if the default application
     * descriptor can't be accessed or is invalid.
     *
     **/
    public ApplicationDescriptor end_getDefaultApplicationDescriptor(Ice.AsyncResult result)
        throws DeploymentException;

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @return The application names.
     *
     **/
    public String[] getAllApplicationNames();

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @return The application names.
     *
     **/
    public String[] getAllApplicationNames(java.util.Map<String, String> context);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames();

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> context);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(Ice.Callback cb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(Callback_Admin_getAllApplicationNames cb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> context, Callback_Admin_getAllApplicationNames cb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> context,
                                                        IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllApplicationNames(java.util.Map<String, String> context,
                                                        IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the IceGrid applications currently registered.
     *
     * @param result The asynchronous result object.
     * @return The application names.
     *
     **/
    public String[] end_getAllApplicationNames(Ice.AsyncResult result);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @return The server information.
     *
     **/
    public ServerInfo getServerInfo(String id)
        throws ServerNotExistException;

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @param context The Context map to send with the invocation.
     * @return The server information.
     *
     **/
    public ServerInfo getServerInfo(String id, java.util.Map<String, String> context)
        throws ServerNotExistException;

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> context);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, Ice.Callback cb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, Callback_Admin_getServerInfo cb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id, java.util.Map<String, String> context, Callback_Admin_getServerInfo cb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id,
                                               IceInternal.Functional_GenericCallback1<ServerInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id,
                                               IceInternal.Functional_GenericCallback1<ServerInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<ServerInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerInfo(String id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<ServerInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the server information for the server with the given id.
     *
     * @param result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @return The server information.
     *
     **/
    public ServerInfo end_getServerInfo(Ice.AsyncResult result)
        throws ServerNotExistException;

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @return The server state.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public ServerState getServerState(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The server state.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public ServerState getServerState(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> context);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, Ice.Callback cb);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, Callback_Admin_getServerState cb);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id, java.util.Map<String, String> context, Callback_Admin_getServerState cb);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id,
                                                IceInternal.Functional_GenericCallback1<ServerState> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id,
                                                IceInternal.Functional_GenericCallback1<ServerState> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<ServerState> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a server's state.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerState(String id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<ServerState> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a server's state.
     *
     * @param result The asynchronous result object.
     * @return The server state.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public ServerState end_getServerState(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @return The server's process id.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public int getServerPid(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The server's process id.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public int getServerPid(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> context);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, Ice.Callback cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, Callback_Admin_getServerPid cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id, java.util.Map<String, String> context, Callback_Admin_getServerPid cb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id,
                                              IceInternal.Functional_IntCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id,
                                              IceInternal.Functional_IntCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_IntCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerPid(String id,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_IntCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a server's system process id. The process id is operating
     * system dependent.
     *
     * @param result The asynchronous result object.
     * @return The server's process id.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public int end_getServerPid(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @return The category for server admin objects.
     *
     **/
    public String getServerAdminCategory();

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param context The Context map to send with the invocation.
     * @return The category for server admin objects.
     *
     **/
    public String getServerAdminCategory(java.util.Map<String, String> context);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory();

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> context);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(Ice.Callback cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(Callback_Admin_getServerAdminCategory cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> context, Callback_Admin_getServerAdminCategory cb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(IceInternal.Functional_GenericCallback1<String> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(IceInternal.Functional_GenericCallback1<String> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> context,
                                                        IceInternal.Functional_GenericCallback1<String> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdminCategory(java.util.Map<String, String> context,
                                                        IceInternal.Functional_GenericCallback1<String> responseCb,
                                                        IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                        IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the category for server admin objects. You can manufacture a server admin
     * proxy from the admin proxy by changing its identity: use the server ID as name
     * and the returned category as category.
     *
     * @param result The asynchronous result object.
     * @return The category for server admin objects.
     *
     **/
    public String end_getServerAdminCategory(Ice.AsyncResult result);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @return A proxy to the server's admin object
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public Ice.ObjectPrx getServerAdmin(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy to the server's admin object
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public Ice.ObjectPrx getServerAdmin(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> context);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, Ice.Callback cb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, Callback_Admin_getServerAdmin cb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id, java.util.Map<String, String> context, Callback_Admin_getServerAdmin cb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getServerAdmin(String id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to the server's admin object.
     *
     * @param result The asynchronous result object.
     * @return A proxy to the server's admin object
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public Ice.ObjectPrx end_getServerAdmin(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public void enableServer(String id, boolean enabled)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void enableServer(String id, boolean enabled, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> context);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, Ice.Callback cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, Callback_Admin_enableServer cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id, boolean enabled, java.util.Map<String, String> context, Callback_Admin_enableServer cb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id,
                                              boolean enabled,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id,
                                              boolean enabled,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id,
                                              boolean enabled,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param id The server id.
     *
     * @param enabled True to enable the server, false to disable it.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_enableServer(String id,
                                              boolean enabled,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Enable or disable a server. A disabled server can't be started
     * on demand or administratively. The enable state of the server
     * is not persistent: if the node is shut down and restarted, the
     * server will be enabled by default.
     *
     * @param result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public void end_enableServer(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @return True if the server is enabled.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public boolean isServerEnabled(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return True if the server is enabled.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public boolean isServerEnabled(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> context);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, Ice.Callback cb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, Callback_Admin_isServerEnabled cb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id, java.util.Map<String, String> context, Callback_Admin_isServerEnabled cb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id,
                                                 IceInternal.Functional_BoolCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id,
                                                 IceInternal.Functional_BoolCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_BoolCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_isServerEnabled(String id,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_BoolCallback responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Check if the server is enabled or disabled.
     *
     * @param result The asynchronous result object.
     * @return True if the server is enabled.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public boolean end_isServerEnabled(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public void startServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void startServer(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> context);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, Ice.Callback cb);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, Callback_Admin_startServer cb);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id, java.util.Map<String, String> context, Callback_Admin_startServer cb);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Start a server and wait for its activation.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_startServer(String id,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Start a server and wait for its activation.
     *
     * @param result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws ServerStartException Raised if the server couldn't be
     * started.
     *
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public void end_startServer(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStartException;

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public void stopServer(String id)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void stopServer(String id, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> context);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, Ice.Callback cb);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, Callback_Admin_stopServer cb);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id, java.util.Map<String, String> context, Callback_Admin_stopServer cb);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                            IceInternal.Functional_BoolCallback sentCb);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id,
                                            java.util.Map<String, String> context,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Stop a server.
     *
     * @param id The server id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_stopServer(String id,
                                            java.util.Map<String, String> context,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                            IceInternal.Functional_BoolCallback sentCb);

    /**
     * Stop a server.
     *
     * @param result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws ServerStopException Raised if the server couldn't be
     * stopped.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     **/
    public void end_stopServer(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               ServerNotExistException,
               ServerStopException;

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @throws PatchException Raised if the patch failed.
     *
     **/
    public void patchServer(String id, boolean shutdown)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @throws PatchException Raised if the patch failed.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void patchServer(String id, boolean shutdown, java.util.Map<String, String> context)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> context);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, Ice.Callback cb);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, Callback_Admin_patchServer cb);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id, boolean shutdown, java.util.Map<String, String> context, Callback_Admin_patchServer cb);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id,
                                             boolean shutdown,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id,
                                             boolean shutdown,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id,
                                             boolean shutdown,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Patch a server.
     *
     * @param id The server id.
     *
     * @param shutdown If true, servers depending on the data to patch
     * will be shut down if necessary.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_patchServer(String id,
                                             boolean shutdown,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_VoidCallback responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Patch a server.
     *
     * @param result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @throws PatchException Raised if the patch failed.
     *
     **/
    public void end_patchServer(Ice.AsyncResult result)
        throws DeploymentException,
               NodeUnreachableException,
               PatchException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @throws BadSignalException Raised if the signal is not recognized
     * by the target server.
     *
     **/
    public void sendSignal(String id, String signal)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @throws BadSignalException Raised if the signal is not recognized
     * by the target server.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void sendSignal(String id, String signal, java.util.Map<String, String> context)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> context);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, Ice.Callback cb);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, Callback_Admin_sendSignal cb);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id, String signal, java.util.Map<String, String> context, Callback_Admin_sendSignal cb);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id,
                                            String signal,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id,
                                            String signal,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                            IceInternal.Functional_BoolCallback sentCb);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id,
                                            String signal,
                                            java.util.Map<String, String> context,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Send signal to a server.
     *
     * @param id The server id.
     *
     * @param signal The signal, for example SIGTERM or 15.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_sendSignal(String id,
                                            String signal,
                                            java.util.Map<String, String> context,
                                            IceInternal.Functional_VoidCallback responseCb,
                                            IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                            IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                            IceInternal.Functional_BoolCallback sentCb);

    /**
     * Send signal to a server.
     *
     * @param result The asynchronous result object.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     *
     * @throws BadSignalException Raised if the signal is not recognized
     * by the target server.
     *
     **/
    public void end_sendSignal(Ice.AsyncResult result)
        throws BadSignalException,
               DeploymentException,
               NodeUnreachableException,
               ServerNotExistException;

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @return The server ids.
     *
     **/
    public String[] getAllServerIds();

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @return The server ids.
     *
     **/
    public String[] getAllServerIds(java.util.Map<String, String> context);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds();

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> context);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(Ice.Callback cb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(Callback_Admin_getAllServerIds cb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> context, Callback_Admin_getAllServerIds cb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllServerIds(java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the server ids registered with IceGrid.
     *
     * @param result The asynchronous result object.
     * @return The server ids.
     *
     **/
    public String[] end_getAllServerIds(Ice.AsyncResult result);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     *
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     *
     **/
    public AdapterInfo[] getAdapterInfo(String id)
        throws AdapterNotExistException;

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     *
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     *
     **/
    public AdapterInfo[] getAdapterInfo(String id, java.util.Map<String, String> context)
        throws AdapterNotExistException;

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> context);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, Ice.Callback cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, Callback_Admin_getAdapterInfo cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id, java.util.Map<String, String> context, Callback_Admin_getAdapterInfo cb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id,
                                                IceInternal.Functional_GenericCallback1<AdapterInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id,
                                                IceInternal.Functional_GenericCallback1<AdapterInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<AdapterInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param id The adapter id.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAdapterInfo(String id,
                                                java.util.Map<String, String> context,
                                                IceInternal.Functional_GenericCallback1<AdapterInfo[]> responseCb,
                                                IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the adapter information for the replica group or adapter
     * with the given id.
     *
     * @param result The asynchronous result object.
     * @return A sequence of adapter information structures. If the
     * given id refers to an adapter, this sequence will contain only
     * one element. If the given id refers to a replica group, the
     * sequence will contain the adapter information of each member of
     * the replica group.
     *
     * @throws AdapterNotExistException Raised if the adapter or
     * replica group doesn't exist.
     *
     **/
    public AdapterInfo[] end_getAdapterInfo(Ice.AsyncResult result)
        throws AdapterNotExistException;

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     **/
    public void removeAdapter(String id)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void removeAdapter(String id, java.util.Map<String, String> context)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> context);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, Ice.Callback cb);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, Callback_Admin_removeAdapter cb);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id, java.util.Map<String, String> context, Callback_Admin_removeAdapter cb);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Remove the adapter with the given id.
     *
     * @param id The adapter id.
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeAdapter(String id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_VoidCallback responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Remove the adapter with the given id.
     *
     * @param result The asynchronous result object.
     * @throws AdapterNotExistException Raised if the adapter doesn't
     * exist.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     **/
    public void end_removeAdapter(Ice.AsyncResult result)
        throws AdapterNotExistException,
               DeploymentException;

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @return The adapter ids.
     *
     **/
    public String[] getAllAdapterIds();

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @return The adapter ids.
     *
     **/
    public String[] getAllAdapterIds(java.util.Map<String, String> context);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds();

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> context);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(Ice.Callback cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(Callback_Admin_getAllAdapterIds cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> context, Callback_Admin_getAllAdapterIds cb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllAdapterIds(java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the adapter ids registered with IceGrid.
     *
     * @param result The asynchronous result object.
     * @return The adapter ids.
     *
     **/
    public String[] end_getAllAdapterIds(Ice.AsyncResult result);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     *
     **/
    public void addObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void addObject(Ice.ObjectPrx obj, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> context);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, Ice.Callback cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, Callback_Admin_addObject cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj, java.util.Map<String, String> context, Callback_Admin_addObject cb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj,
                                           java.util.Map<String, String> context,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param obj The object to be added to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObject(Ice.ObjectPrx obj,
                                           java.util.Map<String, String> context,
                                           IceInternal.Functional_VoidCallback responseCb,
                                           IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                           IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                           IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add an object to the object registry. IceGrid will get the
     * object type by calling <tt>ice_id</tt> on the given proxy. The object
     * must be reachable.
     *
     * @param result The asynchronous result object.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     * @throws DeploymentException Raised if the object can't be
     * added. This might be raised if the invocation on the proxy to
     * get the object type failed.
     *
     **/
    public void end_addObject(Ice.AsyncResult result)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     *
     **/
    public void updateObject(Ice.ObjectPrx obj)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> context);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, Ice.Callback cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, Callback_Admin_updateObject cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj, java.util.Map<String, String> context, Callback_Admin_updateObject cb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param obj The object to be updated to the registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_updateObject(Ice.ObjectPrx obj,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Update an object in the object registry. Only objects added
     * with this interface can be updated with this operation. Objects
     * added with deployment descriptors should be updated with the
     * deployment mechanism.
     *
     * @param result The asynchronous result object.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * updated. This might happen if the object was added with a
     * deployment descriptor.
     *
     **/
    public void end_updateObject(Ice.AsyncResult result)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     **/
    public void addObjectWithType(Ice.ObjectPrx obj, String type)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> context);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, Ice.Callback cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, Callback_Admin_addObjectWithType cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj, String type, java.util.Map<String, String> context, Callback_Admin_addObjectWithType cb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj,
                                                   String type,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj,
                                                   String type,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj,
                                                   String type,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param obj The object to be added to the registry.
     *
     * @param type The object type.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_addObjectWithType(Ice.ObjectPrx obj,
                                                   String type,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_VoidCallback responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Add an object to the object registry and explicitly specify
     * its type.
     *
     * @param result The asynchronous result object.
     * @throws ObjectExistsException Raised if the object is already
     * registered.
     *
     * @throws DeploymentException Raised if application deployment failed.
     *
     **/
    public void end_addObjectWithType(Ice.AsyncResult result)
        throws DeploymentException,
               ObjectExistsException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     *
     **/
    public void removeObject(Ice.Identity id)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void removeObject(Ice.Identity id, java.util.Map<String, String> context)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> context);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, Ice.Callback cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, Callback_Admin_removeObject cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id, java.util.Map<String, String> context, Callback_Admin_removeObject cb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param id The identity of the object to be removed from the
     * registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_removeObject(Ice.Identity id,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Remove an object from the object registry. Only objects added
     * with this interface can be removed with this operation. Objects
     * added with deployment descriptors should be removed with the
     * deployment mechanism.
     *
     * @param result The asynchronous result object.
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     * @throws DeploymentException Raised if the object can't be
     * removed. This might happen if the object was added with a
     * deployment descriptor.
     *
     **/
    public void end_removeObject(Ice.AsyncResult result)
        throws DeploymentException,
               ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @return The object info.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     **/
    public ObjectInfo getObjectInfo(Ice.Identity id)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param context The Context map to send with the invocation.
     * @return The object info.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     **/
    public ObjectInfo getObjectInfo(Ice.Identity id, java.util.Map<String, String> context)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> context);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, Ice.Callback cb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, Callback_Admin_getObjectInfo cb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id, java.util.Map<String, String> context, Callback_Admin_getObjectInfo cb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id,
                                               IceInternal.Functional_GenericCallback1<ObjectInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id,
                                               IceInternal.Functional_GenericCallback1<ObjectInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<ObjectInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param id The identity of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfo(Ice.Identity id,
                                               java.util.Map<String, String> context,
                                               IceInternal.Functional_GenericCallback1<ObjectInfo> responseCb,
                                               IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                               IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                               IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the object info for the object with the given identity.
     *
     * @param result The asynchronous result object.
     * @return The object info.
     *
     * @throws ObjectNotRegisteredException Raised if the object isn't
     * registered with the registry.
     *
     **/
    public ObjectInfo end_getObjectInfo(Ice.AsyncResult result)
        throws ObjectNotRegisteredException;

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @return The object infos.
     *
     **/
    public ObjectInfo[] getObjectInfosByType(String type);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @return The object infos.
     *
     **/
    public ObjectInfo[] getObjectInfosByType(String type, java.util.Map<String, String> context);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> context);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, Ice.Callback cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, Callback_Admin_getObjectInfosByType cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type, java.util.Map<String, String> context, Callback_Admin_getObjectInfosByType cb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type,
                                                      IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type,
                                                      IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param type The type of the object.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getObjectInfosByType(String type,
                                                      java.util.Map<String, String> context,
                                                      IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                      IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                      IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the object info of all the registered objects with the
     * given type.
     *
     * @param result The asynchronous result object.
     * @return The object infos.
     *
     **/
    public ObjectInfo[] end_getObjectInfosByType(Ice.AsyncResult result);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @return All the object infos with a stringified identity
     * matching the given expression.
     *
     **/
    public ObjectInfo[] getAllObjectInfos(String expr);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param context The Context map to send with the invocation.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     *
     **/
    public ObjectInfo[] getAllObjectInfos(String expr, java.util.Map<String, String> context);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> context);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, Ice.Callback cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, Callback_Admin_getAllObjectInfos cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr, java.util.Map<String, String> context, Callback_Admin_getAllObjectInfos cb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr,
                                                   IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr,
                                                   IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param expr The expression to match against the stringified
     * identities of registered objects. The expression may contain
     * a trailing wildcard (<tt>*</tt>) character.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllObjectInfos(String expr,
                                                   java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<ObjectInfo[]> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the object info of all the registered objects whose stringified
     * identities match the given expression.
     *
     * @param result The asynchronous result object.
     * @return All the object infos with a stringified identity
     * matching the given expression.
     *
     **/
    public ObjectInfo[] end_getAllObjectInfos(Ice.AsyncResult result);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @return true if the node ping succeeded, false otherwise.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     **/
    public boolean pingNode(String name)
        throws NodeNotExistException;

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return true if the node ping succeeded, false otherwise.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     **/
    public boolean pingNode(String name, java.util.Map<String, String> context)
        throws NodeNotExistException;

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> context);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, Ice.Callback cb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, Callback_Admin_pingNode cb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name, java.util.Map<String, String> context, Callback_Admin_pingNode cb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name,
                                          IceInternal.Functional_BoolCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name,
                                          IceInternal.Functional_BoolCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name,
                                          java.util.Map<String, String> context,
                                          IceInternal.Functional_BoolCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingNode(String name,
                                          java.util.Map<String, String> context,
                                          IceInternal.Functional_BoolCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Ping an IceGrid node to see if it is active.
     *
     * @param result The asynchronous result object.
     * @return true if the node ping succeeded, false otherwise.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     **/
    public boolean end_pingNode(Ice.AsyncResult result)
        throws NodeNotExistException;

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @return The node load information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public LoadInfo getNodeLoad(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The node load information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public LoadInfo getNodeLoad(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> context);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, Ice.Callback cb);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, Callback_Admin_getNodeLoad cb);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name, java.util.Map<String, String> context, Callback_Admin_getNodeLoad cb);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name,
                                             IceInternal.Functional_GenericCallback1<LoadInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name,
                                             IceInternal.Functional_GenericCallback1<LoadInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<LoadInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the load averages of the node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeLoad(String name,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<LoadInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the load averages of the node.
     *
     * @param result The asynchronous result object.
     * @return The node load information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public LoadInfo end_getNodeLoad(Ice.AsyncResult result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @return The node information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public NodeInfo getNodeInfo(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The node information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public NodeInfo getNodeInfo(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> context);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, Ice.Callback cb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, Callback_Admin_getNodeInfo cb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name, java.util.Map<String, String> context, Callback_Admin_getNodeInfo cb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name,
                                             IceInternal.Functional_GenericCallback1<NodeInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name,
                                             IceInternal.Functional_GenericCallback1<NodeInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<NodeInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeInfo(String name,
                                             java.util.Map<String, String> context,
                                             IceInternal.Functional_GenericCallback1<NodeInfo> responseCb,
                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the node information for the node with the given name.
     *
     * @param result The asynchronous result object.
     * @return The node information.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public NodeInfo end_getNodeInfo(Ice.AsyncResult result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @return A proxy to the IceGrid node's admin object
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public Ice.ObjectPrx getNodeAdmin(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid node's admin object
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public Ice.ObjectPrx getNodeAdmin(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name, java.util.Map<String, String> context);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name, Ice.Callback cb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name, Callback_Admin_getNodeAdmin cb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name, java.util.Map<String, String> context, Callback_Admin_getNodeAdmin cb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name,
                                              IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name,
                                              IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param name The IceGrid node name
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeAdmin(String name,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to the IceGrid node's admin object.
     *
     * @param result The asynchronous result object.
     * @return A proxy to the IceGrid node's admin object
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public Ice.ObjectPrx end_getNodeAdmin(Ice.AsyncResult result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public int getNodeProcessorSocketCount(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public int getNodeProcessorSocketCount(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> context);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, Ice.Callback cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, Callback_Admin_getNodeProcessorSocketCount cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name, java.util.Map<String, String> context, Callback_Admin_getNodeProcessorSocketCount cb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name,
                                                             IceInternal.Functional_IntCallback responseCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name,
                                                             IceInternal.Functional_IntCallback responseCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name,
                                                             java.util.Map<String, String> context,
                                                             IceInternal.Functional_IntCallback responseCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeProcessorSocketCount(String name,
                                                             java.util.Map<String, String> context,
                                                             IceInternal.Functional_IntCallback responseCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                             IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                             IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the number of physical processor sockets for the machine
     * running the node with the given name.
     *
     * Note that this method will return 1 on operating systems where
     * this can't be automatically determined and where the
     * IceGrid.Node.ProcessorSocketCount property for the node is not
     * set.
     *
     * @param result The asynchronous result object.
     * @return The number of processor sockets or 1 if the number of
     * sockets can't determined.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public int end_getNodeProcessorSocketCount(Ice.AsyncResult result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public void shutdownNode(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void shutdownNode(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> context);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, Ice.Callback cb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, Callback_Admin_shutdownNode cb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name, java.util.Map<String, String> context, Callback_Admin_shutdownNode cb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownNode(String name,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_VoidCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shutdown an IceGrid node.
     *
     * @param result The asynchronous result object.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public void end_shutdownNode(Ice.AsyncResult result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @return The node hostname.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public String getNodeHostname(String name)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The node hostname.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public String getNodeHostname(String name, java.util.Map<String, String> context)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> context);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, Ice.Callback cb);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, Callback_Admin_getNodeHostname cb);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name, java.util.Map<String, String> context, Callback_Admin_getNodeHostname cb);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name,
                                                 IceInternal.Functional_GenericCallback1<String> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name,
                                                 IceInternal.Functional_GenericCallback1<String> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<String> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the hostname of this node.
     *
     * @param name The node name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getNodeHostname(String name,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<String> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the hostname of this node.
     *
     * @param result The asynchronous result object.
     * @return The node hostname.
     *
     * @throws NodeNotExistException Raised if the node doesn't exist.
     *
     * @throws NodeUnreachableException Raised if the node could not be
     * reached.
     *
     **/
    public String end_getNodeHostname(Ice.AsyncResult result)
        throws NodeNotExistException,
               NodeUnreachableException;

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @return The node names.
     *
     **/
    public String[] getAllNodeNames();

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @return The node names.
     *
     **/
    public String[] getAllNodeNames(java.util.Map<String, String> context);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames();

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> context);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(Ice.Callback cb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(Callback_Admin_getAllNodeNames cb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> context, Callback_Admin_getAllNodeNames cb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllNodeNames(java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the IceGrid nodes currently registered.
     *
     * @param result The asynchronous result object.
     * @return The node names.
     *
     **/
    public String[] end_getAllNodeNames(Ice.AsyncResult result);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @return true if the registry ping succeeded, false otherwise.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public boolean pingRegistry(String name)
        throws RegistryNotExistException;

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @return true if the registry ping succeeded, false otherwise.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public boolean pingRegistry(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException;

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> context);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, Ice.Callback cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, Callback_Admin_pingRegistry cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name, java.util.Map<String, String> context, Callback_Admin_pingRegistry cb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name,
                                              IceInternal.Functional_BoolCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name,
                                              IceInternal.Functional_BoolCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_BoolCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_pingRegistry(String name,
                                              java.util.Map<String, String> context,
                                              IceInternal.Functional_BoolCallback responseCb,
                                              IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                              IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                              IceInternal.Functional_BoolCallback sentCb);

    /**
     * Ping an IceGrid registry to see if it is active.
     *
     * @param result The asynchronous result object.
     * @return true if the registry ping succeeded, false otherwise.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public boolean end_pingRegistry(Ice.AsyncResult result)
        throws RegistryNotExistException;

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @return The registry information.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     **/
    public RegistryInfo getRegistryInfo(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @return The registry information.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     **/
    public RegistryInfo getRegistryInfo(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> context);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, Ice.Callback cb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, Callback_Admin_getRegistryInfo cb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name, java.util.Map<String, String> context, Callback_Admin_getRegistryInfo cb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name,
                                                 IceInternal.Functional_GenericCallback1<RegistryInfo> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name,
                                                 IceInternal.Functional_GenericCallback1<RegistryInfo> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<RegistryInfo> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryInfo(String name,
                                                 java.util.Map<String, String> context,
                                                 IceInternal.Functional_GenericCallback1<RegistryInfo> responseCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                 IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                 IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get the registry information for the registry with the given name.
     *
     * @param result The asynchronous result object.
     * @return The registry information.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     **/
    public RegistryInfo end_getRegistryInfo(Ice.AsyncResult result)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @return A proxy to the IceGrid registry's admin object
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public Ice.ObjectPrx getRegistryAdmin(String name)
        throws RegistryNotExistException;

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param context The Context map to send with the invocation.
     * @return A proxy to the IceGrid registry's admin object
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public Ice.ObjectPrx getRegistryAdmin(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException;

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name, java.util.Map<String, String> context);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name, Ice.Callback cb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name, Callback_Admin_getRegistryAdmin cb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name, java.util.Map<String, String> context, Callback_Admin_getRegistryAdmin cb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param name The registry name
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getRegistryAdmin(String name,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_GenericCallback1<Ice.ObjectPrx> responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get a proxy to the IceGrid registry's admin object.
     *
     * @param result The asynchronous result object.
     * @return A proxy to the IceGrid registry's admin object
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     **/
    public Ice.ObjectPrx end_getRegistryAdmin(Ice.AsyncResult result)
        throws RegistryNotExistException;

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     **/
    public void shutdownRegistry(String name)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void shutdownRegistry(String name, java.util.Map<String, String> context)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> context);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, Ice.Callback cb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, Callback_Admin_shutdownRegistry cb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name, java.util.Map<String, String> context, Callback_Admin_shutdownRegistry cb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param name The registry name.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param userExceptionCb The lambda user exception callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdownRegistry(String name,
                                                  java.util.Map<String, String> context,
                                                  IceInternal.Functional_VoidCallback responseCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.UserException> userExceptionCb,
                                                  IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                  IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shutdown an IceGrid registry.
     *
     * @param result The asynchronous result object.
     * @throws RegistryNotExistException Raised if the registry doesn't exist.
     *
     * @throws RegistryUnreachableException Raised if the registry could not be
     * reached.
     *
     **/
    public void end_shutdownRegistry(Ice.AsyncResult result)
        throws RegistryNotExistException,
               RegistryUnreachableException;

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @return The registry names.
     *
     **/
    public String[] getAllRegistryNames();

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @return The registry names.
     *
     **/
    public String[] getAllRegistryNames(java.util.Map<String, String> context);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames();

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> context);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(Ice.Callback cb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(Callback_Admin_getAllRegistryNames cb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> context, Callback_Admin_getAllRegistryNames cb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> context,
                                                     IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getAllRegistryNames(java.util.Map<String, String> context,
                                                     IceInternal.Functional_GenericCallback1<String[]> responseCb,
                                                     IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                     IceInternal.Functional_BoolCallback sentCb);

    /**
     * Get all the IceGrid registries currently registered.
     *
     * @param result The asynchronous result object.
     * @return The registry names.
     *
     **/
    public String[] end_getAllRegistryNames(Ice.AsyncResult result);

    /**
     * Shut down the IceGrid registry.
     *
     **/
    public void shutdown();

    /**
     * Shut down the IceGrid registry.
     *
     * @param context The Context map to send with the invocation.
     **/
    public void shutdown(java.util.Map<String, String> context);

    /**
     * Shut down the IceGrid registry.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown();

    /**
     * Shut down the IceGrid registry.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context);

    /**
     * Shut down the IceGrid registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(Ice.Callback cb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(Callback_Admin_shutdown cb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context, Callback_Admin_shutdown cb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context,
                                          IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_shutdown(java.util.Map<String, String> context,
                                          IceInternal.Functional_VoidCallback responseCb,
                                          IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                          IceInternal.Functional_BoolCallback sentCb);

    /**
     * Shut down the IceGrid registry.
     *
     * @param result The asynchronous result object.
     **/
    public void end_shutdown(Ice.AsyncResult result);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums();

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> getSliceChecksums(java.util.Map<String, String> context);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums();

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Ice.Callback cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context, Ice.Callback cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(Callback_Admin_getSliceChecksums cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param cb The asynchronous callback object.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context, Callback_Admin_getSliceChecksums cb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param context The Context map to send with the invocation.
     * @param responseCb The lambda response callback.
     * @param exceptionCb The lambda exception callback.
     * @param sentCb The lambda sent callback.
     * @return The asynchronous result object.
     **/
    public Ice.AsyncResult begin_getSliceChecksums(java.util.Map<String, String> context,
                                                   IceInternal.Functional_GenericCallback1<java.util.Map<java.lang.String, java.lang.String>> responseCb,
                                                   IceInternal.Functional_GenericCallback1<Ice.Exception> exceptionCb,
                                                   IceInternal.Functional_BoolCallback sentCb);

    /**
     * Returns the checksums for the IceGrid Slice definitions.
     *
     * @param result The asynchronous result object.
     * @return A dictionary mapping Slice type ids to their checksums.
     *
     **/
    public java.util.Map<java.lang.String, java.lang.String> end_getSliceChecksums(Ice.AsyncResult result);
}
