/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.common.utils;

import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.ButtonModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sourceforge.glsof.common.i18n.Messages;

public class GButton {
    private JButton button;

    public GButton(String text) {
        this.button = new JButton(text);
    }

    public GButton(Icon image) {
        this.button = new JButton(image);
    }

    public JButton get() {
        return this.button;
    }

    public GButton tooltip(String text) {
        this.button.setToolTipText(text);
        return this;
    }

    public GButton focusPainted(boolean focus) {
        this.button.setFocusPainted(focus);
        return this;
    }

    public GButton opaque(boolean opaque) {
        this.button.setOpaque(opaque);
        return this;
    }

    public GButton contentAreaFilled(boolean filled) {
        this.button.setContentAreaFilled(filled);
        return this;
    }

    public static JButton createTipButton(String iconPath, String toolTip) {
        final JButton b = new GButton(new ImageIcon(GButton.class.getResource(iconPath))).focusPainted(false).opaque(false).contentAreaFilled(false).tooltip(Messages.NLS(toolTip)).get();
        final Border raisedBevelBorder = BorderFactory.createRaisedBevelBorder();
        Insets insets = raisedBevelBorder.getBorderInsets(b);
        final EmptyBorder emptyBorder = new EmptyBorder(insets);
        b.setBorder(emptyBorder);
        b.getModel().addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ButtonModel model = (ButtonModel)e.getSource();
                b.setBorder(model.isRollover() ? raisedBevelBorder : emptyBorder);
            }
        });
        return b;
    }
}

