/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.glsof.filemonitor;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import net.sourceforge.glsof.common.i18n.Messages;
import net.sourceforge.glsof.common.main.AbstractMainWindow;
import net.sourceforge.glsof.common.main.ActionButton;
import net.sourceforge.glsof.common.main.Observer;
import net.sourceforge.glsof.common.utils.GBC;
import net.sourceforge.glsof.common.utils.MessageDialog;
import net.sourceforge.glsof.filemonitor.FilterBar;
import net.sourceforge.glsof.filemonitor.MonitorPreferencesContainer;
import net.sourceforge.glsof.filemonitor.MonitorTable;
import net.sourceforge.glsof.filemonitor.PreferencesTable;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorPreferencesRepository;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorUIConf;
import net.sourceforge.glsof.filemonitor.repository.FileMonitorUIConfRepository;

public class FileMonitorWindow
extends AbstractMainWindow
implements Observer {
    private static final String START_BUTTON = "/icons/fm-start.png";
    private static final String STOP_BUTTON = "/icons/fm-stop.png";
    private static final String AUTOSCROLL_BUTTON = "/icons/autoscroll.png";
    private static final String AUTOSCROLL_STOP_BUTTON = "/icons/autoscroll-stop.png";
    private static final String CLEAR_BUTTON = "/icons/fm-clear.png";
    private static final String SETTINGS_DIR = ".glsof" + File.separator + "filemonitor";
    private static final String MENU_ICON = "/icons/menu.png";
    private static final String WEBSITE_URL = "http://glsof.sourceforge.net/";
    private static final String DOCUMENTATION_URL = "http://glsof.sourceforge.net/filemonitor/";
    private FileMonitorPreferencesRepository _preferencesRepository;
    private FileMonitorUIConfRepository _uiConfRepository;
    private JMenuItem _showPreferencesMenuItem;
    private List<Observer> _observers;

    @Override
    protected String version() {
        return "2.4.1";
    }

    public static void main(String[] args) {
        Messages.initNLS("nl.common");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FileMonitorWindow();
            }
        });
    }

    public FileMonitorWindow() {
        super(GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0], Messages.NLS("GLSOF_Filemonitor"));
    }

    @Override
    protected void initRepositories() {
        File settingsDir = this.createSettingsDir(SETTINGS_DIR);
        this._uiConfRepository = new FileMonitorUIConfRepository(settingsDir.getParentFile());
        this._preferencesRepository = new FileMonitorPreferencesRepository(settingsDir);
    }

    @Override
    protected void createContents(JPanel mainContainer) {
        final FileMonitorUIConf uiConf = this._uiConfRepository.read();
        this._preferencesRepository.load(uiConf.getSelectedPreference());
        MonitorTable monitorTable = new MonitorTable(this._preferencesRepository);
        final PreferencesTable preferencesTable = new PreferencesTable(monitorTable, this._preferencesRepository);
        MonitorPreferencesContainer hForm = new MonitorPreferencesContainer(monitorTable.pack(), preferencesTable.pack());
        FilterBar filterBar = new FilterBar(monitorTable);
        this._observers = new LinkedList<Container>(Arrays.asList(this, monitorTable, preferencesTable, hForm, filterBar));
        JButton autoscrollButton = new ActionButton(this._observers, uiConf.isAutoscroll() ? AUTOSCROLL_STOP_BUTTON : AUTOSCROLL_BUTTON, "Autoscroll"){

            @Override
            protected void execute() {
                boolean autoscroll = !uiConf.isAutoscroll();
                uiConf.setAutoscroll(autoscroll);
                this.getButton().setIcon(this.getIcon(autoscroll ? FileMonitorWindow.AUTOSCROLL_STOP_BUTTON : FileMonitorWindow.AUTOSCROLL_BUTTON));
                this.notify(Observer.NOTIFY.AUTOSCROLL, autoscroll);
            }
        }.getButton();
        JButton clearButton = new ActionButton(this._observers, CLEAR_BUTTON, "Clear"){

            @Override
            protected void execute() {
                this.notify(Observer.NOTIFY.CLEAR, new Object[0]);
            }
        }.getButton();
        JButton startButton = new ActionButton(this._observers, START_BUTTON, Messages.START){

            @Override
            protected void execute() {
                if (this.getButton().getToolTipText().equals(Messages.START)) {
                    try {
                        if (this.readyToStart()) {
                            this.notify(Observer.NOTIFY.START, new Object[0]);
                            this.changeStartButton(Messages.STOP, FileMonitorWindow.STOP_BUTTON);
                        }
                    }
                    catch (Exception e) {
                        MessageDialog.warning(null, Messages.NLS("Start_problem"));
                    }
                } else {
                    this.notify(Observer.NOTIFY.STOP, new Object[0]);
                    this.changeStartButton(Messages.START, FileMonitorWindow.START_BUTTON);
                }
            }

            private void changeStartButton(String text, String buttonIcon) {
                this.getButton().setToolTipText(text);
                this.getButton().setIcon(this.getIcon(buttonIcon));
            }

            private boolean readyToStart() {
                if (preferencesTable.noPreferences()) {
                    MessageDialog.warning(FileMonitorWindow.this, Messages.NLS("Create_Preference_Before_Start"));
                    return false;
                }
                if (preferencesTable.noSelectedPreferences()) {
                    MessageDialog.warning(FileMonitorWindow.this, Messages.NLS("Select_Preference_Before_Start"));
                    return false;
                }
                return true;
            }
        }.getButton();
        mainContainer.add((Component)filterBar, new GBC().gridx(0).gridy(0).fill(2).weightx(1.0).insets(new Insets(5, 5, 5, 5)).get());
        mainContainer.add((Component)new JSeparator(1), new GBC().gridx(1).gridy(0).fill(1).insets(new Insets(5, 5, 5, 5)).get());
        mainContainer.add((Component)autoscrollButton, new GBC().gridx(2).gridy(0).fill(0).insets(new Insets(5, 5, 5, 5)).get());
        mainContainer.add((Component)clearButton, new GBC().gridx(3).gridy(0).fill(0).insets(new Insets(5, 5, 5, 5)).get());
        mainContainer.add((Component)startButton, new GBC().gridx(4).gridy(0).fill(0).insets(new Insets(5, 5, 5, 5)).get());
        mainContainer.add((Component)this._menuBar, new GBC().gridx(5).gridy(0).fill(2).insets(new Insets(5, 5, 5, 5)).get());
        mainContainer.add((Component)hForm, new GBC().gridx(0).gridy(1).gridwidth(6).fill(1).weightx(1.0).weighty(1.0).insets(new Insets(5, 5, 5, 5)).get());
        this.setWindowBounds(uiConf.getWindowBounds());
        hForm.pack();
    }

    @Override
    protected void createMenuItems() {
        ImageIcon icon = new ImageIcon(this.getClass().getResource(MENU_ICON));
        this._menuBar.setBorder(BorderFactory.createEtchedBorder());
        this._menuBar.setMinimumSize(new Dimension(icon.getIconWidth() + 16, icon.getIconHeight()));
        JMenu menu = this.createMenu(icon, Messages.NLS("Menu"));
        menu.setMnemonic(77);
        this.createShowPreferencesItem(menu);
        this.createFullscreenItem(menu);
        this.createAboutItem(menu, "/icons/glsof-banner-fm.png", Messages.NLS("Description"), this.version(), WEBSITE_URL, DOCUMENTATION_URL);
        menu.addSeparator();
        this.createExitItem(menu);
    }

    private void createShowPreferencesItem(JMenu menu) {
        this._showPreferencesMenuItem = this.createMenuItem(menu, "show-preferences", Messages.NLS("Preferences"), KeyStroke.getKeyStroke(80, 2), null);
        this._showPreferencesMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                FileMonitorWindow.this.notify(Observer.NOTIFY.TOGGLE, new Object[]{FileMonitorWindow.this.getWidth()});
            }
        });
    }

    @Override
    public void update(Observer.NOTIFY notify, Object ... params) {
        if (notify == Observer.NOTIFY.START) {
            this.setTitle(Messages.NLS("Current_preference") + FileMonitorPreferencesRepository.getCurrentPreferences().getName());
            this._showPreferencesMenuItem.setEnabled(false);
        } else if (notify == Observer.NOTIFY.STOP) {
            this._showPreferencesMenuItem.setEnabled(true);
        }
    }

    private void notify(Observer.NOTIFY notify, Object ... params) {
        for (Observer observer : this._observers) {
            observer.update(notify, params);
        }
    }

    @Override
    protected void close() {
        this.notify(Observer.NOTIFY.CLOSE, new Object[0]);
        FileMonitorUIConfRepository.getUiConf().setWindowBounds(this.getBounds());
        this._uiConfRepository.save(FileMonitorUIConfRepository.getUiConf());
    }
}

